/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index;

import com.trs.index.util.IndexUtil;
import com.trs.index.vo.IndexField;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;

public class Consumer
implements Runnable {
    private BlockingQueue<IndexField> queue;
    private IndexWriter writer;
    private int dealNum = 0;
    private boolean isRunning = true;
    private boolean isMerged = false;
    private static Logger m_oLogger = Logger.getLogger(Consumer.class);

    public Consumer(BlockingQueue<IndexField> queue, IndexWriter writer) {
        this.queue = queue;
        this.writer = writer;
        this.isRunning = true;
    }

    @Override
    public void run() {
        try {
            while (this.isRunning) {
                IndexField indexField = this.queue.poll(3L, TimeUnit.SECONDS);
                if (indexField == null) {
                    m_oLogger.info((Object)"indexField == null");
                    this.isRunning = false;
                    break;
                }
                ++this.dealNum;
                Document doc = IndexUtil.field2Doc(indexField);
                this.writer.addDocument(doc);
            }
            this.writer.commit();
        }
        catch (InterruptedException e) {
            this.isRunning = false;
            m_oLogger.info((Object)("InterruptedException" + e));
        }
        catch (Exception e) {
            m_oLogger.info((Object)"\u5f02\u5e38\u629b\u51fa");
            e.printStackTrace();
            this.isRunning = false;
            try {
                this.writer.commit();
            }
            catch (CorruptIndexException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Thread.currentThread().interrupt();
        }
    }

    public int getDealNum() {
        return this.dealNum;
    }

    public boolean getIsRunning() {
        return this.isRunning;
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    public void setMerged(boolean isMerged) {
        this.isMerged = isMerged;
    }
}

