/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.chart;

import com.trs.components.wcm.stat.StatFieldMap;
import com.trs.components.wcm.stat.StatFieldMaps;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.util.CMyString;
import de.laures.cewolf.DatasetProducer;
import java.util.Date;
import java.util.Map;
import org.jfree.data.general.DefaultPieDataset;

public final class PieChartProducer
implements DatasetProducer {
    private static final String PRODUCER_ID = "PicChartProducer";
    public static final String PARAM_UNIQUENAME = "UniqueName";
    public static final String PARAM_COMPAREDFIELD = "ComparedField";
    public static final String PARAM_VIEWID = "ViewId";
    private transient CMyResultSets statResults = null;
    private transient StatFieldMaps statFieldMaps = null;

    public Object produceDataset(Map _params) {
        String sUniqueName = (String)_params.get(PARAM_UNIQUENAME);
        String sComparedFieldName = (String)_params.get(PARAM_COMPAREDFIELD);
        return this.getDataSet(sUniqueName, sComparedFieldName);
    }

    private DefaultPieDataset getDataSet(String _sUniqueName, String _sComparedField) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        CMyResultSets results = this.getStatResults();
        if (results == null || results.size() == 0) {
            return dataset;
        }
        CMyResultSet result = null;
        if (_sUniqueName == null) {
            StatFieldMaps fields = this.getStatFieldMaps();
            String[] names = new String[fields.size()];
            String[] descs = new String[names.length];
            String[] types = new String[descs.length];
            for (int i = 0; i < fields.size(); ++i) {
                StatFieldMap field = (StatFieldMap)fields.getAt(i);
                names[i] = field.getFieldName();
                descs[i] = field.getFieldDesc();
                types[i] = field.getFieldType();
            }
            result = (CMyResultSet)results.getAt(0);
            Object value = null;
            for (int i = 0; i < names.length; ++i) {
                value = result.getProperty(names[i]);
                if (!(value instanceof Number)) continue;
                dataset.setValue((Comparable)((Object)descs[i]), (double)((Number)value).intValue());
            }
            return dataset;
        }
        for (int i = 0; i < results.size(); ++i) {
            result = (CMyResultSet)results.getAt(i);
            int nValue = result.getPropertyAsInt(_sComparedField, 0);
            String sName = this.makeUniqueName(result, _sUniqueName);
            Number nExistsValue = dataset.getValue((Comparable)((Object)sName));
            if (nExistsValue == null) {
                dataset.setValue((Comparable)((Object)sName), (double)nValue);
                continue;
            }
            dataset.setValue((Comparable)((Object)sName), (double)(nValue + nExistsValue.intValue()));
        }
        return dataset;
    }

    private String makeUniqueName(CMyResultSet _result, String _sUniqueName) {
        if (CMyString.isEmpty(_sUniqueName)) {
            return PARAM_UNIQUENAME;
        }
        String[] uniquenames = CMyString.split(_sUniqueName, ",");
        String uniqueName = _result.getPropertyAsString(uniquenames[0]);
        for (int i = 1; i < uniquenames.length; ++i) {
            uniqueName = uniqueName + ":" + _result.getPropertyAsString(uniquenames[i]);
        }
        return uniqueName;
    }

    public boolean hasExpired(Map _params, Date _since) {
        return false;
    }

    public String getProducerId() {
        return PRODUCER_ID;
    }

    public final CMyResultSets getStatResults() {
        return this.statResults;
    }

    public final void setStatResults(CMyResultSets results) {
        this.statResults = results;
    }

    public final StatFieldMaps getStatFieldMaps() {
        return this.statFieldMaps;
    }

    public final void setStatFieldMaps(StatFieldMaps statFieldMaps) {
        this.statFieldMaps = statFieldMaps;
    }
}

