/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class StatHost
extends CMSObj {
    public static final int OBJ_TYPE = 486152215;
    public static final String DB_TABLE_NAME = "WCMSTATHOST";
    public static final String DB_ID_NAME = "STATHOSTID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 486152215;
    }

    public String getHostName() {
        return this.getPropertyAsString("HOSTNAME");
    }

    public boolean setHostName(String _sHostName) throws WCMException {
        return this.setProperty("HOSTNAME", _sHostName);
    }

    public String getHostDesc() {
        return this.getPropertyAsString("HOSTDESC");
    }

    public boolean setHostDesc(String _sHostDesc) throws WCMException {
        return this.setProperty("HOSTDESC", _sHostDesc);
    }

    public String getWCMTableName() {
        return this.getPropertyAsString("WCMTABLENAME");
    }

    public boolean setWCMTableName(String _sWCMTableName) throws WCMException {
        return this.setProperty("WCMTABLENAME", _sWCMTableName);
    }

    public int getHostType() {
        return this.getPropertyAsInt("HOSTTYPE", 0);
    }

    public boolean setHostType(int _nHostType) throws WCMException {
        return this.setProperty("HOSTTYPE", _nHostType);
    }

    public String getWCMTableId() {
        return this.getPropertyAsString("WCMTABLEID");
    }

    public boolean setWCMTableId(String _sWCMTableId) throws WCMException {
        return this.setProperty("WCMTABLEID", _sWCMTableId);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = this.getPropertyAsString("HOSTNAME");
            if (sName == null) {
                throw new WCMException(10, I18NMessage.get(StatHost.class, "StatHost.label1", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(StatHost.class, "StatHost.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(StatHost.isValid)"));
            }
            sName = this.getNewPropertyAsString("HOSTNAME");
        }
        if (sName != null) {
            String sCondition = "HOSTNAME='" + CMyString.filterForSQL(sName) + "'";
            if (!this.isAddMode()) {
                sCondition = sCondition + " AND (STATHOSTID>" + this.getId() + " OR " + DB_ID_NAME + "<" + this.getId() + ")";
            }
            if (this.checkExists(sCondition)) {
                throw new WCMException(1108, I18NMessage.get(StatHost.class, "StatHost.label3", "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[") + sName + I18NMessage.get(StatHost.class, "StatHost.label4", "]\u7684\u7edf\u8ba1\u4e3b\u4f53,\u7edf\u8ba1\u4e3b\u4f53\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u5fc5\u987b\u552f\u4e00!"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final StatHost findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (StatHost)BaseObj.findById(StatHost.class, _nId);
    }

    public static final StatHost createNewInstance() throws WCMException {
        return (StatHost)BaseObj.createNewInstance(StatHost.class);
    }

    public static final StatHost findByKey(Object _oKey) throws WCMException {
        return (StatHost)BaseObj.findByKey(StatHost.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getHostName();
        }
        return this.getHostName() + I18NMessage.get(StatHost.class, "StatHost.label5", "[\u7edf\u8ba1\u4e3b\u4f53-") + this.getId() + "]";
    }
}

