/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.region.CellInfo;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class WCMTagParserRegion
implements ITagParser {
    private TagItem m_tagItem = null;
    private StringBuffer m_sbBeforeOfRow = new StringBuffer();
    private StringBuffer m_sbEndOfRow = new StringBuffer();
    private TagItem m_currCellItem = null;
    private static TagBeanInfo s_TagBeanInfo = null;
    private static ArrayList FIELDS_DEFAULT_LIST = new ArrayList(16);
    private static HashMap FIELDS_MAP;

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _o_root) throws WCMException {
        return null;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_REGION");
            tbi.setDesc("\u680f\u76ee\u5bfc\u8bfb\u89e3\u6790\u5668");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDINDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ROWNUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEX");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PREFIX");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        boolean bHasName;
        BaseChannel currHostObj = WCMTagParserHelper.findFolderHost(this.m_tagItem, _context, false);
        int nRegionIndex = _context.getAttribute("Index", 0);
        String sRegionName = _context.getAttribute("name");
        int nHostId = currHostObj.getId();
        RegionInfo regionInfo = null;
        boolean bl = bHasName = sRegionName != null && !"".equals(sRegionName.trim());
        if (currHostObj instanceof Channel) {
            regionInfo = bHasName ? RegionInfo.findByName(sRegionName) : RegionInfo.findByChannelId(nHostId, nRegionIndex);
        } else if (currHostObj instanceof WebSite) {
            RegionInfo regionInfo2 = regionInfo = bHasName ? RegionInfo.findByName(sRegionName) : RegionInfo.findBySiteId(nHostId, nRegionIndex);
        }
        if (regionInfo == null) {
            return null;
        }
        CellInfos cellInfos = CellInfos.findCellInfos(regionInfo, null);
        if (cellInfos.isEmpty()) {
            return null;
        }
        this.analyerCellItem();
        if (this.m_currCellItem == null) {
            String sFieldName = _context.getAttribute("field");
            if (CMyString.isEmpty(sFieldName)) {
                return null;
            }
            String sFieldValue = regionInfo.getPropertyAsString(sFieldName);
            if ("RegionFontSize".equalsIgnoreCase(sFieldName)) {
                String sPrefix = CMyString.showNull(_context.getAttribute("prefix"));
                return new String[]{"." + sPrefix + "{font-size:" + sFieldValue + "px;}"};
            }
            return new String[]{sFieldValue};
        }
        boolean bFind = false;
        StringBuffer sbResult = new StringBuffer(cellInfos.size() * 100);
        int nSize = cellInfos.size();
        for (int i = 0; i < nSize; ++i) {
            boolean bLinkType;
            CellInfo cellInfo = (CellInfo)cellInfos.getAt(i);
            if (cellInfo == null) continue;
            boolean bl2 = bLinkType = !CMyString.isEmpty(cellInfo.getDocTitle()) && Pattern.compile("<a(.*)</a>", 2).matcher(cellInfo.getDocTitle().toLowerCase()).groupCount() > 0;
            if (cellInfo.getDocId() <= 0 && cellInfo.getChnlId() <= 0 && !bLinkType) continue;
            Document document = Document.findById(cellInfo.getDocId(), "DocId");
            Channel channel = Channel.findById(cellInfo.getChnlId());
            if (document == null && channel == null && !bLinkType) continue;
            bFind = true;
            i = this.parseRowContent(cellInfos, i, _context, sbResult);
        }
        if (!bFind) {
            return null;
        }
        return new String[]{sbResult.toString()};
    }

    private int parseRowContent(CellInfos cellInfos, int nStartIndex, PublishTagContext _oContext, StringBuffer _sbResult) throws WCMException {
        CellInfo cellInfo;
        int nCurrIndex;
        CellInfo oStartCellInfo = (CellInfo)cellInfos.getAt(nStartIndex);
        int nCurrRowIndex = oStartCellInfo.getRowIndex();
        StringBuffer sbRowContent = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("REGION_ROWNO", String.valueOf(nCurrRowIndex));
        String sBeforeOfRow = CMyString.parsePageVariables(this.m_sbBeforeOfRow.toString(), map);
        sbRowContent.append(sBeforeOfRow);
        int nSize = cellInfos.size();
        for (nCurrIndex = nStartIndex; nCurrIndex < nSize && nCurrRowIndex == (cellInfo = (CellInfo)cellInfos.getAt(nCurrIndex)).getRowIndex(); ++nCurrIndex) {
            IPublishFolder folder;
            IPublishElement content;
            String sNewDocTitle = cellInfo.getDocTitle();
            if (CMyString.isEmpty(sNewDocTitle)) continue;
            Document document = Document.findById(cellInfo.getDocId(), this.getDocumentSelectFields(_oContext));
            Channel channel = Channel.findById(cellInfo.getChnlId());
            if (document == null && channel == null) {
                if (Pattern.compile("<a(.*)</a>", 2).matcher(sNewDocTitle.toLowerCase()).groupCount() <= 0) continue;
                sbRowContent.append(sNewDocTitle);
                continue;
            }
            if (document != null) {
                if (document.getStatusId() != 10) continue;
                content = PublishElementFactory.makeContentFrom(document, null);
                int nAppendixId = cellInfo.getAppendixId();
                if (nAppendixId > 0 && Pattern.compile("<a(.*)</a>", 2).matcher(sNewDocTitle.toLowerCase()).groupCount() > 0) {
                    Appendix cuApp = Appendix.findById(nAppendixId);
                    if (cuApp == null) continue;
                    IPublishElement contentEl = PublishElementFactory.makeElementFrom(document);
                    PublishPathCompass compass = new PublishPathCompass();
                    String sUrl = compass.getAbsoluteHttpPath(contentEl);
                    sUrl = HtmlUtil.calRelativePath(sUrl, _oContext.getPageHttpPath());
                    WCMAppendixGenerator.generateAppendix(cuApp, (IPublishContent)content, _oContext, 0);
                    sNewDocTitle = sNewDocTitle.toLowerCase().replaceAll("<a[^>]*>(.*)", "$1").replaceAll("</a>", "");
                    sNewDocTitle = "<a href=" + sUrl + cuApp.getFile() + ">" + sNewDocTitle + "</a>";
                    sbRowContent.append(sNewDocTitle);
                    continue;
                }
                if (!CMyString.isEmpty(sNewDocTitle) && document != null) {
                    int nRecId = cellInfo.getRecId();
                    ChnlDoc chnlDoc = ChnlDoc.findById(nRecId);
                    Channel hostChannel = chnlDoc.getChannel();
                    if (hostChannel == null) continue;
                    IPublishFolder folder2 = (IPublishFolder)PublishElementFactory.makeElementFrom(hostChannel);
                    content.setFolder(folder2);
                    if (!_oContext.isPreview() && !PublishServer.isValidateElement(content)) continue;
                    document.getProperties().put("DOCTITLE", sNewDocTitle);
                }
                PublishTagContext tagContext = new PublishTagContext(_oContext, this.m_currCellItem, content);
                String[] pItemResult = TagParseHelper.parseItems(this.m_currCellItem.getChildren(), tagContext);
                if (pItemResult == null) continue;
                sbRowContent.append(pItemResult[0]);
                continue;
            }
            if (channel == null || !(folder = (content = PublishElementFactory.makeElementFrom(channel)).getFolder()).canDoOutlinePageTask()) continue;
            PublishPathCompass compass = new PublishPathCompass();
            String sUrl = compass.getAbsoluteHttpPath(content);
            sUrl = HtmlUtil.calRelativePath(sUrl, _oContext.getPageHttpPath());
            if (CMyString.isEmpty(sNewDocTitle)) continue;
            sNewDocTitle = "<a href=" + sUrl + ">" + sNewDocTitle + "</a>";
            sbRowContent.append(sNewDocTitle);
        }
        map.put("REGION_ROWNO", String.valueOf(nCurrRowIndex));
        String sEndOfRow = CMyString.parsePageVariables(this.m_sbEndOfRow.toString(), map);
        sbRowContent.append(sEndOfRow);
        _sbResult.append(sbRowContent);
        int nNextCellIndex = nCurrIndex - 1;
        return nNextCellIndex;
    }

    private void analyerCellItem(TagItem tagItem) {
        List arChildren = tagItem.getChildren();
        if (arChildren == null) {
            return;
        }
        int nSize = arChildren.size();
        for (int i = 0; i < nSize; ++i) {
            TagItem temp;
            Object child = arChildren.get(i);
            if (child instanceof String) {
                if (this.m_currCellItem == null) {
                    this.m_sbBeforeOfRow.append(child);
                    continue;
                }
                this.m_sbEndOfRow.append(child);
                continue;
            }
            if (!(child instanceof TagItem) || !(temp = (TagItem)child).getName().equalsIgnoreCase("TRS_CELL")) continue;
            this.m_currCellItem = temp;
        }
    }

    private void analyerCellItem() {
        List arChildren = this.m_tagItem.getChildren();
        if (arChildren == null) {
            return;
        }
        int nSize = arChildren.size();
        for (int i = 0; i < nSize; ++i) {
            TagItem temp;
            Object child = arChildren.get(i);
            if (child instanceof String) {
                if (this.m_currCellItem == null) {
                    this.m_sbBeforeOfRow.append(child);
                    continue;
                }
                this.m_sbEndOfRow.append(child);
                continue;
            }
            if (!(child instanceof TagItem) || !(temp = (TagItem)child).getName().equalsIgnoreCase("TRS_CELL")) continue;
            this.m_currCellItem = temp;
        }
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDocumentSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
        if (sSelectFields == null) {
            TagItem tagItem = this.m_tagItem;
            synchronized (tagItem) {
                sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_tagContext);
                    this.m_tagItem.setExtraAttribute("SELECT", sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = (String)FIELDS_DEFAULT_LIST.get(0);
        int nSize = FIELDS_DEFAULT_LIST.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + FIELDS_DEFAULT_LIST.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(this.m_tagItem, "TRS_DOCUMENT");
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (FIELDS_DEFAULT_LIST.indexOf(sFieldName) >= 0) continue;
            String sMapField = (String)FIELDS_MAP.get(sFieldName);
            if (sMapField != null) {
                sFieldName = sMapField;
            }
            try {
                if (dbMgr.getFieldInfo("WCMDOCUMENT", sFieldName) == null) {
                    _tagContext.addWarning("TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[" + sFieldName + "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01");
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning("\u83b7\u53d6\u6307\u5b9a\u7684Field[" + sFieldName + "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01" + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        String sSelect = _tagContext.getAttribute("SELECT");
        if (!CMyString.isEmpty(sSelect)) {
            sSelectFields = sSelectFields + "," + sSelect;
        }
        return sSelectFields;
    }

    static {
        FIELDS_DEFAULT_LIST.add("DOCID");
        FIELDS_DEFAULT_LIST.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST.add("DOCTYPE");
        FIELDS_DEFAULT_LIST.add("DOCTITLE");
        FIELDS_DEFAULT_LIST.add("DOCKEYWORDS");
        FIELDS_DEFAULT_LIST.add("CRUSER");
        FIELDS_DEFAULT_LIST.add("CRTIME");
        FIELDS_DEFAULT_LIST.add("DocFlag");
        FIELDS_DEFAULT_LIST.add("TITLECOLOR");
        FIELDS_DEFAULT_LIST.add("DOCLINK");
        FIELDS_DEFAULT_LIST.add("DOCFILENAME");
        FIELDS_DEFAULT_LIST.add("DOCVERSION");
        FIELDS_DEFAULT_LIST.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST.add("DOCPUBTIME");
        FIELDS_DEFAULT_LIST.add("DOCSOURCENAME");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
    }

    private class TBI
    extends TagBeanInfo {
        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
            TagBeanInfoHelper.checkChannelName(_folder, _tagItem, _sbResult);
            WCMTagParserRegion.this.analyerCellItem(_tagItem);
        }
    }
}

