/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmploy;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import java.util.List;
import org.apache.log4j.Logger;

public class ChannelDocListenerForPublish
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(ChannelDocListenerForPublish.class);

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (!(objModified instanceof ChnlDoc)) {
            s_logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + objModified.getClass() + "]\u7684\u4fee\u6539\uff01"));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)objModified;
        if (chnlDoc.isChangeProperty("DOCSTATUS") && chnlDoc.isPublished() && chnlDoc.getNewPropertyAsInt("DOCSTATUS", 0) < 0) {
            this.updateRegionEmployAndPublish(chnlDoc.getDocId());
        }
    }

    private void updateRegionEmployAndPublish(int _nDocId) throws WCMException {
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys oRegionEmploys = this.getRegionEmploysByObj(_nDocId);
        if (oRegionEmploys == null || oRegionEmploys.size() == 0) {
            s_logger.debug((Object)("\u6587\u6863[" + _nDocId + "]\u6ca1\u6709\u88ab\u4efb\u4f55\u5bfc\u8bfb\u4f7f\u7528\uff01"));
            return;
        }
        for (int i = 0; i < oRegionEmploys.size(); ++i) {
            int nRegionId;
            RegionInfo oRegion;
            RegionEmploy oRegionEmploy = (RegionEmploy)oRegionEmploys.getAt(i);
            if (oRegionEmploy == null || (oRegion = RegionInfo.findById(nRegionId = oRegionEmploy.getRegionId())) == null) continue;
            this.deleteRegionCell(oRegion, _nDocId);
            int[] types = new int[]{102};
            RegionEmploys oTempRegionEmploys = regionEmployMgr.getRegionEmploysByRegionAndType(nRegionId, types);
            if (oTempRegionEmploys == null) continue;
            for (int j = 0; j < oTempRegionEmploys.size(); ++j) {
                List employers;
                int nTemplateId;
                Template oTemplate;
                RegionEmploy oTempRegionEmploy = (RegionEmploy)oTempRegionEmploys.getAt(j);
                if (oTempRegionEmploy == null || (oTemplate = Template.findById(nTemplateId = oTempRegionEmploy.getObjId())) == null || (employers = templateEmployMgr.getEmployers(oTemplate, null)) == null) continue;
                this.publishHost(employers);
            }
            oRegionEmploys.removeAll();
        }
    }

    private RegionEmploys getRegionEmploysByObj(int _nDocId) throws WCMException {
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys oRegionEmploys = regionEmployMgr.getRegionEmploysByObj(_nDocId, 605);
        return oRegionEmploys;
    }

    private void deleteRegionCell(RegionInfo oRegion, int docId) throws WCMException {
        WCMFilter filter = new WCMFilter("", "DocId=?", "");
        filter.addSearchValues(docId);
        CellInfos cells = CellInfos.findCellInfos(oRegion, filter);
        cells.removeAll();
    }

    private void publishHost(List _employer) throws WCMException {
        for (int k = 0; k < _employer.size(); ++k) {
            int nRightIndex;
            IPublishElement content = (IPublishElement)_employer.get(k);
            if (content == null) continue;
            int type = content.getType();
            int n = nRightIndex = type == 103 ? 5 : 17;
            if (!AuthServer.hasRight(ContextHelper.getLoginUser(), content.getSubstance(), nRightIndex)) {
                s_logger.debug((Object)("\u7528\u6237" + ContextHelper.getLoginUser() + "\u6ca1\u6709\u6743\u9650\u53d1\u5e03\uff1a" + content.getSubstance()));
                continue;
            }
            IPublishFolder folder = content.getFolder();
            if (!folder.canDoOutlinePageTask()) continue;
            PublishServer oPublishServer = PublishServer.getInstance();
            oPublishServer.publishFolder((IPublishFolder)content, 8);
        }
    }
}

