/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.components.ckm.ICKMServer;
import com.trs.components.ckm.TRSCKMServer;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoviewDataProcessor;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.WCMDocumentHelper;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.IDocumentImporterConverter;
import com.trs.components.wcm.content.domain.XmlToDocumentConverter;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.util.MetaDataUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DocumentImporter {
    private static final String DEFINE_XML_FILE = "define.xml";
    private static final String TRS_XSL_FILE = "trs.xsl";
    private static final String CHILD_TAG_APPENDIXES = "WCMAPPENDIXS";
    private static final String CHILD_TAG_CHNLDOCS = "WCMCHNLDOCS";
    private static Logger s_logger = Logger.getLogger(DocumentImporter.class);
    private DocumentMgr m_documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private static final String FILEEXT_ZIP = "zip";
    private static final String FILEEXT_XML = "xml";
    private static final String FILEEXT_HTML = "html";
    private static final String FILEEXT_HTM = "htm";
    private static final int TYPE_ZIP = 1;
    private static final int TYPE_XML = 2;
    private static final int TYPE_HTML = 3;
    private static final int TYPE_UNSUPPORT = 4;
    private boolean m_bImportFromTRS = false;
    private XmlToDocumentConverter m_converter;
    private Reports m_importReports;
    private static String m_sSourceFilePath;
    private static String[] HTML_TAG_NAMES;
    private static String[] HTML_TAG_SRCS;
    private IMetaViewEmployerMgr m_MetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private boolean m_bImportCurrent;
    private static List implementors;

    public DocumentImporter() {
        this.m_converter = new XmlToDocumentConverter(1);
        this.m_converter.registPersistentObj("WCMDOCUMENT", Document.class);
        this.m_converter.registPersistentObj("WCMCHNLDOC", ChnlDoc.class);
        this.m_converter.registPersistentObj("WCMAPPENDIX", Appendix.class);
        try {
            this.m_bImportCurrent = "true".equals(ConfigServer.getServer().getInitProperty("IMPORTDOC_TOCURR_WHEN_SCNOTEXISTS"));
        }
        catch (Exception e) {
            if (s_logger.isDebugEnabled()) {
                s_logger.error((Object)"faile to read init config", (Throwable)e);
            }
            this.m_bImportCurrent = false;
        }
        try {
            List aimplementors = DocumentImporter.getImplementors();
            for (IDocumentImporterConverter implementor : aimplementors) {
                implementor.registerConverter(this.m_converter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List getImplementors() throws Exception {
        String iterfaceName = IDocumentImporterConverter.class.getName();
        if (implementors == null) {
            Iterator itrImplementors = WCMDiscoveryFactory.getDiscovery().getImplementors(iterfaceName);
            implementors = new ArrayList();
            while (itrImplementors != null && itrImplementors.hasNext()) {
                String sImplementor = (String)itrImplementors.next();
                implementors.add(Class.forName(sImplementor).newInstance());
            }
        }
        return implementors;
    }

    public Reports importFromFile(String _sImportFile, Channel _channel, String _sXslFile, boolean _bExitWhenDocumentExisted, boolean _bOmitOriginalChannel, boolean bImportbyName) throws WCMException {
        if (_bOmitOriginalChannel) {
            return this.importFromFile(_sImportFile, _channel, _sXslFile, _bExitWhenDocumentExisted, _bOmitOriginalChannel);
        }
        return this.importFromFileByName(_sImportFile, _channel, _sXslFile, _bExitWhenDocumentExisted, _bOmitOriginalChannel, bImportbyName);
    }

    public Reports importFromFileByName(String _sImportFile, Channel _channel, String _sXslFile, boolean _bExitWhenDocumentExisted, boolean _bOmitOriginalChannel, boolean bImportbyName) throws WCMException {
        if (_bOmitOriginalChannel && _channel == null) {
            throw new BizError(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label1", "\u6ca1\u6709\u6307\u5b9a\u5bfc\u5165\u6587\u6863\u7684\u76ee\u6807\u680f\u76ee!"));
        }
        this.m_importReports = new Reports("");
        String sImportFile = this.getFullFileName(_sImportFile);
        String sXslFile = this.getXslFileFullName(this.getLoginUser(), _sXslFile);
        if (!bImportbyName) {
            this.importDocuments(sImportFile, _channel, sXslFile, _bExitWhenDocumentExisted, _bOmitOriginalChannel);
        } else {
            this.importDocuments(sImportFile, _channel, sXslFile, _bExitWhenDocumentExisted, _bOmitOriginalChannel, bImportbyName);
        }
        this.setReportsTitle();
        return this.m_importReports;
    }

    public Reports importFromFile(String _sImportFile, Channel _channel, String _sXslFile, boolean _bExitWhenDocumentExisted, boolean _bOmitOriginalChannel) throws WCMException {
        return this.importFromFileByName(_sImportFile, _channel, _sXslFile, _bExitWhenDocumentExisted, _bOmitOriginalChannel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reports importFromTRSFile(String _sImportFile, Channel _channel, String _sDefineXmlForTRServer, boolean _bExitWhenDocumentExisted, boolean _bOmitOriginalChannel) throws WCMException {
        if (_bOmitOriginalChannel && _channel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label1", "\u6ca1\u6709\u6307\u5b9a\u5bfc\u5165\u6587\u6863\u7684\u76ee\u6807\u680f\u76ee!"));
        }
        if (_sDefineXmlForTRServer == null || _sDefineXmlForTRServer.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label2", "\u6ca1\u6709\u6307\u5b9a\u4eceTRS Server\u5bfc\u5165\u65f6\u7684\u6620\u5c04\u6587\u4ef6!"));
        }
        this.m_importReports = new Reports("");
        String sImportFile = this.getFullFileName(_sImportFile);
        String path = DocumentImporter.getMyDocumentImportSourceFilePath(this.getLoginUser());
        String tempath = path + "temp" + System.currentTimeMillis() + File.separator;
        if (!CMyFile.fileExists(_sDefineXmlForTRServer)) {
            _sDefineXmlForTRServer = path + _sDefineXmlForTRServer;
        }
        try {
            CMyFile.copyFile(_sDefineXmlForTRServer, tempath + DEFINE_XML_FILE);
            CMyFile.copyFile(DocumentImporter.getImportsrcPath() + TRS_XSL_FILE, tempath + TRS_XSL_FILE);
        }
        catch (CMyException e) {
            CMyFile.deleteDir(tempath);
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label3", "\u83b7\u53d6TRS\u6620\u5c04\u6587\u4ef6\u5931\u8d25!"), e);
        }
        try {
            this.m_bImportFromTRS = true;
            this.importDocuments(sImportFile, _channel, tempath + TRS_XSL_FILE, _bExitWhenDocumentExisted, _bOmitOriginalChannel);
            this.setReportsTitle();
        }
        finally {
            CMyFile.deleteDir(tempath);
        }
        return this.m_importReports;
    }

    private static String getImportsrcPath() {
        if (m_sSourceFilePath == null) {
            m_sSourceFilePath = FilesMan.getFilesMan().getPathConfigValue("DS", 0) + "importresource" + File.separator;
        }
        return m_sSourceFilePath;
    }

    private String getFullFileName(String _sImportFile) throws WCMException {
        String sImportFile = _sImportFile;
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(_sImportFile)) {
            String sPath = filesMan.mapFilePath(_sImportFile, 0);
            sImportFile = sPath + _sImportFile;
        }
        return sImportFile;
    }

    private void importDocuments(String _sImportFile, Channel _channel, String _sXslFile, boolean _bExitWhenDocumentExsited, boolean _bOmitOriginalChannel, boolean _bImportbyName) throws WCMException {
        int nFileType = this.getImportFileType(_sImportFile);
        switch (nFileType) {
            case 1: {
                this.importFromZip(_sImportFile, _channel, _sXslFile, _bExitWhenDocumentExsited, _bOmitOriginalChannel, _bImportbyName);
                break;
            }
            case 2: {
                this.importFromXml(_sImportFile, _channel, _sXslFile, _bExitWhenDocumentExsited, _bOmitOriginalChannel, _bImportbyName);
                break;
            }
            case 3: {
                this.importFromHtml(_sImportFile, _channel, false);
                break;
            }
            case 4: {
                throw new BizError(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label4", "\u4e0d\u652f\u6301[") + CMyFile.extractFileExt(_sImportFile) + I18NMessage.get(DocumentImporter.class, "DocumentImporter.label5", "]\u683c\u5f0f\u6587\u4ef6\u7684\u5bfc\u5165!"));
            }
        }
    }

    private void importDocuments(String _sImportFile, Channel _channel, String _sXslFile, boolean _bExitWhenDocumentExsited, boolean _bOmitOriginalChannel) throws WCMException {
        this.importDocuments(_sImportFile, _channel, _sXslFile, _bExitWhenDocumentExsited, _bOmitOriginalChannel, false);
    }

    private void setReportsTitle() {
        int nSuccessed = this.m_importReports.getSucessedReporter().size();
        int nFailed = this.m_importReports.getFailedReporter().size();
        String sSuccessedMsg = CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label7", "{0}\u7bc7\u5bfc\u5165\u6210\u529f,"), new int[]{nSuccessed});
        String sFailedMsg = CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label9", "{0}\u7bc7\u5bfc\u5165\u5931\u8d25,"), new int[]{nFailed});
        this.m_importReports.setTitle(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label10", "\u5171\u5904\u7406{0}\u7bc7\u6587\u6863."), new int[]{nSuccessed + nFailed}) + sSuccessedMsg + sFailedMsg);
    }

    private int getImportFileType(String _sImportFile) {
        String sFileExt = CMyFile.extractFileExt(_sImportFile).toLowerCase();
        if (FILEEXT_ZIP.equals(sFileExt)) {
            return 1;
        }
        if (FILEEXT_XML.equals(sFileExt)) {
            return 2;
        }
        if (FILEEXT_HTM.equals(sFileExt) || FILEEXT_HTML.equals(sFileExt)) {
            return 3;
        }
        return 4;
    }

    private void importFromZip(String _sZipFile, Channel _channel, String _sXslFile, boolean _bExitWhenDocumentExsited, boolean _bOmitOriginalChannel, boolean _bImportByName) throws WCMException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("import Documents From [" + _sZipFile + "]"));
        }
        String sUnZipFilePath = CMyFile.extractFilePath(_sZipFile);
        sUnZipFilePath = sUnZipFilePath + CMyFile.extractMainFileName(_sZipFile) + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(_sZipFile, sUnZipFilePath);
        try {
            uzf.addFileExtFilters(FILEEXT_XML);
            uzf.doUnZipAnd();
            if (!s_logger.isDebugEnabled()) {
                CMyFile.deleteFile(_sZipFile);
            }
        }
        catch (CMyException e) {
            throw new BizError(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label12", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!"));
        }
        ArrayList allXmlFiles = uzf.getFilteredFiles();
        String sXmlFile = null;
        XmlObject[] xmlObjs = null;
        if (allXmlFiles != null) {
            for (int i = allXmlFiles.size() - 1; i >= 0; --i) {
                sXmlFile = (String)allXmlFiles.get(i);
                if (this.isExportedFileForOfflineView(CMyFile.extractFileName(sXmlFile)) || FilesMan.isValidFile(CMyFile.extractFileName(sXmlFile), "P0")) continue;
                xmlObjs = this.m_converter.convertXml(sXmlFile, _sXslFile, null);
                if (this.m_bImportFromTRS && xmlObjs.length == 0) {
                    throw new BizError(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label13", "\u60a8\u9009\u62e9\u4e86\u5bfc\u5165\u7531TRS\u6570\u636e\u5e93\u5bfc\u51fa\u7684\u6587\u4ef6,\u4f46\u662f\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684TRS\u6587\u6863\u63cf\u8ff0\u6587\u4ef6.\u8bf7\u68c0\u67e5\u76f8\u5e94\u7684\u6570\u636e\u6e90"));
                }
                this.add(xmlObjs, _channel, sUnZipFilePath, _bExitWhenDocumentExsited, _bOmitOriginalChannel, _bImportByName);
            }
        }
        FileStore[] htmlFiles = CMyFile.listFiles(sUnZipFilePath, FILEEXT_HTML);
        for (int i = 0; i < htmlFiles.length; ++i) {
            this.importFromZipHtmlFiles(sUnZipFilePath, htmlFiles[i].getName(), _channel);
        }
        FileStore[] htmFiles = CMyFile.listFiles(sUnZipFilePath, FILEEXT_HTM);
        for (int i = 0; i < htmFiles.length; ++i) {
            this.importFromZipHtmlFiles(sUnZipFilePath, htmFiles[i].getName(), _channel);
        }
        if (!s_logger.isDebugEnabled()) {
            CMyFile.deleteFile(_sZipFile);
            CMyFile.deleteDir(sUnZipFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromXml(String _sXmlFile, Channel _channel, String _sXslFile, boolean _bExitWhenDocumentExsited, boolean _bOmitOriginalChannel, boolean _bImportByName) throws WCMException {
        try {
            XmlObject[] xmlObjs = this.m_converter.convertXml(_sXmlFile, _sXslFile, null);
            this.add(xmlObjs, _channel, null, _bExitWhenDocumentExsited, _bOmitOriginalChannel, _bImportByName);
        }
        finally {
            CMyFile.deleteFile(_sXmlFile);
        }
    }

    private void importFromZipHtmlFiles(String _sUnZipFile, String _sHtmlFile, Channel _channel) {
        if (this.isExportedFileForOfflineView(_sHtmlFile) || FilesMan.isValidFile(_sHtmlFile, "P0")) {
            return;
        }
        this.importFromHtml(_sUnZipFile + _sHtmlFile, _channel, true);
    }

    private boolean isExportedFileForOfflineView(String _sFileName) {
        return "trs_wcm_viewer_index.htm".equals(_sFileName) || "trs_wcm_viewer_doview.htm".equals(_sFileName) || "resource.xml".equals(_sFileName) || "reference.xml".equals(_sFileName);
    }

    private void importFromHtml(String _sHtmlFile, Channel _channel, boolean _bFromZip) {
        String sDocTitle = null;
        try {
            Document documentNew = Document.createNewInstance();
            sDocTitle = CMyFile.extractFileName(_sHtmlFile);
            String sCotent = CMyFile.readFile(_sHtmlFile);
            String sHtmlContent = HTMLContent.getBodyContent(sCotent);
            documentNew.setHtmlContent(sHtmlContent);
            if (_bFromZip) {
                documentNew = this.processHtmlContent(documentNew, CMyFile.extractFilePath(_sHtmlFile));
            }
            documentNew.setContent(sHtmlContent);
            documentNew.setTitle(sDocTitle);
            documentNew.setProperty("CrTime", CMyDateTime.now());
            if (_channel != null) {
                documentNew.setChannel(_channel);
            }
            documentNew.setType(20);
            this.m_documentMgr.save(documentNew);
            this.m_importReports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label14", "{0}\u5bfc\u5165\u6210\u529f!"), new Object[]{documentNew}));
            if (!s_logger.isDebugEnabled()) {
                CMyFile.deleteFile(_sHtmlFile);
            }
        }
        catch (CMyException e) {
            s_logger.error((Object)"failed import document from html file!", (Throwable)e);
            this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label15", "{0}\u6587\u6863\u5bfc\u5165\u5931\u8d25!"), new String[]{sDocTitle}), e);
        }
    }

    private void add(XmlObject[] _xmlObjs, Channel _channel, String _sUnZipFilePath, boolean _bExitWhenDocumentExsited, boolean _bOmitOriginalChannel, boolean bImportByName) throws WCMException {
        User loginUser = this.getLoginUser();
        XmlObject xmlObj = null;
        Document documentNew = null;
        for (int i = _xmlObjs.length - 1; i >= 0; --i) {
            String sDocIntoFlow;
            xmlObj = _xmlObjs[i];
            documentNew = (Document)xmlObj.getCurrentObj();
            if (documentNew == null) {
                throw new BizError(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label16", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,xml\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u6863\u63cf\u8ff0\u6587\u4ef6!"));
            }
            boolean bIsInfoViewDocument = documentNew.getFlag() > 0;
            try {
                CMyDateTime oCrTime;
                String sCrUser;
                int nOldStatus;
                Channel oldChannel = null;
                if (bImportByName) {
                    String sChnlName = (String)this.m_converter.Doc_ChannelName.get(documentNew.getPropertyAsString("DocId"));
                    int nSiteId = _channel.getSiteId();
                    oldChannel = Channel.findByName(nSiteId, sChnlName);
                    if (oldChannel != null) {
                        documentNew.setChannel(oldChannel);
                    }
                } else {
                    oldChannel = documentNew.getChannel();
                }
                if (_bOmitOriginalChannel || oldChannel == null && this.m_bImportCurrent) {
                    documentNew.setChannel(_channel);
                } else {
                    String sWarnMsg;
                    if (oldChannel == null) {
                        sWarnMsg = "omited a document import because the original channel do not existed!";
                        this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label17", "\u5ffd\u7565{0}\u7684\u5bfc\u5165"), new String[]{documentNew.toString()}), new WCMException(I18NMessage.makeObjectNotFound(new String[]{String.valueOf(documentNew.getChannelId()), WCMTypes.getLowerObjName(101)})));
                        s_logger.warn((Object)sWarnMsg);
                        continue;
                    }
                    if (oldChannel.getStatus() < 0) {
                        sWarnMsg = "omited a document import because the original channel[name:" + documentNew.getChannelName() + " id:" + documentNew.getChannelId() + "] is in recycle bin!";
                        this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label17", "\u5ffd\u7565{0}\u7684\u5bfc\u5165"), new String[]{documentNew.toString()}), new WCMException(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label21", "\u6587\u6863\u7684\u539f\u59cb\u680f\u76ee") + oldChannel + I18NMessage.get(DocumentImporter.class, "DocumentImporter.label22", "\u5df2\u7ecf\u88ab\u653e\u5165\u56de\u6536\u7ad9!")));
                        s_logger.warn((Object)sWarnMsg);
                        continue;
                    }
                }
                if (_bExitWhenDocumentExsited) {
                    boolean bExistSim = false;
                    ICKMServer currCKMServer = (ICKMServer)DreamFactory.createObjectById("ICKMServer");
                    boolean bCKMSimSearch = currCKMServer.isEnableSimSearch();
                    if (bCKMSimSearch) {
                        Documents simDocs = this.searchSimDocs(documentNew);
                        if (!simDocs.isEmpty()) {
                            bExistSim = true;
                        }
                    } else if (this.exsitedDocument(documentNew)) {
                        bExistSim = true;
                    }
                    if (bExistSim) {
                        String sWarnMsg = "omited a document import because a same document[" + documentNew.getTitle() + "] had existed in[" + documentNew.getChannelName() + "]!";
                        this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label17", "\u5ffd\u7565{0}\u7684\u5bfc\u5165!"), new String[]{documentNew.getTitle()}), new WCMException(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label24", "\u56e0\u4e3a\u60a8\u9009\u62e9\u4e86\u5f53\u680f\u76ee\u6709\u91cd\u590d\u6807\u9898" + (bCKMSimSearch ? "\u6216\u6b63\u6587" : "") + "\u6587\u6863\u65f6\u5ffd\u7565\u5bfc\u5165!")));
                        s_logger.warn((Object)sWarnMsg);
                        continue;
                    }
                }
                if ((nOldStatus = documentNew.getPropertyAsInt("DocStatus", 0)) == 0) {
                    documentNew.setStatus(1);
                }
                if ((sCrUser = documentNew.getPropertyAsString("CrUser")) == null || User.findByName(sCrUser) == null) {
                    documentNew.setCrUser(this.getLoginUser());
                }
                if ((oCrTime = documentNew.getPropertyAsDateTime("CrTime")) == null) {
                    documentNew.setProperty("CrTime", CMyDateTime.now());
                }
                documentNew.removeProperty("DOCPUBTIME");
                if (bIsInfoViewDocument) {
                    Channel current = documentNew.getChannel();
                    InfoViewEmployMgr mgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
                    List list = mgr.getEmployedInfoViews(current);
                    if (list != null && !list.isEmpty()) {
                        InfoView infoview = (InfoView)list.get(0);
                        if (documentNew.getFlag() != infoview.getId()) {
                            documentNew.setFlag(infoview.getId());
                        }
                    }
                    InfoviewDataProcessor oInfoviewDataProcessor = new InfoviewDataProcessor(loginUser, _sUnZipFilePath);
                    oInfoviewDataProcessor.processInfoViewAppendix(documentNew);
                } else {
                    documentNew = this.processHtmlContent(documentNew, _sUnZipFilePath);
                    this.processExternalFileIfNecessary(documentNew, _sUnZipFilePath);
                }
                MetaView metaView = this.m_MetaViewEmployerMgr.getViewOfEmployer(_channel);
                if (metaView != null) {
                    MetaViewData metaViewData = MetaDataUtil.documentToMetaData(documentNew, metaView);
                    metaViewData.save(ContextHelper.getLoginUser());
                    documentNew = metaViewData.getDocument();
                } else {
                    this.m_documentMgr.save(documentNew);
                }
            }
            catch (Throwable t) {
                this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label15", "{0}\u6587\u6863\u5bfc\u5165\u5931\u8d25!"), new Object[]{documentNew}), t);
                continue;
            }
            this.m_importReports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label14", "{0}\u5bfc\u5165\u6210\u529f!"), new Object[]{documentNew}));
            this.processQuote(xmlObj, documentNew);
            if (!bIsInfoViewDocument) {
                this.processAppendix(xmlObj, documentNew.getId(), _sUnZipFilePath);
            }
            if (!"true".equalsIgnoreCase(sDocIntoFlow = ConfigServer.getServer().getSysConfigValue("DOCIMPORT_INTO_FLOW", "false"))) continue;
            WCMProcessServiceHelper.startDocumentInFlow(documentNew.getCrUser(), documentNew, true);
        }
    }

    private void processQuote(XmlObject xmlObj, Document documentNew) {
        XmlObject[] children = xmlObj.getChild(CHILD_TAG_CHNLDOCS);
        if (children == null || children.length == 0) {
            return;
        }
        User loginUser = this.getLoginUser();
        for (int i = children.length - 1; i >= 0; --i) {
            ChnlDoc curr = (ChnlDoc)children[i].getCurrentObj();
            Channel channel = null;
            try {
                channel = curr.getChannel();
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
            if (channel == null) {
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)"import quote err,no channel.");
                continue;
            }
            if (channel.getId() == documentNew.getChannelId()) continue;
            ChnlDoc chnldoc = null;
            try {
                chnldoc = this.m_documentMgr.createChnlDocWithEntity(documentNew, channel, true);
                chnldoc.setModal(curr.getModal() == 3 ? 3 : 2);
                chnldoc.save(loginUser);
                continue;
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
        }
    }

    private boolean exsitedDocument(Document _document) throws WCMException {
        String sTitle = _document.getTitle();
        int nDocChannel = _document.getChannelId();
        Documents documents = new Documents(this.getLoginUser());
        CMyDateTime dateBefore = null;
        int nDay = -3;
        try {
            dateBefore = CMyDateTime.now().dateAdd(3, nDay);
        }
        catch (CMyException e) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"failed to date operate!", (Throwable)e);
            }
            return false;
        }
        String sWhereSql = "DocTitle=? AND DocChannel=? AND CrTime>=?";
        WCMFilter aFilter = new WCMFilter("", sWhereSql, "");
        aFilter.addSearchValues(CMyString.filterForSQL(sTitle));
        aFilter.addSearchValues(nDocChannel);
        aFilter.addSearchValues(dateBefore);
        aFilter.setMaxRowNumber(1);
        documents.open(aFilter);
        return !documents.isEmpty();
    }

    private Documents searchSimDocs(Document _document) {
        Documents docs = new Documents(this.getLoginUser());
        String sTitle = _document.getTitle();
        int nDocId = _document.getId();
        String sContent = _document.getContent();
        ICKMServer oCKMServer = TRSCKMServer.getInstance();
        docs = oCKMServer.simSearch(nDocId, sTitle + sContent);
        return docs;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Document processHtmlContent(Document _document, String _sUnZIPFilePath) {
        if (20 != _document.getType()) {
            return _document;
        }
        String sHtmlContent = _document.getHtmlContent();
        if (sHtmlContent == null || sHtmlContent.length() == 0) {
            return _document;
        }
        try {
            HashMap mapApdFiles = this.getPicFiles(_document, _sUnZIPFilePath);
            sHtmlContent = HTMLContent.saveHTMLContentFromOut(sHtmlContent, mapApdFiles);
            _document.setHtmlContent(sHtmlContent);
        }
        catch (WCMException e) {
            this.m_importReports.addWarnedReport(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label26", "\u5904\u7406") + _document + I18NMessage.get(DocumentImporter.class, "DocumentImporter.label27", "\u7684\u5185\u5bb9\u5931\u8d25!"), e);
        }
        return _document;
    }

    private void processExternalFileIfNecessary(Document _document, String _sUnZIPFilePath) throws WCMException {
        if (40 != _document.getType()) {
            return;
        }
        String sFile = _document.getPropertyAsString("DOCFILENAME");
        if (CMyString.isEmpty(sFile)) {
            return;
        }
        if (!CMyFile.fileExists(_sUnZIPFilePath + sFile)) {
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label28", "\u5bfc\u5165\u7684\u662f\u5916\u90e8\u6587\u4ef6\u578b\u6587\u6863,\u4f46\u5916\u90e8\u6587\u4ef6\u4e0d\u5b58\u5728!"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sNewName = filesMan.getNextFileName("U0", CMyFile.extractFileExt(sFile), null, true);
        try {
            CMyFile.copyFile(_sUnZIPFilePath + sFile, sNewName);
        }
        catch (CMyException e) {
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label29", "\u5bfc\u5165\u5916\u90e8\u6587\u4ef6\u578b\u6587\u6863,\u5916\u90e8\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"), e);
        }
        _document.setProperty("DOCFILENAME", CMyFile.extractFileName(sNewName));
    }

    private HashMap getPicFiles(Document _document, String _sUnZipFile) throws WCMException {
        if (CMyString.isEmpty(_sUnZipFile)) {
            return null;
        }
        HashMap<String, String> mapApdFiles = new HashMap<String, String>();
        String[] tags = this.getTagNames();
        if (tags == null) {
            return mapApdFiles;
        }
        String[] srcattrs = this.getTagAttrsrcNames();
        String htmlcon = _document.getHtmlContent();
        HtmlElementFinder finder = null;
        HtmlElement element = null;
        try {
            for (int index = 0; index < tags.length && index < srcattrs.length; ++index) {
                String tagname = tags[index];
                String attrname = srcattrs[index];
                finder = new HtmlElementFinder(htmlcon);
                while ((element = finder.findNextElement(tagname, true)) != null) {
                    String attrvalue = element.getAttributeValue(attrname);
                    if (CMyString.isEmpty(attrvalue)) continue;
                    if (File.separatorChar != '/') {
                        attrvalue = CMyString.replaceStr(attrvalue, "/", File.separator);
                    }
                    if (!DocumentImporter.isNeedDownload(element, attrvalue)) continue;
                    attrvalue = CMyFile.extractFileName(attrvalue);
                    String sSrcAbsoluteFile = _sUnZipFile + attrvalue;
                    if (!new FileService(sSrcAbsoluteFile).exists()) continue;
                    mapApdFiles.put(attrvalue.toLowerCase(), sSrcAbsoluteFile);
                }
            }
            return mapApdFiles;
        }
        catch (Exception e) {
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label30", "\u83b7\u53d6\u6b63\u6587\u4e2d\u9700\u8981\u5904\u7406\u7684\u7f6e\u6807\u8d44\u6e90\u5931\u8d25!"), e);
        }
    }

    private String[] getTagNames() {
        if (HTML_TAG_NAMES != null) {
            return HTML_TAG_NAMES;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagNames = configServer.getInitProperty("DOC_HTML_TAG_NAMES");
        if (sTagNames == null || sTagNames.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_NAMES = CMyString.split(sTagNames, ",");
        }
        catch (Exception ex) {
            HTML_TAG_NAMES = null;
        }
        return HTML_TAG_NAMES;
    }

    private String[] getTagAttrsrcNames() {
        if (HTML_TAG_SRCS != null) {
            return HTML_TAG_SRCS;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagSrcs = configServer.getInitProperty("DOC_HTML_TAG_SRCS");
        if (sTagSrcs == null || sTagSrcs.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_SRCS = CMyString.split(sTagSrcs, ",");
        }
        catch (Exception ex) {
            HTML_TAG_SRCS = null;
        }
        return HTML_TAG_SRCS;
    }

    private void processAppendix(XmlObject _xmlObj, int _nDocId, String _sUnZIPPath) throws WCMException {
        User loginUser = this.getLoginUser();
        XmlObject[] children = _xmlObj.getChild(CHILD_TAG_APPENDIXES);
        if (children.length == 0) {
            return;
        }
        Appendix appendix = null;
        String apdFileNew = null;
        String sPathInfo = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String sPath = _sUnZIPPath;
        boolean bAttachPic = false;
        for (int i = 0; i < children.length; ++i) {
            boolean bValid;
            appendix = (Appendix)children[i].getCurrentObj();
            appendix.setDocId(_nDocId);
            int nFlag = appendix.getFlag();
            if (nFlag != 40) {
                if (nFlag == 30) continue;
                appendix.setSrcFile(appendix.getFile());
                String strDesc = appendix.getDesc();
                if (strDesc == null || strDesc.length() == 0) {
                    appendix.setDesc(appendix.getFile());
                }
                apdFileNew = nFlag == 20 ? filesMan.getNextFileName("W0", appendix.getFileExt()) : filesMan.getNextFileName("P0", appendix.getFileExt());
                sPathInfo = filesMan.mapFilePath(apdFileNew, 0);
                try {
                    if (appendix.getFile().indexOf("..") >= 0) {
                        throw new RuntimeException("\u975e\u6cd5\u7684\u9644\u4ef6\u540d\u79f0");
                    }
                    CMyFile.copyFile(sPath + appendix.getFile(), sPathInfo + apdFileNew);
                }
                catch (CMyException e) {
                    s_logger.error((Object)("Exception to copy file![SrcFile=" + sPath + appendix.getFile() + ", DstFile=" + sPathInfo + apdFileNew + "]"), (Throwable)e);
                    continue;
                }
                appendix.setFile(apdFileNew);
            }
            appendix.setUsedByVersion(1, true);
            appendix.save(loginUser);
            if (bAttachPic || nFlag != 20 && nFlag != 30) continue;
            String sMinLimit = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
            int[] nMinLimit = CMyString.splitToInt(sMinLimit, ",");
            bAttachPic = bValid = FileHelper.validImageFile(sPathInfo + apdFileNew, nMinLimit[0], nMinLimit[1]);
        }
        Document document = Document.findById(_nDocId, "DocId, DOCHTMLCON");
        WCMDocumentHelper.setAttachPicOfDocument(document, bAttachPic);
    }

    public Reports getImportReports() {
        return this.m_importReports;
    }

    public static FileStore[] getExistedXslFiles(User _currUser) throws WCMException {
        DocumentImporter.assertNotNull(_currUser);
        String sPath = DocumentImporter.getMyDocumentImportSourceFilePath(_currUser);
        FileStore[] files = CMyFile.listFiles(sPath, "xsl");
        if (files == null) {
            return new FileService[0];
        }
        return files;
    }

    public static FileStore[] getExistedMapingFiles(User _currUser) throws WCMException {
        DocumentImporter.assertNotNull(_currUser);
        String sPath = DocumentImporter.getMyDocumentImportSourceFilePath(_currUser);
        FileStore[] files = CMyFile.listFiles(sPath, FILEEXT_XML);
        if (files == null) {
            return new FileService[0];
        }
        return files;
    }

    public static String getMyDocumentImportSourceFilePath(User _currUser) throws WCMException {
        DocumentImporter.assertNotNull(_currUser);
        String sPath = DocumentImporter.getImportsrcPath() + DocumentImporter.makePath(_currUser);
        if (!CMyFile.pathExists(sPath)) {
            CMyFile.makeDir(sPath, true);
        }
        return sPath;
    }

    private static void assertNotNull(User _currUser) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label31", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
    }

    private static String makePath(User _currUser) {
        return _currUser.getId() + File.separator;
    }

    private String getXslFileFullName(User _currUser, String _sXslFile) throws WCMException {
        if (_sXslFile == null || _sXslFile.trim().length() == 0) {
            return null;
        }
        if (CMyFile.fileExists(_sXslFile)) {
            return _sXslFile;
        }
        return DocumentImporter.getMyDocumentImportSourceFilePath(_currUser) + _sXslFile;
    }

    private static boolean isNeedDownload(HtmlElement _currElement, String _sSrc) {
        char nLasChar = _sSrc.charAt(_sSrc.length() - 1);
        if (nLasChar == '/' || nLasChar == '\\') {
            return false;
        }
        boolean bResult = true;
        if (_currElement.getName().equalsIgnoreCase("A")) {
            bResult = _currElement.getAttribute("NeedDownload") != null && !DocumentImporter.isHTMLContent(_sSrc);
            _currElement.removeAttribute("NeedDownload");
        }
        return bResult;
    }

    private static boolean isHTMLContent(String _sFileName) {
        String sExt = CMyFile.extractFileExt(_sFileName).toLowerCase();
        if (sExt.indexOf(FILEEXT_HTM) >= 0) {
            return true;
        }
        if (sExt.indexOf("asp") >= 0) {
            return true;
        }
        if (sExt.indexOf("jsp") >= 0) {
            return true;
        }
        return sExt.indexOf("php") >= 0;
    }

    static {
        HTML_TAG_NAMES = null;
        HTML_TAG_SRCS = null;
        implementors = null;
    }
}

