/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.components.stat.HostObjDomain;
import com.trs.components.stat.HostObjDomains;
import com.trs.components.stat.IURLParser;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class URLParser
implements IURLParser {
    private static Logger logger = Logger.getLogger(URLParser.class);
    private Map hostObjDomainMap;
    private Map urlsCache = new HashMap();
    private Pattern detailPattern = Pattern.compile("t\\d+_(\\d+)[^.]*\\.[^.]+$");

    @Override
    public BaseObj parse(String sUrl) throws WCMException {
        Matcher matcher;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f00\u59cb\u89e3\u6790\u8def\u5f84[" + sUrl + "]"));
        }
        if ((matcher = this.detailPattern.matcher(sUrl)).find()) {
            int nDocId = Integer.parseInt(matcher.group(1));
            Document obj = Document.findById(nDocId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5c06url[" + sUrl + "]\u89e3\u6790\u6210\u6587\u6863\u5bf9\u8c61[" + obj + "]"));
            }
            return obj;
        }
        return this.getBaseObj(sUrl);
    }

    private BaseObj getBaseObj(String sUrl) throws WCMException {
        int nIndex;
        Stack<String> stack = new Stack<String>();
        String sPrefixUrl = sUrl;
        BaseObj obj = null;
        int fromIndex = sPrefixUrl.length() - 1;
        while ((nIndex = sPrefixUrl.lastIndexOf("/", fromIndex)) > 0) {
            stack.push(sPrefixUrl.substring(nIndex + 1));
            sPrefixUrl = sPrefixUrl.substring(0, nIndex);
            obj = (BaseObj)this.urlsCache.get(sPrefixUrl);
            if (obj != null) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("\u4ece\u7f13\u5b58\u4e2d\u6620\u5c04url[" + sPrefixUrl + "]->" + obj));
                break;
            }
            obj = this.getBaseObjFromHostObjDomain(sPrefixUrl);
            if (obj != null) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("\u4ece\u57df\u540d\u9690\u5c04\u4e2d\u6620\u5c04url[" + sPrefixUrl + "]->" + obj));
                break;
            }
            obj = this.findWebSiteByRootDomain(sPrefixUrl);
            if (obj != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u4ece\u6570\u636e\u5e93\u4e2d\u6620\u5c04\u7ad9\u70b9url[" + sPrefixUrl + "]->" + obj));
                    logger.debug((Object)("\u5c06url[" + sPrefixUrl + "]\u548cbaseObj[" + obj + "]\u653e\u5165cache"));
                }
                this.urlsCache.put(sPrefixUrl, obj);
                break;
            }
            fromIndex = nIndex;
        }
        if (obj == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6ca1\u6709\u627e\u5230url\u5bf9\u5e94\u7684\u5bf9\u8c61[" + sUrl + "]"));
            }
            return null;
        }
        BaseChannel host = (BaseChannel)obj;
        while (!stack.empty()) {
            BaseChannel temp;
            String sPartUrl = (String)stack.pop();
            if (CMyString.isEmpty(sPartUrl)) continue;
            if (sPartUrl.indexOf(".") > 0 || (temp = this.findChannelByDataPath(host, sPartUrl)) == null) break;
            host = temp;
            sPrefixUrl = sPrefixUrl + "/" + sPartUrl;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5c06url[" + sPrefixUrl + "]\u548cbaseObj[" + host + "]\u653e\u5165cache"));
            }
            this.urlsCache.put(sPrefixUrl, host);
        }
        return host;
    }

    private WebSite findWebSiteByRootDomain(String sRootDomain) throws WCMException {
        WCMFilter filter = new WCMFilter();
        filter.setWhere("rootdomain=?");
        filter.addSearchValues(sRootDomain);
        logger.debug((Object)filter);
        FolderPublishConfigs configs = FolderPublishConfigs.openWCMObjs(null, filter);
        int nSize = configs.size();
        for (int i = 0; i < nSize; ++i) {
            FolderPublishConfig config = (FolderPublishConfig)configs.getAt(i);
            if (config == null) continue;
            return WebSite.findById(config.getFolderId());
        }
        return null;
    }

    public BaseChannel findChannelByDataPath(BaseChannel parent, String sDataPath) throws WCMException {
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append(" DATAPATH=? and FOLDERTYPE=?");
        sbWhere.append(" and exists( select 1 from WCMCHANNEL where ");
        sbWhere.append(" WCMCHANNEL.CHANNELID=WCMFOLDERPUBLISHCONFIG.FOLDERID");
        sbWhere.append(" and ");
        sbWhere.append(parent.isSite() ? "WCMCHANNEL.SITEID" : "WCMCHANNEL.PARENTID");
        sbWhere.append(" =?) ");
        WCMFilter filter = new WCMFilter(null, sbWhere.toString(), null);
        filter.addSearchValues(sDataPath);
        filter.addSearchValues(101);
        filter.addSearchValues(parent.getId());
        logger.debug((Object)filter);
        FolderPublishConfigs configs = FolderPublishConfigs.openWCMObjs(null, filter);
        int nSize = configs.size();
        for (int i = 0; i < nSize; ++i) {
            FolderPublishConfig config = (FolderPublishConfig)configs.getAt(i);
            if (config == null) continue;
            return Channel.findById(config.getFolderId());
        }
        return null;
    }

    private BaseObj getBaseObjFromHostObjDomain(String sUrl) throws WCMException {
        if (this.hostObjDomainMap == null) {
            this.hostObjDomainMap = new HashMap();
            HostObjDomains hostObjs = HostObjDomains.openWCMObjs(null, null);
            int nSize = hostObjs.size();
            for (int i = 0; i < nSize; ++i) {
                BaseObj baseObj;
                HostObjDomain hostObj = (HostObjDomain)hostObjs.getAt(i);
                if (hostObj == null || (baseObj = BaseObj.findById(hostObj.getHostType(), hostObj.getHostId())) == null) continue;
                String sHostObjUrl = hostObj.getUrl();
                this.hostObjDomainMap.put(sHostObjUrl, baseObj);
            }
        }
        return (BaseObj)this.hostObjDomainMap.get(sUrl);
    }
}

