/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.components.metadata.definition.IMetaViewFieldGroupMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnBeforeAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class MetaViewFieldListenerForFieldGroup
implements IObjectLCListenerOnBeforeAdd,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(MetaViewFieldListenerForFieldGroup.class);

    @Override
    public void notifyOnBeforeAddObj(BaseObj objAdded) throws WCMException {
        if (!(objAdded instanceof MetaViewField)) {
            logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + objAdded.getClass() + "]\u7684\u65b0\u589e\uff01"));
            return;
        }
        MetaViewField viewField = (MetaViewField)objAdded;
        int nFieldType = viewField.getType();
        if (nFieldType != 14) {
            return;
        }
        this.setGroupForRelationDocField(viewField);
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (!(objModified instanceof MetaViewField)) {
            logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + objModified.getClass() + "]\u7684\u4fee\u6539\uff01"));
            return;
        }
        MetaViewField viewField = (MetaViewField)objModified;
        if (!viewField.isChangeProperty("FIELDTYPE") || viewField.getNewPropertyAsInt("FIELDTYPE", 0) != 14) {
            return;
        }
        this.setGroupForRelationDocField(viewField);
    }

    private void setGroupForRelationDocField(MetaViewField viewField) throws WCMException {
        int nViewId;
        MetaView metaView;
        String sAnotherName = viewField.getAnotherName();
        IMetaViewFieldGroupMgr groupMgr = (IMetaViewFieldGroupMgr)DreamFactory.createObjectById("IMetaViewFieldGroupMgr");
        MetaViewFieldGroup fieldGroup = groupMgr.findGroup(metaView = MetaView.findById(nViewId = viewField.getViewId()), sAnotherName);
        if (fieldGroup == null) {
            fieldGroup = MetaViewFieldGroup.createNewInstance();
            fieldGroup.setMetaViewId(nViewId);
            fieldGroup.setGroupName(sAnotherName);
            fieldGroup.setParentId(0);
            fieldGroup.setOrder(-1);
            fieldGroup.save();
        }
        viewField.setFieldGroupId(fieldGroup.getId());
    }
}

