/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewEmployer;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MetaViewEmployerMgr
implements IMetaViewEmployerMgr {
    private static Logger logger = Logger.getLogger(MetaViewEmployerMgr.class);
    private static final String SQL_CLEAR_BY_CHANNEL = "delete from XWCMMetaViewEmployer where ChannelId=?";
    private static final String SQL_CLEAR_BY_VIEW = "delete from XWCMMetaViewEmployer where ViewId=?";
    private static final String SQL_QUERY_CHANNELS = "exists(select XWCMMetaViewEmployer.ChannelId from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ViewId=? and XWCMMetaViewEmployer.ChannelId=WCMChannel.ChannelId)";
    private static final String SQL_QUERY_VIEWID_FROM_CHANNEL = "select ViewId from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ChannelId=?";
    private static final String SQL_QUERY_VIEWID_FROM_EMPLOYER = "select ViewId from XWCMMetaViewEmployer where XWCMMetaViewEmployer.EmployerType=? and XWCMMetaViewEmployer.EmployerId=?";
    private static final String SQL_UPDATE_EMPLOYER = "update XWCMMetaViewEmployer set ViewId=? where ChannelId=?";
    private static final String SQL_UPDATE_VIEW_OF_EMPLOYER = "update XWCMMetaViewEmployer set ViewId=? where XWCMMetaViewEmployer.EmployerType=? and XWCMMetaViewEmployer.EmployerId=?";

    @Override
    public void clearEmployer(User _currUser, Channel _channel) throws WCMException {
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_CLEAR_BY_CHANNEL}, new int[]{_channel.getId()});
        this.clearChannelViewProperties(_currUser, _channel);
    }

    private void clearChannelViewProperties(User _currUser, Channel _channel) throws WCMException {
        _channel.validCanDeleteAndLock(_currUser);
        String sPath = "../document/";
        _channel.setProperty("ContentListPage", sPath + "document_list_of_channel.jsp");
        _channel.setProperty("ContentAddEditPage", sPath + "document_addedit.jsp");
        _channel.setProperty("ContentShowPage", sPath + "document_show.jsp");
        _channel.update(_currUser);
    }

    @Override
    public void clearEmployer(User _currUser, MetaView _view) throws WCMException {
        Channels channels = this.getEmployers(_view, null);
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_CLEAR_BY_VIEW}, new int[]{_view.getId()});
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.clearChannelViewProperties(_currUser, channel);
        }
    }

    @Override
    public Channels getEmployers(MetaView _view, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMChannel", SQL_QUERY_CHANNELS, "");
        filter.addSearchValues(_view.getId());
        filter.mergeWith(_extraFilter);
        return Channels.openWCMObjs(null, filter);
    }

    @Override
    public MetaView getViewOfEmployer(BaseChannel _oSiteOrChannel) throws WCMException {
        int nViewId = 0;
        nViewId = _oSiteOrChannel.isSite() ? DBManager.getDBManager().sqlExecuteIntQuery(SQL_QUERY_VIEWID_FROM_EMPLOYER, new int[]{_oSiteOrChannel.getWCMType(), _oSiteOrChannel.getId()}) : DBManager.getDBManager().sqlExecuteIntQuery(SQL_QUERY_VIEWID_FROM_CHANNEL, new int[]{_oSiteOrChannel.getId()});
        return MetaView.findById(nViewId);
    }

    @Override
    public void setEmployer(User _currUser, Channel _channel, MetaView _view) throws WCMException {
        int nViewId = DBManager.getDBManager().sqlExecuteIntQuery(SQL_QUERY_VIEWID_FROM_CHANNEL, new int[]{_channel.getId()});
        if (nViewId == _view.getId()) {
            return;
        }
        if (nViewId <= 0) {
            MetaViewEmployer oMetaViewEmployer = new MetaViewEmployer();
            oMetaViewEmployer.setProperty("ChannelId", _channel.getId());
            oMetaViewEmployer.setProperty("EmployerType", _channel.getWCMType());
            oMetaViewEmployer.setProperty("EmployerId", _channel.getId());
            oMetaViewEmployer.setProperty("ViewId", _view.getId());
            oMetaViewEmployer.save();
        } else {
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_UPDATE_EMPLOYER}, new int[]{_view.getId(), _channel.getId()});
        }
        String sPath = "../application/" + _view.getId() + "/";
        _channel.validCanDeleteAndLock(_currUser);
        _channel.setProperty("ContentListPage", sPath + "metaviewdata_list.html");
        _channel.setProperty("ContentAddEditPage", sPath + "metaviewdata_addedit.jsp");
        _channel.setProperty("ContentShowPage", sPath + "viewdata_detail.jsp");
        _channel.update(_currUser);
    }

    @Override
    public void setViewOfEmployer(BaseObj _employer, MetaView _view) throws WCMException {
        int nViewId = DBManager.getDBManager().sqlExecuteIntQuery(SQL_QUERY_VIEWID_FROM_EMPLOYER, new int[]{_employer.getWCMType(), _employer.getId()});
        if (nViewId == _view.getId()) {
            return;
        }
        if (nViewId <= 0) {
            MetaViewEmployer oMetaViewEmployer = new MetaViewEmployer();
            oMetaViewEmployer.setProperty("ChannelId", _employer instanceof Channel ? (long)_employer.getId() : 0L);
            oMetaViewEmployer.setProperty("EmployerType", _employer.getWCMType());
            oMetaViewEmployer.setProperty("EmployerId", _employer.getId());
            oMetaViewEmployer.setProperty("ViewId", _view.getId());
            oMetaViewEmployer.save();
        } else {
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_UPDATE_VIEW_OF_EMPLOYER}, new int[]{_view.getId(), _employer.getWCMType(), _employer.getId()});
        }
    }

    @Override
    public MetaView findOneAndSameViewOfEmployer(BaseObjs _objs) throws WCMException {
        ArrayList<Integer> paramters = new ArrayList<Integer>(_objs.size() + 1);
        StringBuffer sbQuerySQL = new StringBuffer("select count(*) vcount, ViewId from XWCMMetaViewEmployer where ");
        if (_objs instanceof Channels) {
            sbQuerySQL.append("ChannelId in(");
        } else {
            sbQuerySQL.append("ObjectType=? and ObjectId in(");
            int nEmployerType = 0;
            try {
                nEmployerType = ((BaseObj)_objs.getElementClass().newInstance()).getWCMType();
            }
            catch (Exception e) {
                logger.error((Object)"Fail to get type!", (Throwable)e);
                nEmployerType = 101;
            }
            paramters.add(nEmployerType);
        }
        int nSize = _objs.size();
        for (int i = 0; i < nSize; ++i) {
            sbQuerySQL.append("?,");
            paramters.add(_objs.getIdAt(i));
        }
        sbQuerySQL.setLength(sbQuerySQL.length() - 1);
        sbQuerySQL.append(")");
        sbQuerySQL.append(" group by ViewId ");
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(sbQuerySQL.toString());
            DBManager.setParameters(oStmt, paramters);
            oStmt.setMaxRows(1);
            rsData = oStmt.executeQuery();
            while (true) {
                if (rsData.next()) {
                    int nViewCount = rsData.getInt("vcount");
                    if (nViewCount != _objs.size()) continue;
                    MetaView metaView = MetaView.findById(rsData.getInt("ViewId"));
                    return metaView;
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + sbQuerySQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + sbQuerySQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

