/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserCMSObjBase;
import com.trs.components.common.publish.domain.tagparser.TemplateQuoteBaseTagParser;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;

public abstract class WCMTagParserBaseOperation
extends TemplateQuoteBaseTagParser {
    protected TagItem m_tagItem;
    protected CMSObj m_host = null;
    private static NamesRegister m_hostSpecialAttributesRegister = new NamesRegister();
    private static final String sPreLoadAttribute = "RightValue";
    private static final RightValue ADMIN_RIGHTVALUE = RightValue.getAdministratorRightValue();
    private static final String NO_VALUE = "0";

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sParseMode = _context.getPageContext().getExtraAttribute("_ParseMode_");
        if (!"EDIT".equals(sParseMode)) {
            String[] sChildrenContent = TagParseHelper.parseItems(_context.getTagItem().getChildren(), _context);
            return sChildrenContent;
        }
        this.m_host = this.findHost(_context);
        if (this.m_host == null) {
            return null;
        }
        try {
            this.m_tagItem = _context.getTagItem();
            String sFieldName = _context.getAttribute("ATTRIBUTES");
            if (sFieldName == null || (sFieldName = sFieldName.trim()).length() == 0) {
                sFieldName = this.getDefaultField();
            }
            sFieldName = sFieldName == null || (sFieldName = sFieldName.trim()).length() == 0 ? sPreLoadAttribute : sFieldName + ",RightValue";
            sFieldName = sFieldName.toUpperCase();
            int nSpecialAttribute = 0;
            int nAttributeLength = sFieldName.split(",").length;
            String result = "<div ";
            String sExtraCls = CMyString.showNull(_context.getAttribute("extraCls"));
            result = result + "class=\"trs-data-oper " + sExtraCls + "\" ";
            result = this.appendDefaultAttribute(result, this.m_host, this.m_tagItem);
            for (int i = 0; i < nAttributeLength; ++i) {
                String sAttributeName = sFieldName.split(",")[i];
                nSpecialAttribute = this.lookupHostSpecialAttributeId(sAttributeName);
                result = nSpecialAttribute > 0 ? this.appendAttribute(result, sAttributeName, this.parseHostSpecialProperty(nSpecialAttribute, _context)) : this.appendAttribute(result, sAttributeName, this.parseHostNormalProperty(sAttributeName, _context));
            }
            result = result + ">" + TagParseHelper.parseItems(_context.getTagItem().getChildren(), _context)[0] + "</div>";
            return new String[]{result};
        }
        catch (Exception ex) {
            throw new WCMException(234, I18NMessage.get(TagParserCMSObjBase.class, "TagParserCMSObjBase.label1", "\u89e3\u6790\u7ec6\u89c8\u7f6e\u6807\u5931\u8d25\uff01\u7f6e\u6807\u5185\u5bb9\u4e3a: ") + this.m_tagItem.toString(), ex);
        }
    }

    private String appendDefaultAttribute(String _result, CMSObj _host, TagItem _item) {
        int nEndIndex = _item.getName().toUpperCase().indexOf("OPERATION");
        String sOperType = _item.getName().substring(4, nEndIndex);
        _result = _result + "OperTYpe=\"" + sOperType + "\"";
        _result = _result + " ObjId=\"" + _host.getId() + "\"";
        _result = _result + " ObjType=\"" + _host.getWCMType() + "\"";
        return _result;
    }

    private String appendAttribute(String result, String attributeName, String parseHostSpecialProperty) {
        result = result + " " + attributeName + "=\"" + CMyString.filterForHTMLValue(parseHostSpecialProperty) + "\"";
        return result;
    }

    protected String parseHostNormalProperty(String _sName, PublishTagContext _context) throws WCMException {
        Object oValue = _sName.charAt(0) == '#' ? this.m_host.getAttributeValue(_sName.substring(1)) : this.m_host.getProperty(_sName);
        if (oValue == null) {
            return null;
        }
        return this.parseProperty(oValue, _context);
    }

    protected String parseProperty(Object oValue, PublishTagContext _context) throws WCMException {
        int nMaxLength;
        String sFullValue;
        if (oValue instanceof CMyDateTime) {
            CMyDateTime dt = (CMyDateTime)oValue;
            String sLocaleId = _context.getAttribute("LOCALE");
            String sTimeZoneId = _context.getAttribute("TIMEZONE");
            String sFormat = this.getDateFormat(_context);
            sFullValue = dt.toString(sFormat, sLocaleId, sTimeZoneId);
        } else {
            sFullValue = oValue instanceof String ? (String)oValue : oValue.toString();
        }
        if (sFullValue == null) {
            return null;
        }
        String sResult = null;
        sResult = TagParseHelper.truncateTextIfNeeded(_context, sFullValue);
        sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
        sResult = TagParseHelper.addSpanStyleIfNeeded(_context, sResult);
        if (oValue instanceof CDBText && (nMaxLength = _context.getAttribute("NUM", 0)) == 0) {
            if (_context.getPageElement() instanceof IPublishContent) {
                return "";
            }
            return sResult;
        }
        if (_context.getAttribute("ISHTMLCONTENT", false)) {
            return "";
        }
        return sResult;
    }

    protected String getDateFormat(PublishTagContext _context) {
        String sDateFormat = _context.getAttribute("DATEFORMAT");
        if (sDateFormat == null || (sDateFormat = sDateFormat.trim()).length() == 0) {
            sDateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        return TagParseHelper.parseDateFormat(sDateFormat);
    }

    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        IPublishElement content = _context.getUpperHost();
        if (content == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return content.getSubstance();
    }

    protected void registerHostSpecialAttribute(String _sName, int _nId) {
        String key = this.m_tagItem.getName() + '.' + _sName;
        m_hostSpecialAttributesRegister.register(key, _nId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialAttributeId(String _sName) {
        String sPrefix = this.m_tagItem.getName() + '.';
        if (!m_hostSpecialAttributesRegister.contains(sPrefix)) {
            NamesRegister namesRegister = m_hostSpecialAttributesRegister;
            synchronized (namesRegister) {
                if (!m_hostSpecialAttributesRegister.contains(sPrefix)) {
                    this.registerHostSpecialAttributes();
                    m_hostSpecialAttributesRegister.register(sPrefix, 0);
                }
            }
        }
        return m_hostSpecialAttributesRegister.lookup(sPrefix + _sName, -1);
    }

    protected abstract void registerHostSpecialAttributes();

    protected abstract String parseHostSpecialProperty(int var1, PublishTagContext var2) throws WCMException;

    protected String getDefaultField() {
        return null;
    }

    public RightValue getChannelRightValue(User _currUser, BaseChannel _oBaseChannel) throws WCMException {
        RightValue oRightValue = new RightValue();
        IObjectMemberMgr oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        if (_currUser.isAdministrator() || _currUser.getName().equals(_oBaseChannel.getCrUserName())) {
            return ADMIN_RIGHTVALUE;
        }
        if (oObjectMemberMgr.canOperate(_currUser, _oBaseChannel.getWCMType(), _oBaseChannel.getId())) {
            oRightValue = AuthServer.getRightValue((CMSObj)_oBaseChannel, _currUser);
        } else {
            new RightValue(NO_VALUE);
        }
        return oRightValue;
    }

    public BaseChannel getDefaultChannel() throws WCMException {
        String sDefaultChnlId = ConfigServer.getServer().getSysConfigValue("SPECIAL_DEFAULT_CHANNELID", NO_VALUE);
        int nDefaultChnlId = 0;
        try {
            nDefaultChnlId = Integer.parseInt(sDefaultChnlId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Channel.findById(nDefaultChnlId);
    }

    public class TBI
    extends TagBeanInfo {
        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
            TagBeanInfoHelper.checkChannelName(_folder, _tagItem, _sbResult);
        }
    }
}

