/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.Masters;
import com.trs.components.special.Special;
import com.trs.components.special.Specials;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.jazzlib.ZipEntry;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class MasterReformTool {
    private static Logger logger = Logger.getLogger(MasterReformTool.class);

    public static String reformMaster(User _oCurrUser) throws CMyException {
        WCMFilter filter = new WCMFilter("", "MASTERTYPE is Null", "", "MASTERID,MNAME,MDESC,FILENAME,PICFILENAME,CRUSER,MASTERTYPE");
        Masters oMasters = Masters.openWCMObjs(_oCurrUser, filter);
        int nSize = oMasters.size();
        for (int i = 0; i < nSize; ++i) {
            String sMasterFile;
            Master oMaster = (Master)oMasters.getAt(i);
            if (oMaster == null) continue;
            Master oIndexMaster = null;
            Master oOutlineMaster = null;
            Master oDetailMaster = null;
            FilesMan filesMan = FilesMan.getFilesMan();
            String sMasterFilePath = filesMan.mapFilePath(sMasterFile = oMaster.getFileName(), 0);
            String sMasterFileFullName = sMasterFilePath + sMasterFile;
            if (!CMyFile.fileExists(sMasterFileFullName)) {
                logger.error((Object)("\u62c6\u5206\u6bcd\u677f\u51fa\u73b0\u9519\u8bef\uff1a \u6bcd\u677f\u6587\u4ef6" + sMasterFileFullName + "\u4e0d\u5b58\u5728\uff0c\u6bcd\u677fid\uff1a" + oMaster.getId() + "\u6bcd\u677f\u540d\u79f0\uff1a" + oMaster.getMName()));
                continue;
            }
            CMyUnzip myUnzip = new CMyUnzip();
            String sUnZipPath = sMasterFilePath + "unZip" + CMyFile.extractMainFileName(sMasterFile) + "\\";
            try {
                myUnzip.setZipFile(sMasterFilePath + sMasterFile);
                myUnzip.unzip(sUnZipPath, true);
                oIndexMaster = MasterReformTool.createNewMasterFromOld(oMaster, "index.html", myUnzip, sUnZipPath, _oCurrUser);
                if (oIndexMaster == null) {
                    throw new CMyException("\u62c6\u5206\u9996\u9875\u57fa\u51c6\u6bcd\u677f\u5931\u8d25\uff01");
                }
                oOutlineMaster = MasterReformTool.createNewMasterFromOld(oMaster, "outline.html", myUnzip, sUnZipPath, _oCurrUser);
                oDetailMaster = MasterReformTool.createNewMasterFromOld(oMaster, "detail.html", myUnzip, sUnZipPath, _oCurrUser);
                int nMasterId = oMaster.getId();
                int nIndexMasterId = oIndexMaster.getId();
                int nOutlineMasterId = oOutlineMaster == null ? 0 : oOutlineMaster.getId();
                int nDetailMasterId = oDetailMaster == null ? 0 : oDetailMaster.getId();
                String sMasterIds = Integer.toString(nIndexMasterId) + "," + Integer.toString(nOutlineMasterId) + "," + Integer.toString(nDetailMasterId);
                WCMFilter filter2 = new WCMFilter("", "MASTERID = ? and MASTERIDS is Null", "", "HOSTID,HOSTTYPE,SPECIALNAME,SPECIALDESC,VIEWTHUMB,MASTERID,CRUSER,CRTIME,STYLENAME");
                filter2.addSearchValues(nMasterId);
                Specials oSpecials = Specials.openWCMObjs(_oCurrUser, filter2);
                for (int j = 0; j < oSpecials.size(); ++j) {
                    Special oSpecial = (Special)oSpecials.getAt(j);
                    if (oSpecial == null) continue;
                    oSpecial.setMasterIds(sMasterIds);
                    oSpecial.save(_oCurrUser);
                }
                oMaster.setMasterType(0);
                oMaster.save(_oCurrUser);
                continue;
            }
            catch (CMyException e) {
                throw new CMyException("\u62c6\u5206\u6bcd\u677f\u5f02\u5e38\uff1a", e);
            }
            finally {
                CMyFile.deleteDir(sUnZipPath);
            }
        }
        String sResult = "";
        sResult = oMasters.size() <= 0 ? "\u6ca1\u6709\u8981\u62c6\u5206\u7684\u65e7\u6bcd\u677f\uff01" : "\u62c6\u5206\u6bcd\u677f\u5b8c\u6210\uff01";
        return sResult;
    }

    private static Master createNewMasterFromOld(Master _oMaster, String _sSpecialHtml, CMyUnzip _oMyUnzip, String _sUnZipPath, User _oCurrUser) throws CMyException {
        if (_oMaster == null) {
            throw new CMyException("\u62c6\u5206\u6bcd\u677f\u8fc7\u7a0b\u4e2d\uff0c\u65e7\u6bcd\u677f\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        Master oMaster = new Master();
        int nFlag = 0;
        if (_sSpecialHtml.equalsIgnoreCase("outline.html")) {
            nFlag = 1;
        }
        if (_sSpecialHtml.equalsIgnoreCase("detail.html")) {
            nFlag = 2;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        boolean bIncludeSpecialFile = false;
        try {
            String sPath = filesMan.getNextFilePathName("ST", "zip");
            CMyZip myZip = new CMyZip();
            try {
                myZip.setZipFileName(sPath);
            }
            catch (CMyException e) {
                throw new CMyException("\u521b\u5efazip\u6587\u4ef6\u5931\u8d25", e);
            }
            Enumeration eItems = _oMyUnzip.getItems();
            int nFileNumAddToZip = 0;
            while (eItems.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)eItems.nextElement();
                if (ze.getName().equalsIgnoreCase(_sSpecialHtml)) {
                    bIncludeSpecialFile = true;
                }
                if (nFlag == 0 && (ze.getName().equalsIgnoreCase("outline.html") || ze.getName().equalsIgnoreCase("detail.html")) || nFlag == 1 && (ze.getName().equalsIgnoreCase("index.html") || ze.getName().equalsIgnoreCase("detail.html")) || nFlag == 2 && (ze.getName().equalsIgnoreCase("index.html") || ze.getName().equalsIgnoreCase("outline.html"))) continue;
                if (nFlag == 1 && bIncludeSpecialFile) {
                    CMyFile.copyFile(_sUnZipPath + ze.getName(), _sUnZipPath + "index.html");
                    myZip.addToZip(_sUnZipPath + "index.html", false);
                    ++nFileNumAddToZip;
                    continue;
                }
                myZip.addToZip(_sUnZipPath + ze.getName(), false);
                ++nFileNumAddToZip;
            }
            if (bIncludeSpecialFile && nFileNumAddToZip > 0) {
                myZip.done();
                switch (nFlag) {
                    case 0: {
                        oMaster.setMName(_oMaster.getMName() + "_\u9996\u9875\u57fa\u51c6");
                        oMaster.setMasterType(1);
                        break;
                    }
                    case 1: {
                        oMaster.setMName(_oMaster.getMName() + "_\u5206\u7c7b\u9996\u9875");
                        oMaster.setMasterType(1);
                        break;
                    }
                    case 2: {
                        oMaster.setMName(_oMaster.getMName() + "_\u6587\u6863\u9875\u9762");
                        oMaster.setMasterType(2);
                    }
                }
                oMaster.setMDesc(_oMaster.getMDesc());
                oMaster.setCrUser(_oMaster.getCrUser());
                String sFileName = filesMan.copyFile(sPath, "W0", false);
                oMaster.setFileName(sFileName);
                String sPicFileName = _oMaster.getPicFileName();
                String sPicFilePath = filesMan.mapFilePath(sPicFileName, 0);
                sPicFileName = filesMan.copyFile(sPicFilePath + sPicFileName, "W0", false);
                oMaster.setPicFileName(sPicFileName);
                oMaster.save(_oCurrUser);
                return oMaster;
            }
            return null;
        }
        catch (CMyException e) {
            throw new CMyException("\u62c6\u5206\u6bcd\u677f\u5f02\u5e38\uff1a", e);
        }
    }
}

