/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TemplateParseHelper {
    private static Logger logger = Logger.getLogger(TemplateParseHelper.class);

    public static ArrayList parseCssAndCopySrcFileAsTempAppedix(String _sCSSFilePath, String _sDestDir, Template _template) {
        ArrayList<TempAppendix> arrResult = new ArrayList<TempAppendix>(3);
        if (_template == null) {
            return arrResult;
        }
        if (!CMyString.isEmpty(_sCSSFilePath)) {
            String sCssFileDir = CMyFile.extractFilePath(_sCSSFilePath);
            String csscontent = null;
            try {
                csscontent = CMyFile.readFile(_sCSSFilePath);
                int lParenthesesIndex = 0;
                int rParenthesesIndex = 0;
                String sSrcFile = null;
                while ((lParenthesesIndex = csscontent.indexOf("(")) != -1) {
                    rParenthesesIndex = csscontent.indexOf(")");
                    if (rParenthesesIndex == -1) {
                        logger.warn((Object)"invalid css file,syntax error");
                        break;
                    }
                    sSrcFile = csscontent.substring(lParenthesesIndex + 1, rParenthesesIndex);
                    sSrcFile = sSrcFile.replace('/', File.separatorChar);
                    TempAppendix appendix = _template.addAppendix(ContextHelper.getLoginUser(), CMyFile.extractFileName(sSrcFile), false);
                    if (appendix != null) {
                        arrResult.add(appendix);
                    }
                    String sDestFile = _sDestDir + sSrcFile;
                    sSrcFile = sCssFileDir + sSrcFile;
                    CMyFile.copyFile(sSrcFile, sDestFile);
                    csscontent = csscontent.substring(rParenthesesIndex + 1);
                }
            }
            catch (CMyException e) {
                logger.warn((Object)"process css content fail", (Throwable)e);
            }
        }
        return arrResult;
    }
}

