/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.html.HtmlUtil;

public abstract class BaseTagParser4List
extends BaseTagParser
implements ITagParser4List {
    protected IPublishFolder m_oCurrFolder;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;

    protected abstract CMSBaseObjs findObjects(PublishTagContext var1) throws WCMException;

    protected abstract boolean isValidate(PublishTagContext var1) throws WCMException;

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sAutoMore;
        if (!_context.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(_context)) {
            return null;
        }
        CMSBaseObjs oDefaultObjects = this.findObjects(_context);
        this.m_contents = PublishElementFactory.makeElementsFrom(oDefaultObjects);
        this.m_nextRecordContext = new PublishTagContext(_context, _context.getTagItem(), this);
        String[] results = TagParseHelper.parse4List(_context.getTagItem(), _context, this);
        if (results != null && results.length == 1 && _context.getAttribute("AUTOMORE", false) && (sAutoMore = this.parseAutoMore(this.m_oCurrFolder, _context)) != null) {
            results[0] = results[0] + sAutoMore;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseAutoMore(IPublishFolder _currFolder, PublishTagContext _context) throws WCMException {
        String sBegin = _context.getAttribute("BEGINMORE");
        String sEnd = _context.getAttribute("ENDMORE");
        String sText = _context.getAttribute("MORETEXT");
        String sTarget = _context.getAttribute("MORETARGET");
        String sExtra = _context.getAttribute("MOREEXTRA");
        if (sText == null || (sText = sText.trim()).length() == 0) {
            sText = I18NMessage.get(BaseTagParser4List.class, "BaseTagParser4List.label1", "\u66f4\u591a\u5185\u5bb9...");
        }
        if (sTarget == null || (sTarget = sTarget.trim()).length() == 0) {
            sTarget = "_blank";
        }
        StringBuffer buff = new StringBuffer();
        try {
            String sUrl = _context.getPathCompass().getAbsoluteHttpPath(_currFolder);
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
            if (sBegin != null && sBegin.length() > 0) {
                buff.append(sBegin);
            }
            buff.append("<A href=\"").append(sUrl);
            buff.append("\" target=\"").append(sTarget).append("\" ");
            if (sExtra != null) {
                buff.append(sExtra);
            }
            buff.append('>').append(sText).append("</A>");
            if (sEnd != null && sEnd.length() > 0) {
                buff.append(sEnd);
            }
            String string = buff.toString();
            return string;
        }
        finally {
            buff.setLength(0);
        }
    }

    @Override
    public int getRecordSize() {
        return this.getObjectsSize();
    }

    private int getObjectsSize() {
        if (this.m_contents == null) {
            return 0;
        }
        return this.m_contents.size();
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishElement element = this.m_contents.get(this.m_nCurrPos++);
            int size = this.m_contents.size();
            while (element == null && this.m_nCurrPos < size) {
                element = this.m_contents.get(this.m_nCurrPos++);
            }
            if (element == null) {
                return null;
            }
            if (element instanceof IPublishContent) {
                IPublishContent content = (IPublishContent)element;
                content.setFolder(this.m_oCurrFolder);
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(element);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            IPublishElement element = this.m_contents.get(this.m_nCurrPos++);
            if (element == null) {
                return this.substantiateContext(_tagConext);
            }
            if (element instanceof IPublishContent) {
                IPublishContent content = (IPublishContent)element;
                content.setFolder(this.m_oCurrFolder);
            }
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(element);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }
}

