/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.common.message.ISendWorker;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageSendingMapper;
import com.trs.components.common.message.Messages;
import com.trs.components.common.message.MsgQueue;
import com.trs.components.common.message.MsgQueues;
import com.trs.components.common.message.MsgReceiver;
import com.trs.components.common.message.MsgReceivers;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class MessageServer {
    private static Logger logger = Logger.getLogger(MessageServer.class);

    public static void send(Message _currMessage) throws WCMException {
        if (_currMessage == null) {
            throw new WCMException(10, I18NMessage.get(MessageServer.class, "MessageServer.label1", "\u8981\u53d1\u9001\u7684\u6d88\u606f\u65e0\u6548[null]"));
        }
        Users users = _currMessage.getReceivers();
        if (_currMessage.isAddMode()) {
            _currMessage.insert(ContextHelper.getLoginUser());
        }
        MessageServer.sendTo(_currMessage, users);
    }

    private static void sendTo(Message _currMsg, Users _users) throws WCMException {
        String sSendTypes = _currMsg.getSendType();
        User currUser = null;
        String[] arSendTypeNames = CMyString.split(sSendTypes, ",");
        ISendWorker worker = null;
        for (int i = 0; i < arSendTypeNames.length; ++i) {
            String sBeanId = MessageSendingMapper.getInstance().getWorker(arSendTypeNames[i]);
            if (sBeanId == null) {
                throw new WCMException(1354, "Unknown message send type: " + arSendTypeNames[i]);
            }
            worker = (ISendWorker)DreamFactory.createObjectById(sBeanId);
            for (int j = 0; j < _users.size(); ++j) {
                currUser = (User)_users.getAt(j);
                if (currUser == null) continue;
                worker.send(_currMsg, currUser);
            }
        }
    }

    public static Messages getUnreadMessages(User _currUser, WCMFilter _filter) throws WCMException {
        String sWhere = "EXISTS(SELECT MsgId FROM WCMMsgQueue WHERE ObjId=" + _currUser.getId() + " AND ObjType=" + 204 + " AND WCMMessage.MsgId=WCMMsgQueue.MsgId AND Readed=" + 0 + ")";
        WCMFilter aFilter = new WCMFilter("", sWhere, "CrTime desc");
        aFilter.mergeWith(_filter);
        return Messages.openWCMObjs(_currUser, aFilter);
    }

    public static boolean hasUnreadMessage(User _currUser) throws WCMException {
        return MessageServer.hasUnreadMessage(_currUser, null);
    }

    public static boolean hasUnreadMessage(User _currUser, int[] _pMsgType) throws WCMException {
        String SQL = "SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 and Readed=0";
        int nTypeCount = _pMsgType == null ? 0 : _pMsgType.length;
        StringBuffer sbSQL = new StringBuffer("SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 and Readed=0".length() + nTypeCount * 16);
        sbSQL.append("SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 and Readed=0");
        if (nTypeCount > 0) {
            sbSQL.append(" and (");
            sbSQL.append("MsgType=?");
            for (int i = 1; i < nTypeCount; ++i) {
                sbSQL.append(" or ");
                sbSQL.append("MsgType=?");
            }
            sbSQL.append(")");
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            int i;
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement(sbSQL.toString());
            oPreStmt.setMaxRows(1);
            oPreStmt.setInt(1, _currUser.getId());
            for (i = 0; i < nTypeCount; ++i) {
                oPreStmt.setInt(2 + i, _pMsgType[i]);
            }
            result = oPreStmt.executeQuery();
            i = result.next() ? 1 : 0;
            return i != 0;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to get unread messages!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public static Messages getSentMsgs(User _currUser, WCMFilter _currFiilter) throws WCMException {
        String sWhere = "CrUser=? AND DeletedBySender=0";
        WCMFilter aFilter = new WCMFilter("", sWhere, "CrTime desc");
        aFilter.addSearchValues(0, _currUser.getName());
        aFilter.mergeWith(_currFiilter);
        return Messages.openWCMObjs(_currUser, aFilter);
    }

    public static Messages getReceivedMsgs(User _currUser, WCMFilter _currFiilter) throws WCMException {
        String sWhere = "EXISTS(SELECT MsgId FROM WCMMsgQueue WHERE ObjId=" + _currUser.getId() + " AND ObjType=" + 204 + " AND WCMMessage.MsgId=WCMMsgQueue.MsgId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "CrTime desc");
        aFilter.mergeWith(_currFiilter);
        return Messages.openWCMObjs(_currUser, aFilter);
    }

    public static void delete(User _currUser, String _sDelMsgIds) throws WCMException {
        Messages messages = Messages.findByIds(_currUser, _sDelMsgIds);
        MessageServer.delete(_currUser, messages);
    }

    private static void deleteBySender(User _currUser, Message _msgToDel) throws WCMException {
        if (MessageServer.isCanDrop(_currUser, _msgToDel)) {
            _msgToDel.delete(_currUser);
        } else {
            _msgToDel.canEdit(_currUser);
            _msgToDel.setDeletedBySender();
            _msgToDel.update(_currUser);
        }
    }

    private static void deleteByReceiver(User _currUser, Message _msgToDel) throws WCMException {
        MsgQueue msgQueue = MessageServer.getMsgQueue(_msgToDel.getId(), _currUser);
        if (msgQueue != null) {
            msgQueue.delete(_currUser);
        }
        if (_msgToDel.isDeletedBySender() && MessageServer.isCanDrop(_currUser, _msgToDel)) {
            _msgToDel.delete(_currUser);
        }
    }

    private static boolean isCanDrop(User _currUser, Message _msgToDel) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMMSGQUEUE", "MsgId=" + _msgToDel.getId(), "");
        MsgQueues msgQueues = MsgQueues.openWCMObjs(_currUser, aFilter);
        return msgQueues.isEmpty();
    }

    public static void emptyInbox(User _currUser) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMMSGQUEUE", "ObjId=" + _currUser.getId() + " AND ObjType=" + 204, "");
        MsgQueues msgQueues = MsgQueues.openWCMObjs(_currUser, aFilter);
        msgQueues.removeAll();
    }

    public static void emptyOutbox(User _currUser) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "DeletedBySender=0", "");
        Messages messages = MessageServer.getSentMsgs(_currUser, aFilter);
        MessageServer.delete(_currUser, messages);
    }

    private static void delete(User _currUser, Messages _msgsToDel) throws WCMException {
        Message msg = null;
        for (int i = 0; i < _msgsToDel.size(); ++i) {
            msg = (Message)_msgsToDel.getAt(i);
            if (msg == null) continue;
            if (msg.getCrUserName().equals(_currUser.getName())) {
                MessageServer.deleteBySender(_currUser, msg);
            }
            MessageServer.deleteByReceiver(_currUser, msg);
        }
    }

    public static boolean isMessageReaded(Message _currMessage, User _currUser) throws WCMException {
        MsgQueue msgQueue = MessageServer.getMsgQueue(_currMessage.getId(), _currUser);
        if (msgQueue == null) {
            return false;
        }
        return msgQueue.isReaded();
    }

    public static void setMessageReaded(Message _currMessage, User _currUser, boolean _bMessageReaded) throws WCMException {
        MsgQueue msgQueue = MessageServer.getMsgQueue(_currMessage.getId(), _currUser);
        if (msgQueue == null) {
            return;
        }
        if (_bMessageReaded && msgQueue.isReaded() || !_bMessageReaded && !msgQueue.isReaded()) {
            return;
        }
        try {
            msgQueue.validCanEditAndLock(_currUser);
            msgQueue.setReaded(_bMessageReaded);
            msgQueue.update(_currUser);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static MsgQueue getMsgQueue(int _nMsgId, User _currUser) throws WCMException {
        String sWhere = "MsgId=" + _nMsgId + " AND ObjId=" + _currUser.getId() + " AND ObjType=" + 204;
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.setMaxRowNumber(1);
        MsgQueues msgQueues = MsgQueues.openWCMObjs(_currUser, aFilter);
        if (msgQueues.isEmpty()) {
            return null;
        }
        return (MsgQueue)msgQueues.getAt(0);
    }

    public static Messages getMessages(int _nReadFlag, User _loginUser, WCMFilter _aFilter) throws WCMException {
        switch (_nReadFlag) {
            case 0: {
                return MessageServer.getUnreadMessages(_loginUser, _aFilter);
            }
            case 2: {
                return MessageServer.getReceivedMsgs(_loginUser, _aFilter);
            }
            case 1: {
                return MessageServer.getSentMsgs(_loginUser, _aFilter);
            }
        }
        return null;
    }

    public static String getReceiverNames(Message _currMsg, int _nReceiverType) throws WCMException {
        if (_currMsg == null) {
            throw new WCMException(10, I18NMessage.get(MessageServer.class, "MessageServer.label2", "\u65e0\u6548\u7684\u6d88\u606f\u5bf9\u8c61!"));
        }
        WCMFilter aFilter = new WCMFilter("WCMMSGRECEIVER", "MsgId=" + _currMsg.getId() + " AND RECEIVERTYPE=" + _nReceiverType, "", "ReceiverName");
        MsgReceivers receivers = MsgReceivers.openWCMObjs(aFilter);
        String sReceiverNames = ",";
        MsgReceiver receiver = null;
        for (int i = 0; i < receivers.size(); ++i) {
            receiver = (MsgReceiver)receivers.getAt(i);
            if (receiver == null) continue;
            sReceiverNames = sReceiverNames + receiver.getReceiverName() + ",";
        }
        return sReceiverNames.substring(1);
    }

    public static Message findById(User _currUser, int _nMsgId) throws WCMException {
        String sWhere = "MSGID=? and (CrUser=?  or EXISTS(SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 AND WCMMessage.MsgId=WCMMsgQueue.MsgId))";
        WCMFilter aFilter = new WCMFilter("", sWhere, "CrTime desc");
        aFilter.addSearchValues(0, _nMsgId);
        aFilter.addSearchValues(1, _currUser.getName());
        aFilter.addSearchValues(2, _currUser.getId());
        aFilter.setMaxRowNumber(1);
        Messages messages = new Messages(_currUser, 1, 1);
        messages.setMaxSize(1);
        messages.open(aFilter);
        if (messages.isEmpty()) {
            return null;
        }
        return (Message)messages.getAt(0);
    }

    public static Messages findByIds(User _currUser, String _sMsgIds) throws WCMException {
        MessageServer.assertValidIdSequence(_sMsgIds);
        String sWhere = "MSGID in(" + _sMsgIds + ") and (CrUser=?  or EXISTS(SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 AND WCMMessage.MsgId=WCMMsgQueue.MsgId))";
        WCMFilter aFilter = new WCMFilter("", sWhere, "CrTime desc");
        aFilter.addSearchValues(0, _currUser.getName());
        aFilter.addSearchValues(1, _currUser.getId());
        Messages messages = new Messages(_currUser);
        messages.open(aFilter);
        return messages;
    }

    private static void assertValidIdSequence(String _sMsgIds) throws WCMException {
        if (CMyString.isEmpty(_sMsgIds)) {
            throw new WCMException(10, "\u65e0\u6548\u7684ID\u5e8f\u5217.");
        }
        for (char id : _sMsgIds.trim().toCharArray()) {
            if (id == ',' || id == ' ' || Character.isDigit(id)) continue;
            throw new WCMException(10, "\u65e0\u6548\u7684ID\u5e8f\u5217.");
        }
    }

    public static void deleteMessage(int nFlowDocId, User currUser) throws WCMException {
        String messageBodyInfo = "app/flowdoc/workflow_process_render.jsp?FlowDocId=" + nFlowDocId;
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer strWhere = new StringBuffer();
        strWhere.append("MSGTYPE=? AND MBODY LIKE ? AND MSGID in(");
        strWhere.append("SELECT MSGID FROM WCMMSGRECEIVER WHERE RECEIVERTYPE=204 AND RECEIVERID=?");
        strWhere.append(")");
        filter.addSearchValues(3);
        filter.addSearchValues("%" + messageBodyInfo + "%");
        filter.addSearchValues(currUser.getId());
        filter.setWhere(strWhere.toString());
        Messages messages = Messages.openWCMObjs(currUser, filter);
        if (messages.size() == 0) {
            return;
        }
        Message message = (Message)messages.getAt(0);
        if (message != null) {
            MessageServer.delete(currUser, String.valueOf(message.getId()));
        }
    }
}

