/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.message.MsgQueues;
import com.trs.components.common.message.MsgReceiver;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.tools.TextFilter;
import java.util.HashMap;
import java.util.Map;

public class Message
extends CMSObj {
    private static final int MBODY_MAX_LENGTH = 1000;
    public static final int OBJ_TYPE = 309;
    public static final String DB_TABLE_NAME = "WCMMESSAGE";
    public static final String DB_ID_NAME = "MSGID";
    public static final int FLAG_UNKOWN = -1;
    public static final int FLAG_NODELETE = 0;
    public static final int FLAG_DELETE = 1;
    public static final int FLAG_CALLBOARD = 2;
    public static final int MESSAGE_STATE_NODELETE = 0;
    public static final int MESSAGE_STATE_DELETE = 1;
    public static final int MESSAGE_STATE_CALLBOARD = 2;
    public static final int TYPE_NORM = 1;
    public static final int TYPE_PUBLISH = 2;
    public static final int TYPE_WORKFLOW = 3;
    private Map m_hReceivers;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 309;
    }

    public String getTitle() {
        return (String)this.getProperty("TITLE");
    }

    public boolean setTitle(String _title) throws WCMException {
        return this.setProperty("TITLE", _title);
    }

    public String getBody() {
        String body = (String)this.getProperty("MBODY");
        return body != null ? body : this.getPropertyAsString("BIGMBODY");
    }

    public boolean setBody(String _body) throws WCMException {
        CDBText text = new CDBText(this.getDBManager().getDBType());
        if (this.isBigBody(_body)) {
            text.setText(_body);
            return this.setProperty("BIGMBODY", text);
        }
        text.setText("");
        this.setProperty("BIGMBODY", text);
        return this.setProperty("MBODY", _body);
    }

    private boolean isBigBody(String _body) {
        return _body.getBytes().length > 1000;
    }

    public CMyDateTime getValidTime() {
        return (CMyDateTime)this.getProperty("VALID");
    }

    public boolean setValidTime(CMyDateTime _time) throws WCMException {
        if (_time == null || _time.isNull()) {
            throw new WCMException(1102, I18NMessage.get(Message.class, "Message.label1", "\u65e0\u6548\u7684\u65e5\u671f\u5bf9\u8c61(Message.setValidTime)"));
        }
        return this.setProperty("VALID", _time);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    public int getFlag() {
        return this.getPropertyAsInt("FLAG", -1);
    }

    public boolean setFlag(int _flag) throws WCMException {
        if (_flag != 1 && _flag != 0 && _flag != 2) {
            throw new WCMException(10, I18NMessage.get(Message.class, "Message.label2", "Flag\u503c\u65e0\u6548(Message.setFlag)"));
        }
        return this.setProperty("FLAG", _flag);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sText = this.getFinalPropertyAsString("BIGMBODY");
        if (CMyString.isEmpty(sText)) {
            sText = this.getFinalPropertyAsString("MBODY");
        }
        if (!CMyString.isEmpty(sText)) {
            sText = TextFilter.stripText(sText, true);
            this.setBody(sText);
        }
        if (this.isAddMode()) {
            if (this.getAllProperty().get("TITLE") == null) {
                throw new WCMException(1106, I18NMessage.get(Message.class, "Message.label3", "\u5c5e\u6027Title\u6ca1\u6709\u8bbe\u7f6e(Message.isValid)"));
            }
            if (this.m_hReceivers == null) {
                throw new WCMException(1106, I18NMessage.get(Message.class, "Message.label4", "\u6ca1\u6709\u8bbe\u7f6e\u6d88\u606f\u7684\u63a5\u6536\u8005!"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Message.class, "Message.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Message.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            if (this.isBigBody(this.getBody())) {
                this.setBody(this.getBody());
                this.removeProperty("MBODY");
            }
            super.insert(_currUser);
            this.saveReceivers();
        }
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        String[] strSQLs = new String[1];
        try {
            strSQLs[0] = "delete from wcmMsgQueue where MsgId=" + this.getId();
            this.getDBManager().sqlExecuteUpdate(strSQLs);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Message.class, "Message.label6", "\u5220\u9664MsgQueue\u6570\u636e\u5931\u8d25\uff08Message.delete\uff09"), ex);
        }
        return super.delete(_currUser);
    }

    public MsgQueues getMsgQueues(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "MsgId=" + this.getId(), "");
        MsgQueues aMsgQueues = new MsgQueues(_currUser);
        try {
            aMsgQueues.open(filter);
            return aMsgQueues;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Message.class, "Message.label7", "\u53d6\u6240\u53d1\u6d88\u606f\u7684\u4f20\u9012\u4fe1\u606f\u961f\u5217\u65f6\u51fa\u9519(Message.getMsgQueues)"), ex);
        }
    }

    public boolean isQueue(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("wcmMsgQueue", "MsgId=" + this.getId(), "", "QueueId");
        MsgQueues aMsgQueues = new MsgQueues(_currUser);
        try {
            aMsgQueues.open(filter);
            boolean bIsQueue = !aMsgQueues.isEmpty();
            aMsgQueues.clear();
            return bIsQueue;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Message.class, "Message.label8", "\u5224\u65ad\u6d88\u606f\u662f\u5426\u5728\u961f\u5217\u4e2d\u65f6\u51fa\u9519(Message.isQueue)"), ex);
        }
    }

    public String getSendType() {
        return this.getPropertyAsString("SENDTYPE");
    }

    public boolean setSendTypes(String _sSendType) throws WCMException {
        return this.setProperty("SENDTYPE", _sSendType);
    }

    public boolean setSendTypes(String[] _arSendTypes) throws WCMException {
        String sSendWorkerNames = "";
        for (int i = 0; i < _arSendTypes.length; ++i) {
            if (sSendWorkerNames.indexOf(_arSendTypes[i]) != -1) continue;
            sSendWorkerNames = sSendWorkerNames + "," + _arSendTypes[i];
        }
        return this.setProperty("SENDTYPE", sSendWorkerNames);
    }

    public boolean setDeletedBySender() throws WCMException {
        return this.setProperty("DELETEDBYSENDER", 1L);
    }

    boolean isDeletedBySender() {
        return this.getPropertyAsBoolean("DELETEDBYSENDER", false);
    }

    public static final Message findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Message)BaseObj.findById(Message.class, _nId);
    }

    public static final Message createNewInstance() throws WCMException {
        return (Message)BaseObj.createNewInstance(Message.class);
    }

    public static final Message findByKey(Object _oKey) throws WCMException {
        return (Message)BaseObj.findByKey(Message.class, _oKey);
    }

    public void setReceivers(int _nReceiverType, String _sReceiverIds) {
        if (_sReceiverIds == null || _sReceiverIds.length() == 0) {
            return;
        }
        Integer iKey = new Integer(_nReceiverType);
        if (this.m_hReceivers == null) {
            this.m_hReceivers = new HashMap();
        }
        this.m_hReceivers.put(iKey, _sReceiverIds);
    }

    public Users getReceivers() throws WCMException {
        String sUserIds;
        User currUser = User.getSystem();
        Users users = Users.createNewInstance(currUser);
        WCMFilter aFilter = null;
        String sWhere = null;
        if (this.isAddMode()) {
            String sRoleIds;
            String sGroupIds;
            sUserIds = this.getReceiverIds(204);
            if (sUserIds != null && sUserIds.length() > 0) {
                users.addWith(Users.findByIds(currUser, sUserIds));
            }
            if ((sGroupIds = this.getReceiverIds(201)) != null && sGroupIds.length() > 0) {
                sWhere = "EXISTS(SELECT UserId FROM WCMGrpUser WHERE GroupId in(" + sGroupIds + ") AND WCMUser.UserId=WCMGrpUser.UserId)";
                aFilter = new WCMFilter("", sWhere, "");
                users.addWith(Users.openWCMObjs(currUser, aFilter));
            }
            if ((sRoleIds = this.getReceiverIds(203)) != null && sRoleIds.length() > 0) {
                sWhere = null;
                if (!sRoleIds.equals(String.valueOf(2))) {
                    sWhere = "EXISTS(SELECT UserId FROM WCMRoleUser WHERE RoleId in(" + sRoleIds + ") AND WCMUser.UserId=WCMRoleUser.UserId)";
                }
                aFilter = new WCMFilter("", sWhere, "");
                aFilter.setWhere(sWhere);
                users.addWith(Users.openWCMObjs(currUser, aFilter));
            }
        } else {
            sWhere = "EXISTS(SELECT UserId FROM WCMGrpUser WHERE EXISTS(SELECT ReceiverId FROM WCMMsgReceiver WHERE MsgId=" + this.getId() + " AND ReceiverType=" + 201 + " AND WCMGrpUser.GroupId=WCMMsgReceiver.ReceiverId) AND WCMUser.UserId=WCMGrpUser.UserId)";
            aFilter = new WCMFilter("", sWhere, "");
            users.addWith(Users.openWCMObjs(currUser, aFilter));
            sWhere = "EXISTS(SELECT UserId FROM WCMRoleUser WHERE EXISTS(SELECT ReceiverId FROM WCMMsgReceiver WHERE MsgId=" + this.getId() + " AND ReceiverType=" + 203 + " AND WCMRoleUser.RoleId=WCMMsgReceiver.ReceiverId) AND WCMUser.UserId=WCMRoleUser.UserId)";
            aFilter.setWhere(sWhere);
            users.addWith(Users.openWCMObjs(currUser, aFilter));
            sWhere = "EXISTS(SELECT ReceiverId FROM WCMMsgReceiver WHERE MsgId=" + this.getId() + " AND ReceiverType=" + 204 + " AND WCMUser.UserId=WCMMsgReceiver.ReceiverId)";
            aFilter.setWhere(sWhere);
            users.addWith(Users.openWCMObjs(currUser, aFilter));
        }
        sUserIds = users.getIdListAsString();
        WCMFilter filterAvailable = new WCMFilter("", "IsDeleted=0 and Status=30 and UserId in (" + sUserIds + ")", "");
        users = new Users(currUser);
        users.open(filterAvailable);
        return users;
    }

    private void saveReceivers() throws WCMException {
        this.setReceiverUsers();
        this.setReceiverGroups();
        this.setReceiverRoles();
    }

    private void setReceiverRoles() throws WCMException {
        String sRoleIds = this.getReceiverIds(203);
        if (sRoleIds == null || sRoleIds.length() == 0) {
            return;
        }
        Roles roles = Roles.findByIds(User.getSystem(), sRoleIds);
        for (int i = 0; i < roles.size(); ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null) continue;
            this.saveReceiver(role.getId(), role.getWCMType(), role.getName());
        }
    }

    private void setReceiverGroups() throws WCMException {
        String sGroupIds = this.getReceiverIds(201);
        if (sGroupIds == null || sGroupIds.length() == 0) {
            return;
        }
        Groups groups = Groups.findByIds(User.getSystem(), sGroupIds);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            this.saveReceiver(group.getId(), group.getWCMType(), group.getName());
        }
    }

    private void setReceiverUsers() throws WCMException {
        String sUserIds = this.getReceiverIds(204);
        if (sUserIds == null || sUserIds.length() == 0) {
            return;
        }
        Users users = Users.findByIds(User.getSystem(), sUserIds);
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.getAt(i);
            if (user == null) continue;
            this.saveReceiver(user.getId(), user.getWCMType(), user.getName());
        }
    }

    private String getReceiverIds(int _nReceiverType) {
        if (this.m_hReceivers == null) {
            return null;
        }
        return (String)this.m_hReceivers.get(new Integer(_nReceiverType));
    }

    private void saveReceiver(int _nReceiverId, int _nReceiverType, String _sReceiverName) throws WCMException {
        MsgReceiver receiver = MsgReceiver.createNewInstance();
        receiver.setMsgId(this.getId());
        receiver.setReceiverId(_nReceiverId);
        receiver.setReceiverType(_nReceiverType);
        receiver.setReceiverName(_sReceiverName);
        receiver.insert();
    }
}

