/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.collector;

import com.trs.components.collector.IInformation;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.util.HashMap;

public class WCMFixIndexInfo
implements IInformation {
    private static final String FIELDNAME = "FIXINDEX";
    private static final String FIXEXT = "WCMFIX";

    @Override
    public HashMap<String, String> getInfo() {
        HashMap<String, String> infoMap = new HashMap<String, String>(1);
        String path = ConfigServer.getServer().getInitProperty("WCM_PATH");
        FileService f = new FileService(path + "/fix");
        if (!f.exists()) {
            infoMap.put(FIELDNAME, "\u6ca1\u5b89\u88c5\u4efb\u4f55fix");
        } else {
            infoMap.put(FIELDNAME, this.getFixIndex(f));
        }
        return infoMap;
    }

    private String getFixIndex(FileStore file) {
        if (file.isFile() || 0 == file.list().length) {
            return "\u6ca1\u5b89\u88c5\u4efb\u4f55fix";
        }
        FileStore[] files = file.listFiles();
        String sLastFixIndex = "\u6ca1\u5b89\u88c5\u4efb\u4f55fix";
        int iLastFixIndex = 0;
        for (int i = files.length - 1; i >= 0; --i) {
            FileStore f = files[i];
            String fileName = f.getName();
            String fileExt = this.getFileExtension(fileName);
            if (!fileExt.equalsIgnoreCase(FIXEXT) || fileName.indexOf("_") <= 0) continue;
            String sFixIndex = fileName.substring(0, fileName.indexOf("_"));
            int iFixIndex = Integer.parseInt(sFixIndex);
            iLastFixIndex = iLastFixIndex > iFixIndex ? iLastFixIndex : iFixIndex;
            sLastFixIndex = iLastFixIndex > iFixIndex ? sLastFixIndex : sFixIndex;
        }
        return sLastFixIndex;
    }

    private String getFileExtension(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }
}

