/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Role
extends CMSObj
implements Serializable {
    private static final long serialVersionUID = 7232302897977228998L;
    public static final int OBJ_TYPE = 203;
    public static final String DB_TABLE_NAME = "WCMROLE";
    public static final String DB_ID_NAME = "ROLEID";
    public static final int ADMINISTRATORS_ID = 1;
    public static final int EVERYONE_ID = 2;
    public static final String ROLEMANAGERS_NAME = "RoleManagers";
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_SPECIAL = 0;
    public static final int TYPE_SYSTEM = -1;
    public static final int TYPE_SITE = -2;
    public static final int RANGE_ADMINISTRATOR = -1;
    public static final int RANGE_ALL = 1;
    public static final int RANGE_GROUP = 0;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 203;
    }

    public String getName() {
        return (String)this.getProperty("ROLENAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("ROLENAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("ROLEDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("ROLEDESC", _desc);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public StringTokenizer getEmails() {
        String sEmail = this.getEmail();
        if (sEmail == null) {
            return null;
        }
        return new StringTokenizer(sEmail, ";");
    }

    public boolean setEmail(String _email) throws WCMException {
        return this.setProperty("EMAIL", _email);
    }

    public boolean isSysDefined() {
        return this.getPropertyAsBoolean("SYSDEFINED", true);
    }

    public boolean setSysDefined(boolean _bSysDefined) throws WCMException {
        return this.setProperty("SYSDEFINED", _bSysDefined);
    }

    public boolean isViewable() {
        return this.getPropertyAsBoolean("VIEWABLE", false);
    }

    public boolean setViewable(boolean _bVeiwable) throws WCMException {
        return this.setProperty("VIEWABLE", _bVeiwable);
    }

    public boolean isRemoveable() {
        return this.getPropertyAsBoolean("REMOVEABLE", false);
    }

    public boolean setRemoveable(boolean _bRemoveable) throws WCMException {
        return this.setProperty("REMOVEABLE", _bRemoveable);
    }

    public boolean setRoleType(int _nRoleType) throws WCMException {
        return this.setProperty("RoleType", _nRoleType);
    }

    public int getRoleType() {
        return this.getPropertyAsInt("RoleType", 0);
    }

    public boolean isSystemRole() {
        return this.getRoleType() == -1 || this.getRoleType() == -2;
    }

    public boolean setRoleRange(int _nRoleRange) throws WCMException {
        return this.setProperty("RoleRange", _nRoleRange);
    }

    public int getRoleRange() {
        return this.getPropertyAsInt("RoleRange", 0);
    }

    public boolean setRightValue(long _lRightValue) throws WCMException {
        return this.setProperty("RightValue", _lRightValue);
    }

    public long getRightValue() {
        return this.getPropertyAsLong("RightValue", -1L);
    }

    public int getRoleOrder() {
        return this.getPropertyAsInt("RoleOrder", 0);
    }

    public boolean setRoleOrder(int _nOrder) throws WCMException {
        return this.setProperty("RoleOrder", _nOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("ROLENAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(Role.class, "Role.label1", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Role.isValid)"));
            }
            Object prop = this.getProperty("REMOVEABLE");
            if (prop == null) {
                this.setRemoveable(true);
            }
            if ((prop = this.getProperty("VIEWABLE")) == null) {
                this.setViewable(true);
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Role.class, "Role.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Role.isValid)"));
            }
            sName = (String)this.getNewProperty("ROLENAME");
        }
        if (sName != null) {
            WCMFilter filter = new WCMFilter();
            filter.setFrom(DB_TABLE_NAME);
            StringBuilder where = new StringBuilder("RoleName = ?");
            filter.addSearchValues(sName);
            if (!this.isAddMode()) {
                where.append("and " + this.getIdFieldName() + " <> ?");
                filter.addSearchValues(this.getId());
            }
            filter.setWhere(where.toString());
            if (DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0) {
                throw new BizError("\u89d2\u8272\u540d\u79f0[" + sName + "]\u5df2\u7ecf\u5b58\u5728");
            }
        }
        this.changeOrder();
        return true;
    }

    public Users getUsers(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("wcmRoleUser", "RoleId=" + this.getId(), "", "UserId");
        Users aUsers = new Users(_currUser);
        try {
            aUsers.open(filter);
            return aUsers;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Role.class, "Role.label4", "\u83b7\u53d6\u89d2\u8272\u4e2d\u7528\u6237\u96c6\u5408\u65f6\u51fa\u9519\uff08Role.getUsers\uff09"), ex);
        }
    }

    public Rights getMyRights(int _objType) throws WCMException {
        WCMFilter filter = null;
        Rights rights = null;
        try {
            filter = new WCMFilter("", "OprType=" + this.getWCMType() + " and ObjId=" + this.getId() + " and ObjType=" + _objType, "");
            rights = new Rights(null);
            rights.open(filter);
            return rights;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Role.class, "Role.label5", "\u83b7\u53d6\u89d2\u8272\u7684\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(Role.getMyRights)"), ex);
        }
    }

    public RightValue getMyRightValue(CMSObj _obj) throws WCMException {
        if (_obj == null || !_obj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Role.class, "Role.label6", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(Role.getMyRightValue)"));
        }
        return this.getMyRightValue(_obj.getWCMType(), _obj.getId());
    }

    public RightValue getMyRightValue(int _objType, int _objId) throws WCMException {
        RightValue rightValue = new RightValue();
        try {
            rightValue.load(this, _objType, _objId);
            return rightValue;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Role.class, "Role.label7", "\u83b7\u53d6\u89d2\u8272\u5728\u6307\u5b9a\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(Role.getMyRightValue)"), ex);
        }
    }

    public boolean isAdministrators() {
        return this.id == 1;
    }

    public boolean isEveryone() {
        return this.id == 2;
    }

    public boolean isRoleManagers() {
        return ROLEMANAGERS_NAME.equals(this.getName());
    }

    public static final Role findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Role)BaseObj.findById(Role.class, _nId);
    }

    public static final Role createNewInstance() throws WCMException {
        return (Role)BaseObj.createNewInstance(Role.class);
    }

    public static final Role findByKey(Object _oKey) throws WCMException {
        return (Role)BaseObj.findByKey(Role.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Role.class, "Role.label8", "[\u89d2\u8272-") + this.getId() + "]";
    }

    private void changeOrder() throws WCMException {
        if (this.isAddMode()) {
            String sSql = "select max(roleorder) from " + this.getDbTableName() + " where VIEWABLE=1";
            DBManager currDBManager = DBManager.getDBManager();
            if (currDBManager == null || !currDBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01");
            }
            if (!currDBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u6ca1\u6709\u542f\u52a8\uff01");
            }
            int nRoleOrder = currDBManager.sqlExecuteIntQuery(sSql);
            this.setRoleOrder(++nRoleOrder);
        } else {
            Role toRole;
            int nToRoleOrder;
            if (!this.isChangeProperty("RoleOrder")) {
                return;
            }
            int nNewRoleOrder = this.getNewPropertyAsInt("RoleOrder", 0);
            int nOldRoleOrder = this.getPropertyAsInt("RoleOrder", 0);
            WCMFilter filter = new WCMFilter("", "VIEWABLE=1", "ROLEORDER ASC", "RoleId");
            Roles currRoles = Roles.openWCMObjs(null, filter);
            int nSize = currRoles.size();
            int nTargetRoleId = 0;
            int nPosition = 1;
            if (nNewRoleOrder < 0 || nNewRoleOrder >= nSize) {
                nNewRoleOrder = nSize;
                nPosition = 0;
                nTargetRoleId = currRoles.getIdAt(nNewRoleOrder - 1);
            } else if (nNewRoleOrder == 0) {
                nTargetRoleId = currRoles.getIdAt(0);
            } else if (nNewRoleOrder > 0 && nOldRoleOrder > (nToRoleOrder = (toRole = Role.findById(nTargetRoleId = currRoles.getIdAt(nNewRoleOrder - 1))).getRoleOrder())) {
                nPosition = 0;
            }
            if (nTargetRoleId != this.getId()) {
                Role oToRole = Role.findById(nTargetRoleId);
                int nFromRoleOrder = nOldRoleOrder;
                int nToRoleOrder2 = oToRole.getRoleOrder();
                if (this.equals(oToRole) || nFromRoleOrder == nToRoleOrder2) {
                    return;
                }
                int nNewOrder = nFromRoleOrder;
                int nOldOffset = nFromRoleOrder - nToRoleOrder2;
                int nMoveBeginAt = 0;
                int nMoveEndAt = 0;
                int nMoveDirection = 0;
                switch (nPosition) {
                    case 1: {
                        if (nOldOffset == 0) {
                            return;
                        }
                        if (nOldOffset > 0) {
                            nMoveBeginAt = nToRoleOrder2;
                            nMoveEndAt = nFromRoleOrder - 1;
                            nNewOrder = nMoveBeginAt;
                            nMoveDirection = 1;
                            break;
                        }
                        if (nOldOffset >= 0) break;
                        nMoveBeginAt = nFromRoleOrder + 1;
                        nNewOrder = nMoveEndAt = nToRoleOrder2;
                        nMoveDirection = -1;
                        break;
                    }
                    case 0: {
                        if (nOldOffset == 0) {
                            return;
                        }
                        if (nOldOffset > 0) {
                            nMoveBeginAt = nToRoleOrder2;
                            nMoveEndAt = nFromRoleOrder - 1;
                            nNewOrder = nMoveBeginAt;
                            nMoveDirection = 1;
                            break;
                        }
                        if (nOldOffset >= 0) break;
                        nMoveBeginAt = nFromRoleOrder + 1;
                        nNewOrder = nMoveEndAt = nToRoleOrder2;
                        nMoveDirection = -1;
                    }
                }
                String sRegionWhere = "RoleOrder>=" + nMoveBeginAt + " AND RoleOrder <=" + nMoveEndAt + " and VIEWABLE=1";
                String sMoveSql = "UPDATE WCMROLE SET RoleOrder = RoleOrder+(" + nMoveDirection + ") WHERE " + sRegionWhere;
                WCMFilter aFilter = new WCMFilter("", sRegionWhere, "RoleOrder ASC");
                Roles roles = Roles.openWCMObjs(null, aFilter);
                DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
                for (int i = 0; i < roles.size(); ++i) {
                    Role child = (Role)roles.getAt(i);
                    if (child == null) continue;
                    child.refreshProperty("RoleOrder", child.getRoleOrder() + nMoveDirection);
                }
                this.setRoleOrder(nNewOrder);
            }
        }
    }
}

