/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NewRightSet {
    private Logger logger = Logger.getLogger(this.getClass());
    public static final int IMPART_MODE_NODE = 0;
    public static final int IMPART_MODE_ADD = 1;
    public static final int IMPART_MODE_MODIFY = 2;
    public static final int IMPART_MODE_DELETE = 3;
    public static final int IMPART_MODE_ALL = 4;
    private int m_nImpartMode = 0;
    private int[] m_pImpartMode = null;
    private User m_currLoginUser = null;
    private IRightHost m_oTopRightHost = null;
    private List m_arCurrRightsList = null;

    public NewRightSet(User _loginUser, IRightHost _rightHost, List _currRightList, int[] _pImpartMode) {
        this.m_currLoginUser = _loginUser;
        this.m_oTopRightHost = _rightHost;
        this.m_arCurrRightsList = _currRightList;
        this.m_pImpartMode = _pImpartMode;
    }

    public boolean save() throws WCMException {
        this.m_oTopRightHost.validateCanDoSetRight(this.m_currLoginUser);
        Reports reports = new Reports(I18NMessage.get(NewRightSet.class, "NewRightSet.label1", "\u8bbe\u7f6e\u6743\u9650"));
        for (int i = 0; this.m_pImpartMode != null && i < this.m_pImpartMode.length; ++i) {
            this.m_nImpartMode = this.m_pImpartMode[i];
            if (this.m_nImpartMode == 0) continue;
            ArrayList arImpartRights = this.makeImpartRights();
            this.impartRights(this.m_oTopRightHost, arImpartRights, reports);
        }
        this.saveRightsOfTopHost();
        if (reports.getFailedReporter() == null || reports.getFailedReporter().isEmpty()) {
            return true;
        }
        throw new WCMException(I18NMessage.get(NewRightSet.class, "NewRightSet.label2", "\u540c\u6b65\u8bbe\u7f6e\u5b50\u680f\u76ee\u6743\u9650\u5931\u8d25\uff01\n") + reports.toString());
    }

    private void impartRights(IRightHost _parentRightHost, ArrayList _arImpartRights, Reports _reports) throws WCMException {
        IRightHost[] pChildren = _parentRightHost.getChildren();
        if (pChildren == null || pChildren.length == 0) {
            return;
        }
        for (IRightHost children : pChildren) {
            if (children == null) continue;
            this.saveRightOfChildNode(_arImpartRights, children, _reports);
        }
    }

    private ArrayList makeImpartRights() throws WCMException {
        int nSize;
        ArrayList<long[]> arImpartRights = new ArrayList<long[]>(this.m_arCurrRightsList.size());
        switch (this.m_nImpartMode) {
            case 1: {
                nSize = this.m_arCurrRightsList.size();
                for (int i = 0; i < nSize; ++i) {
                    Right right = (Right)this.m_arCurrRightsList.get(i);
                    if (right == null || !right.isAddMode()) continue;
                    arImpartRights.add(new long[]{right.getOperatorType(), right.getOperatorId(), right.getValueAsLong()});
                }
                break;
            }
            case 2: {
                nSize = this.m_arCurrRightsList.size();
                for (int i = 0; i < nSize; ++i) {
                    Right right = (Right)this.m_arCurrRightsList.get(i);
                    if (right == null || right.isAddMode() || !right.isChangeProperty("RIGHTVALUE")) continue;
                    long lRightValue = right.isAddMode() ? right.getValueAsLong() : ((Number)right.getNewProperty("RIGHTVALUE")).longValue();
                    arImpartRights.add(new long[]{right.getOperatorType(), right.getOperatorId(), lRightValue});
                }
                break;
            }
            case 3: {
                int i;
                Rights delRights = this.getDeleteRightsOfHost(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrRightsList));
                int nSize2 = delRights.size();
                for (i = 0; i < nSize2; ++i) {
                    Right right = (Right)delRights.getAt(i);
                    if (right == null) continue;
                    arImpartRights.add(new long[]{right.getOperatorType(), right.getOperatorId(), 0L});
                }
                break;
            }
            case 4: {
                int i;
                int nSize3 = this.m_arCurrRightsList.size();
                for (i = 0; i < nSize3; ++i) {
                    Right right = (Right)this.m_arCurrRightsList.get(i);
                    if (right == null) continue;
                    long lRightValue = right.isAddMode() ? right.getValueAsLong() : ((Number)right.getNewProperty("RIGHTVALUE")).longValue();
                    arImpartRights.add(new long[]{right.getOperatorType(), right.getOperatorId(), lRightValue});
                }
                break;
            }
        }
        if (this.logger.isDebugEnabled() && arImpartRights != null) {
            nSize = arImpartRights.size();
            for (int i = 0; i < nSize; ++i) {
                long[] pRightInfo = (long[])arImpartRights.get(i);
                for (int j = 0; j < pRightInfo.length; ++j) {
                    this.logger.debug((Object)(i + "." + j + ":" + pRightInfo[j]));
                }
            }
        }
        return arImpartRights;
    }

    private boolean saveRightsOfTopHost() throws WCMException {
        this.deleteRights(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrRightsList));
        if (this.m_arCurrRightsList == null || this.m_arCurrRightsList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.m_arCurrRightsList.size(); ++i) {
            Right currRight = (Right)this.m_arCurrRightsList.get(i);
            if (currRight == null) {
                this.logger.error((Object)I18NMessage.get(NewRightSet.class, "NewRightSet.label3", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (currRight.getObjType() == 0 || currRight.getId() <= 0) {
                currRight.setObject(this.m_oTopRightHost.getSubstance());
            }
            currRight.save(this.m_currLoginUser);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(I18NMessage.get(NewRightSet.class, "NewRightSet.label4", "\u4fdd\u5b58[") + this.m_oTopRightHost.getSubstance() + "]right[" + i + "]\uff01<BR>"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveRightOfChildNode(ArrayList _arImpartRights, IRightHost _currRightHost, Reports _reports) throws WCMException {
        this.logger.debug((Object)(_currRightHost.getInfo() + " impart right..."));
        try {
            _currRightHost.validateCanDoSetRight(this.m_currLoginUser);
        }
        catch (Exception e) {
            _reports.addFailedReport(CMyString.format(I18NMessage.get(NewRightSet.class, "NewRightSet.label9", "\u6ca1\u6709\u6743\u9650\u7ed9{0}\u4f20\u9012\u6743\u9650\u8bbe\u7f6e."), new String[]{_currRightHost.getInfo()}), null);
            return false;
        }
        switch (this.m_nImpartMode) {
            case 1: 
            case 2: 
            case 3: {
                if (_arImpartRights != null && !_arImpartRights.isEmpty()) break;
                return true;
            }
            case 4: {
                if (_arImpartRights != null && !_arImpartRights.isEmpty()) break;
                Rights rights = this.getDeleteRightsOfHost(this.m_currLoginUser, _currRightHost.getSubstance(), new int[0]);
                rights.removeAll(true);
                this.impartRights(_currRightHost, _arImpartRights, _reports);
                return true;
            }
            default: {
                return false;
            }
        }
        this.logger.debug((Object)(_currRightHost.getInfo() + " impart right for!"));
        int[] pRightIds = new int[_arImpartRights.size()];
        block20: for (int i = 0; i < _arImpartRights.size(); ++i) {
            long[] pRightInfo = (long[])_arImpartRights.get(i);
            int nObjType = _currRightHost.getType();
            int nObjId = _currRightHost.getId();
            int nOprType = (int)pRightInfo[0];
            int nOprId = (int)pRightInfo[1];
            long lRightValue = pRightInfo[2];
            Right right = Right.findBy(nObjType, nObjId, nOprType, nOprId);
            try {
                switch (this.m_nImpartMode) {
                    case 1: 
                    case 4: {
                        boolean bAddMode;
                        boolean bl = bAddMode = right == null;
                        if (right == null) {
                            right = Right.createNewInstance();
                            right.setObject(nObjType, nObjId);
                            right.setOperator(nOprType, nOprId);
                        } else {
                            pRightIds[i] = right.getId();
                            if (!right.canEdit(this.m_currLoginUser)) {
                                _reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + nObjType + ", ObjId=" + nObjId + ", OprType=" + nOprType + ", OprId=" + nOprId + "] ", null);
                                continue block20;
                            }
                            if (right.getValueAsLong() == lRightValue) continue block20;
                        }
                        right.setValue(lRightValue);
                        this.logger.debug((Object)(_currRightHost.getInfo() + " impart right save right!" + right.isAddMode()));
                        right.save(this.m_currLoginUser);
                        this.logger.debug((Object)(_currRightHost.getInfo() + " impart right save right!" + right.getId()));
                        if (!bAddMode) break;
                        pRightIds[i] = right.getId();
                        break;
                    }
                    case 2: {
                        this.logger.debug((Object)("modify right:" + right));
                        if (right == null || right.getValueAsLong() == lRightValue) continue block20;
                        this.logger.debug((Object)("modify right.value:" + lRightValue));
                        if (!right.canEdit(this.m_currLoginUser)) {
                            _reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + nObjType + ", ObjId=" + nObjId + ", OprType=" + nOprType + ", OprId=" + nOprId + "] ", null);
                            continue block20;
                        }
                        right.setValue(lRightValue);
                        right.save(this.m_currLoginUser);
                        this.logger.debug((Object)"modify right success!");
                        break;
                    }
                    case 3: 
                }
                continue;
            }
            finally {
                if (right != null && right.isLocked() && right.getLockerUserName().equalsIgnoreCase(this.m_currLoginUser.getName())) {
                    right.unlock();
                }
            }
        }
        if (this.m_nImpartMode == 4) {
            Rights rights = this.getDeleteRightsOfHost(this.m_currLoginUser, _currRightHost.getSubstance(), pRightIds);
            this.logger.debug((Object)(_currRightHost.getInfo() + " impart right delete right!" + rights.getIdListAsString()));
            rights.removeAll(true);
        }
        this.impartRights(_currRightHost, _arImpartRights, _reports);
        return true;
    }

    private boolean deleteRights(User loginUser, CMSObj _aObj, String _sCurrentRightIds) throws WCMException {
        if (_aObj == null) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(I18NMessage.get(NewRightSet.class, "NewRightSet.label8", "\u5220\u9664[") + _aObj + "][" + _sCurrentRightIds + "]rights...\n<BR>\n"));
        }
        Rights delRights = this.getDeleteRightsOfHost(loginUser, _aObj, _sCurrentRightIds);
        delRights.removeAll(true);
        return true;
    }

    private Rights getDeleteRightsOfHost(User _loginUser, CMSObj _host, String _sCurrentRightIds) throws WCMException {
        int[] pRightIds = null;
        if (!CMyString.isEmpty(_sCurrentRightIds)) {
            pRightIds = CMyString.splitToInt(_sCurrentRightIds, ",");
        }
        return this.getDeleteRightsOfHost(_loginUser, _host, pRightIds);
    }

    private Rights getDeleteRightsOfHost(User _loginUser, CMSObj _host, int[] _pCurrentRightIds) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "", "");
        String sWhere = "OBJTYPE=? and OBJID=?";
        aFilter.addSearchValues(_host.getWCMType());
        aFilter.addSearchValues(_host.getId());
        if (_pCurrentRightIds != null && _pCurrentRightIds.length > 0) {
            StringBuffer sbRightIdWhere = new StringBuffer(_pCurrentRightIds.length * 3);
            sbRightIdWhere.append(" and RIGHTID not in (");
            int nValidRightCount = 0;
            for (int nRightIndex = 0; nRightIndex < _pCurrentRightIds.length; ++nRightIndex) {
                if (_pCurrentRightIds[nRightIndex] <= 0) continue;
                if (nValidRightCount > 0) {
                    sbRightIdWhere.append(",");
                }
                sbRightIdWhere.append("?");
                aFilter.addSearchValues(_pCurrentRightIds[nRightIndex]);
                ++nValidRightCount;
            }
            sbRightIdWhere.append(")");
            if (nValidRightCount > 0) {
                sWhere = sWhere + sbRightIdWhere;
            }
        }
        aFilter.setWhere(sWhere);
        this.logger.debug((Object)("delete filter:" + aFilter));
        Rights delRights = Rights.openWCMObjs(_loginUser, aFilter);
        return delRights;
    }

    public void inheritRights(User _loginUser, IRightHost _rightHost, boolean _bDropOldRights) throws WCMException {
        if (_rightHost == null) {
            return;
        }
        IRightHost parent = _rightHost.getParent();
        if (parent == null) {
            return;
        }
        IRightMgr aMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");
        if (_bDropOldRights) {
            aMgr.getRights(_rightHost.getSubstance()).removeAll(true);
        }
        Rights rights = aMgr.getRights(parent.getSubstance());
        int nSize = rights.size();
        for (int i = 0; i < nSize; ++i) {
            Right right = (Right)rights.getAt(i);
            if (right == null) continue;
            Right newRight = (Right)right.cloneToNewObj();
            newRight.setObject(_rightHost.getSubstance());
            newRight.insert(_loginUser);
        }
    }
}

