/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupRole;
import com.trs.cms.auth.persistent.GroupRoles;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class GroupRoleMgr {
    public boolean addGroup(Group _dstGroup, Role _theRole) throws WCMException {
        if (_dstGroup == null || !_dstGroup.isValidInstance()) {
            throw new WCMException("\u8981\u52a0\u5165\u89d2\u8272\u7684\u7ec4\u7ec7\u5bf9\u8c61\u65e0\u6548");
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548"));
        }
        if (_theRole == null || !_theRole.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            GroupRole newGroupRole = this.getGroupRole(_dstGroup, _theRole);
            if (newGroupRole != null) {
                return false;
            }
            newGroupRole = GroupRole.createNewInstance();
            newGroupRole.setRoleId(_theRole.getId());
            newGroupRole.setGroupId(_dstGroup.getId());
            newGroupRole.setCrUser(ContextHelper.getLoginUser());
            newGroupRole.insert(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u89d2\u8272\u65f6\u51fa\u9519!"), ex);
        }
        return true;
    }

    private GroupRole getGroupRole(Group _dstGroup, Role _dstRole) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMGRPROLE", "GroupId=" + _dstGroup.getId() + " AND RoleId=" + _dstRole.getId(), "", "", 1);
        GroupRoles aGroupRoles = GroupRoles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (aGroupRoles.isEmpty()) {
            return null;
        }
        return (GroupRole)aGroupRoles.getAt(0);
    }

    public boolean removeGroup(Group _dstGroup, Role _theRole) throws WCMException {
        if (_dstGroup == null || !_dstGroup.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label5", "\u8981\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7684\u7ec4\u7ec7\u5bf9\u8c61\u65e0\u6548\uff08GroupRoleMgr.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08GroupRoleMgr.removeUser\uff09"));
        }
        if (_theRole == null || !_theRole.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            GroupRole aGroupRole = this.getGroupRole(_dstGroup, _theRole);
            if (aGroupRole == null) {
                return false;
            }
            aGroupRole.delete(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label7", "\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25"), ex);
        }
        return true;
    }

    public Groups getGroups(Role _dstRole, WCMFilter _filter) throws WCMException {
        if (_dstRole == null) {
            throw new WCMException("\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u89d2\u8272\u7684\u6240\u5c5e\u7ec4\u7ec7!");
        }
        String sWhere = "exists(select RoleId FROM WCMGrpRole WHERE WCMGrpRole.GroupId=WCMGroup.GroupId AND RoleId=?)";
        WCMFilter aFilter = new WCMFilter(null, sWhere, null);
        aFilter.addSearchValues(_dstRole.getId());
        aFilter.mergeWith(_filter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Roles getRoles(Group _dstGroup, WCMFilter _filter) throws WCMException {
        if (_dstGroup == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7ec4\u7ec7\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u5c5e\u4e8e\u8be5\u7ec4\u7ec7\u7684\u89d2\u8272!");
        }
        WCMFilter aFilter = new WCMFilter("", "EXISTS(SELECT GroupId FROM WCMGrpRole WHERE WCMGrpRole.RoleId=WCMRole.RoleId AND GroupId=" + _dstGroup.getId() + ")", "", "RoleId");
        aFilter.mergeWith(_filter);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public void setGroups(Role role, Groups groups) throws WCMException {
        Group group;
        int i;
        Groups originalGroups = this.getGroups(role, null);
        int length = groups.size();
        for (i = 0; i < length; ++i) {
            group = (Group)groups.getAt(i);
            if (group == null) continue;
            if (originalGroups.indexOf(group.getId()) >= 0) {
                originalGroups.remove(group.getId(), false);
                continue;
            }
            this.addGroup(group, role);
        }
        length = originalGroups.size();
        for (i = 0; i < length; ++i) {
            group = (Group)originalGroups.getAt(i);
            if (group == null) continue;
            this.removeGroup(group, role);
        }
    }
}

