/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.database.DataType;
import com.trs.wcm.config.PageOperators;
import com.trs.wcm.customize.ICustomizeMgr;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class ExtendFieldServiceProvider
implements IGlueServiceProvider {
    private ContentExtFieldMgr m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    private ICustomizeMgr m_oCustomizeMgr = (ICustomizeMgr)DreamFactory.createObjectById("ICustomizeMgr");

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        boolean bRemoveChildren = _methContext.getValue("ContainsChildren", false);
        String sObjectIds = _methContext.getObjectIds();
        CMSObj host = this.findHost(_methContext);
        this.validateMgrExtFields(loginUser, host, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label1", "\u5220\u9664"));
        ContentExtFields contentExtFields = ContentExtFields.findByIds(loginUser, sObjectIds);
        int nSize = contentExtFields.size();
        for (int i = 0; i < nSize; ++i) {
            ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            host = contentExtField.getHost();
            this.m_oExtFieldMgr.delete(host, contentExtField, bRemoveChildren);
        }
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        boolean bContainsChildren = _methContext.getValue("ContainsChildren", false);
        boolean bValidRight = _methContext.getValue("validRight", true);
        CMSObj host = this.findHost(_methContext);
        if (bValidRight) {
            this.validateMgrExtFields(loginUser, host, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label2", "\u83b7\u53d6"));
        }
        WCMFilter filter = new WCMFilter(_methContext.getQueryFilter());
        return this.m_oExtFieldMgr.getExtFields(host, filter, bContainsChildren);
    }

    @Override
    public int save(MethodContext _methContext) throws Throwable {
        int nExtFieldId;
        User loginUser = this.getLoginUser();
        boolean bContainsChildren = _methContext.getValue("ContainsChildren", false);
        CMSObj host = this.findHost(_methContext);
        this.validateMgrExtFields(loginUser, host, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label3", "\u4fdd\u5b58"));
        if (_methContext.getValue("FieldName") != null && (nExtFieldId = this.findExtfield(_methContext.getValue("FieldName"), "WCMDOCUMENT")) == 0 && !loginUser.isAdministrator()) {
            throw new WCMException("\u975e\u7ba1\u7406\u5458\u7981\u6b62\u521b\u5efa\u7269\u7406\u5b57\u6bb5\uff0c\u53ea\u80fd\u662f\u9009\u62e9\u5df2\u6709\u5b57\u6bb5\uff01");
        }
        ContentExtField contentExtfield = null;
        ExtendedField currExtendedField = null;
        int nObjectId = _methContext.getObjectId();
        String sDbType = _methContext.getValue("DBTYPE");
        String sFieldType = _methContext.getValue("FIELDTYPE");
        if (nObjectId == 0) {
            contentExtfield = ContentExtField.createNewInstance();
            contentExtfield.setTableName("WCMDOCUMENT");
            contentExtfield.setName(_methContext.getValue("FIELDNAME"));
            if ("FLOAT".equalsIgnoreCase(sDbType.trim())) {
                contentExtfield.setType(sDbType, _methContext.getValue("DBLENGTH", -1), true, null, _methContext.getValue("DBSCALE", 0));
            } else {
                contentExtfield.setType(sDbType, _methContext.getValue("DBLENGTH", -1));
            }
            contentExtfield.setAttribute("FIELDTYPE", sFieldType);
            contentExtfield.setExtFieldProperty("FIELDDEFAULT", _methContext.getValue("DEFAULTVALUE"));
            contentExtfield.setAttribute("ENMVALUE", _methContext.getValue("ENMVALUE"));
            if (sDbType.trim().equals("FLOAT")) {
                contentExtfield.setAttribute("DBSCALE", _methContext.getValue("DBSCALE"));
            }
        } else {
            contentExtfield = ContentExtField.findById(nObjectId);
            contentExtfield.validCanEditAndLock(loginUser);
            host = contentExtfield.getHost();
            currExtendedField = ExtendedField.findById(contentExtfield.getExtFieldId());
            currExtendedField.setProperty("FIELDDEFAULT", _methContext.getValue("DEFAULTVALUE"));
            currExtendedField.setProperty("FIELDMAXLEN", _methContext.getValue("DBLENGTH", -1));
            currExtendedField.setAttribute("FIELDTYPE", sFieldType);
            currExtendedField.setAttribute("ENMVALUE", _methContext.getValue("ENMVALUE"));
            if (sDbType != null && sDbType.trim().equals("FLOAT")) {
                currExtendedField.setAttribute("DBSCALE", _methContext.getValue("DBSCALE"));
            }
            currExtendedField.save();
        }
        contentExtfield.setProperty("EXTORDER", _methContext.getValue("EXTORDER", 0));
        contentExtfield.setDesc(_methContext.getValue("FieldDesc"));
        contentExtfield = this.m_oExtFieldMgr.save(host, contentExtfield, bContainsChildren);
        return contentExtfield.getId();
    }

    @Override
    public Object findById(MethodContext _methContext) throws Throwable {
        int nId = _methContext.getObjectId();
        ContentExtField field = ContentExtField.findById(nId);
        if (field == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nId), WCMTypes.getLowerObjName(1319922479)}));
        }
        return field;
    }

    @Override
    public Object findByIds(MethodContext _methContext) throws Throwable {
        return ContentExtFields.findByIds(null, _methContext.getObjectIds());
    }

    public DataType[] getSupportedDataTypes() {
        DataType[] pTypeTemp = DBManager.getDBManager().getDBType().getSupportedDataTypes();
        DataType[] pTypeResult = new DataType[pTypeTemp.length];
        int nIndex = 0;
        for (int i = 0; i < pTypeTemp.length; ++i) {
            if (!this.isValidateDataType(pTypeTemp[i].getType())) continue;
            pTypeResult[nIndex++] = pTypeTemp[i];
        }
        return pTypeResult;
    }

    public PageOperators getOperators(MethodContext _methContext) throws Throwable {
        CMSObj host;
        User loginUser = this.getLoginUser();
        if (!this.canMgrExtFields(loginUser, host = this.findHost(_methContext))) {
            return new PageOperators(null);
        }
        return this.makeExtendOpertators(loginUser, _methContext.getValue("OperatorType"));
    }

    public void impartExtendFields(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        boolean bImpartAll = _methodContext.getValue("ImpartAll", false);
        String sSiteIds = _methodContext.getValue("SiteIds");
        String sChannelIds = _methodContext.getValue("ChannelIds");
        CMSObj host = this.findHost(_methodContext);
        ContentExtFields fields = ContentExtFields.findByIds(null, _methodContext.getObjectIds());
        this.validateMgrExtFields(loginUser, host, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label6", "\u8bbe\u7f6e\u5b50\u5bf9\u5bf9\u8c61\u6743\u9650"));
        int nSize = fields.size();
        for (int i = 0; i < nSize; ++i) {
            ContentExtField contentExtField = (ContentExtField)fields.getAt(i);
            if (contentExtField == null) continue;
            if (bImpartAll) {
                this.m_oExtFieldMgr.addExtFieldToChildren(host, contentExtField);
                continue;
            }
            this.m_oExtFieldMgr.addExtFieldToSpeicficChildren(sSiteIds, sChannelIds, contentExtField);
        }
    }

    public void inheritExtendFields(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        CMSObj host = this.findHost(_methodContext);
        CMSObj parent = this.findParent(host);
        this.validateMgrExtFields(loginUser, parent, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label2", "\u83b7\u53d6"));
        this.validateMgrExtFields(loginUser, host, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label7", "\u8bbe\u7f6e"));
        ContentExtFields fields = this.m_oExtFieldMgr.getExtFields(parent, null, false);
        if (fields != null && fields.size() > 0) {
            int nExtOrder = 0;
            if (host instanceof Channel) {
                nExtOrder = this.getMaxOrder(host);
            }
            for (int i = 0; i < fields.size(); ++i) {
                ContentExtField contentExtField = (ContentExtField)fields.getAt(i);
                if (contentExtField == null) continue;
                this.m_oExtFieldMgr.addExtField(host, contentExtField, nExtOrder + i);
            }
        }
    }

    public void inhertSpecificFromParent(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        CMSObj host = this.findHost(_methodContext);
        this.validateMgrExtFields(loginUser, host, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label7", "\u8bbe\u7f6e"));
        ContentExtFields fields = ContentExtFields.findByIds(loginUser, _methodContext.getValue("SelectedIds"));
        if (fields != null && fields.size() > 0) {
            int nExtOrder = 0;
            if (host instanceof Channel) {
                nExtOrder = this.getMaxOrder(host);
            }
            for (int i = 0; i < fields.size(); ++i) {
                ContentExtField contentExtField = (ContentExtField)fields.getAt(i);
                if (contentExtField == null) continue;
                this.m_oExtFieldMgr.addExtField(host, contentExtField, nExtOrder + i);
            }
        }
    }

    public int getMaxOrder(CMSObj host) throws Throwable {
        DBManager currDBManager = DBManager.getDBManager();
        String sSql = "SELECT MAX(extorder) FROM WCMCONTENTEXTFIELD WHERE objtype=" + host.getWCMType() + " and objid=" + host.getId();
        int nExtOrder = currDBManager.sqlExecuteIntQuery(sSql) + 1;
        return nExtOrder;
    }

    public CMSObj findParent(CMSObj _currObj) throws Throwable {
        switch (_currObj.getWCMType()) {
            case 103: {
                return new WCMSystemObject(_currObj.getId());
            }
            case 101: {
                Channel oChannel = (Channel)_currObj;
                Channel oParent = oChannel.getParent();
                if (oParent != null) {
                    return oParent;
                }
                return oChannel.getSite();
            }
        }
        return null;
    }

    public ExtendedFields queryExtendFields(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        CMSObj host = this.findHost(_methodContext);
        this.validateMgrExtFields(loginUser, host, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label8", "\u83b7\u53d6\u7cfb\u7edf\u73b0\u6709\u7684\u6269\u5c55\u5b57\u6bb5"));
        String sWhere = "not exists(select ExtFieldId from WCMContentExtField where WCMExtField.ExtFieldId=WCMContentExtField.ExtFieldId and ObjType=? and ObjId=?)";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, host.getWCMType());
        filter.addSearchValues(1, host.getId());
        filter.mergeWith(new WCMFilter(_methodContext.getQueryFilter()));
        return ExtendedFields.openWCMObjs(loginUser, filter);
    }

    public String existsSimilarName(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sDBFieldName = _methodContext.getValue("DBFieldName").toUpperCase();
        Report report = new Report(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label9", "\u6269\u5c55\u5b57\u6bb5\u53ef\u4ee5\u6dfb\u52a0"));
        if (DBManager.getDBManager().isKeywords(sDBFieldName)) {
            report.setType(5);
            report.setRportTitle(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label10", "\u8bbe\u7f6e\u7684\u7269\u7406\u5b57\u6bb5[") + sDBFieldName + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label11", "]\u4e3a\u7cfb\u7edf\u4fdd\u7559\u5b57!"));
        } else {
            String sWhere = "ObjType=? and ObjId=? and ContentExtFieldId<>? and EXISTS(    select wcmextfield.EXTFIELDID from wcmextfield    where TableName='WCMDOCUMENT' AND FieldName=?    AND wcmcontentextfield.EXTFIELDID=wcmextfield.EXTFIELDID)";
            WCMFilter existFilter = new WCMFilter("WCMCONTENTEXTFIELD", sWhere, "", "LogicFieldDesc");
            existFilter.addSearchValues(0, _methodContext.getValue("HostType", 0));
            existFilter.addSearchValues(1, _methodContext.getValue("HostId", 0));
            existFilter.addSearchValues(2, _methodContext.getValue("ObjectId", 0));
            existFilter.addSearchValues(3, sDBFieldName);
            ContentExtFields contentExtFields = new ContentExtFields(loginUser);
            contentExtFields.setMaxSize(1);
            contentExtFields.open(existFilter);
            if (!contentExtFields.isEmpty()) {
                ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(0);
                report.setType(5);
                report.setRportTitle(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label12", "\u5b57\u6bb5[") + sDBFieldName + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label13", "]\u5728\u5f53\u524d\u5bf9\u8c61\u4e2d\u5df2\u7ecf\u5efa\u7acb!\u903b\u8f91\u5b57\u6bb5\u540d\u79f0\u4e3a[") + contentExtField.getDesc() + "]" + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label26", "!"));
            }
        }
        return report.toJSONXML();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private CMSObj findHost(MethodContext _methodContext) throws Throwable {
        int nHostType = _methodContext.getValue("HostType", 0);
        int nHostId = _methodContext.getValue("HostId", 0);
        switch (nHostType) {
            case 103: {
                WebSite currSite = WebSite.findById(nHostId);
                if (currSite == null) {
                    throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label14", "\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + nHostId + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label15", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return currSite;
            }
            case 101: {
                Channel currChannel = Channel.findById(nHostId);
                if (currChannel == null) {
                    throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label16", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + nHostId + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label15", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return currChannel;
            }
            case 605: {
                String SQL_QUERY_CHANNEL_ID = "select DocChannel from WCMDocument where DocId=?";
                int nChannelId = DBManager.getDBManager().sqlExecuteIntQuery("select DocChannel from WCMDocument where DocId=?", new int[]{nHostId});
                Channel docChannel = Channel.findById(nChannelId);
                if (docChannel == null) {
                    throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label17", "\u6307\u5b9a\u7684\u6587\u6863[ID=") + nHostId + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label18", "]\u7684\u6240\u5c5e\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
                }
                return docChannel;
            }
            case 1: {
                return new WCMSystemObject(nHostId);
            }
        }
        throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label19", "\u672a\u77e5\u7c7b\u578b[HostType=") + nHostType + "]");
    }

    private void validateMgrExtFields(User loginUser, CMSObj _currObj, String _sOprDesc) throws Throwable {
        int nRightIndex = 0;
        switch (_currObj.getWCMType()) {
            case 103: {
                nRightIndex = 19;
                break;
            }
            case 101: {
                nRightIndex = 19;
                break;
            }
            case 1: {
                if (loginUser.isAdministrator()) {
                    return;
                }
                throw new WCMException(CMyString.format(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label21", "\u60a8[{0}]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650{1}\u7cfb\u7edf\u7684\u6269\u5c55\u5b57\u6bb5\uff01"), new String[]{loginUser.getName(), _sOprDesc}));
            }
        }
        if (!AuthServer.hasRight(loginUser, _currObj, nRightIndex)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label23", "\u60a8[{0}]\u6ca1\u6709\u6743\u9650{1}{2}\u7684\u6269\u5c55\u5b57\u6bb5"), new String[]{loginUser.getName(), _sOprDesc, _currObj.toString()}));
        }
    }

    private boolean canMgrExtFields(User loginUser, CMSObj _currObj) throws WCMException {
        int nRightIndex = 0;
        switch (_currObj.getWCMType()) {
            case 103: {
                nRightIndex = 19;
                break;
            }
            case 101: {
                nRightIndex = 19;
                break;
            }
            case 1: {
                return loginUser.isAdministrator();
            }
        }
        return AuthServer.hasRight(loginUser, _currObj, nRightIndex);
    }

    private PageOperators makeExtendOpertators(User _loginUser, String _sOperterType) throws WCMException {
        return this.m_oCustomizeMgr.getPageOpertators(_loginUser, _sOperterType, new WCMFilter("", "", "", "RightIndex, OprName, OprDesc, OprType, OprKey, ISDISPLAY"));
    }

    private boolean isValidateDataType(int _nDataType) {
        switch (_nDataType) {
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private int findExtfield(String _sFieldName, String _sTableName) throws WCMException {
        String sWhere = "FieldName=? AND TableName=?";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(_sFieldName);
        aFilter.addSearchValues(_sTableName);
        aFilter.setMaxRowNumber(1);
        ExtendedFields fields = new ExtendedFields(null);
        fields.open(aFilter);
        if (fields.isEmpty()) {
            return 0;
        }
        return fields.getIdAt(0);
    }
}

