/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.servlet;

import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.v2.IServletAppActorV2;
import com.trs.idm.interact.agent.AgentFactory;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.JMSConsumerProvider;
import com.trs.idm.util.JSONUtil;
import com.trs.idm.util.StringHelper;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;

public class JMSConsumerServlet
extends HttpServlet {
    private IAgent agent;
    private static final long serialVersionUID = 1L;
    Connection connection = null;
    Destination replyDes = null;
    Session replySession = null;
    private static final Logger logger = Logger.getLogger(JMSConsumerServlet.class);
    private IServletAppActorV2 actor;
    private JMSConsumerProvider jmsConsumerProvider;
    private String jmsReplyOpen;

    public void init() throws ServletException {
        this.agent = AgentFactory.getInstance().initAndStart();
        this.jmsConsumerProvider = new JMSConsumerProvider();
        String jmsOpen = this.agent.getProperty("jms.sync", "false");
        if ("false".equals(jmsOpen)) {
            return;
        }
        String factory = this.agent.getProperty("jms.factory");
        this.jmsReplyOpen = this.agent.getProperty("jms.sync.reply");
        String className = this.agent.getProperty("jms.class", "tongtech.jms.jndi.JmsContextFactory");
        String url = this.agent.getProperty("jms.url");
        String queueName = this.agent.getProperty("jms.queuename");
        String replyName = this.agent.getProperty("jms.replyname");
        this.actor = this.agent.getServletAppActorV2();
        ConnectionFactory connectionFactory = null;
        try {
            Properties pro = new Properties();
            pro.setProperty("java.naming.factory.initial", className);
            pro.setProperty("java.naming.provider.url", url);
            InitialContext initCtx = new InitialContext(pro);
            connectionFactory = (ConnectionFactory)initCtx.lookup(factory);
            this.replyDes = (Destination)initCtx.lookup(replyName);
        }
        catch (NamingException e) {
            logger.error((Object)("failed to find connectionFactory by factoryName [" + factory + "]."), (Throwable)e);
            return;
        }
        try {
            this.connection = connectionFactory.createConnection();
        }
        catch (JMSException e) {
            logger.error((Object)("failed to createConnection from connectionFactory [" + connectionFactory + "]."), (Throwable)e);
            return;
        }
        try {
            this.connection.start();
            this.replySession = this.connection.createSession(true, 1);
            System.out.println("succeed to start connection [" + this.connection + "].");
            logger.debug((Object)("succeed to start connection [" + this.connection + "]."));
        }
        catch (JMSException e) {
            logger.error((Object)("failed to start connection [" + this.connection + "]"), (Throwable)e);
            return;
        }
        MessageConsumer consumer = this.jmsConsumerProvider.createConsumer(factory, className, url, queueName);
        try {
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message m) {
                    boolean result = false;
                    try {
                        System.out.println("Get Message: " + ((TextMessage)m).getText());
                        logger.debug((Object)("Get Message: " + ((TextMessage)m).getText()));
                        String msg = ((TextMessage)m).getText();
                        logger.debug((Object)("begin to execute command from IDS by msg [" + msg + "]."));
                        long beginTime = System.currentTimeMillis();
                        result = this.doCommand(msg);
                        long endTime = System.currentTimeMillis();
                        logger.debug((Object)("succed to execute command from IDS , result is [" + result + "]. cost time :" + (endTime - beginTime)));
                    }
                    catch (JMSException e) {
                        logger.error((Object)("failed to get message by jms, message [" + m + "]"), (Throwable)e);
                    }
                    catch (Throwable t) {
                        logger.error((Object)("failed to get message by jms, message [" + m + "]"), t);
                    }
                    if ("true".equals(JMSConsumerServlet.this.jmsReplyOpen)) {
                        try {
                            logger.debug((Object)("begin to send result[" + result + "] back to IDS."));
                            long beginTime = System.currentTimeMillis();
                            this.sendResult(result);
                            long endTime = System.currentTimeMillis();
                            logger.debug((Object)("succed to send result[" + result + "] back to IDS. cost time :" + (endTime - beginTime)));
                        }
                        catch (Throwable e) {
                            logger.error((Object)("failed to send result [" + result + "] to replyDestination [" + JMSConsumerServlet.this.replyDes + "] by replySession [" + JMSConsumerServlet.this.replySession + "]."), e);
                        }
                    }
                }

                private boolean doCommand(String msg) {
                    String objType = JSONUtil.getValue((String)msg, (String)"ObjType");
                    String command = JSONUtil.getValue((String)msg, (String)"Command");
                    if ("group".equals(objType.toLowerCase())) {
                        String groupStr = JSONUtil.getValue((String)msg, (String)"Group");
                        String groupId = JSONUtil.getValue((String)groupStr, (String)"groupId");
                        Properties groupProps = new Properties();
                        groupProps.put("groupId", groupId);
                        SSOGroup ssoGroup = new SSOGroup(groupProps);
                        if (this.isInsert(command)) {
                            return JMSConsumerServlet.this.actor.addGroup(null, null, ssoGroup);
                        }
                        if (this.isDelete(command)) {
                            return JMSConsumerServlet.this.actor.delGroup(null, null, ssoGroup);
                        }
                        if (this.isUpdate(command)) {
                            return JMSConsumerServlet.this.actor.updateGroup(null, null, ssoGroup);
                        }
                    }
                    String user = JSONUtil.getValue((String)msg, (String)"User");
                    String userName = JSONUtil.getValue((String)user, (String)"userName");
                    Properties properties = new Properties();
                    properties.put("userName", userName);
                    SSOUser ssoUser = new SSOUser(properties);
                    if (this.isInsert(command)) {
                        return JMSConsumerServlet.this.actor.addUser(null, null, ssoUser);
                    }
                    if (this.isDelete(command)) {
                        return JMSConsumerServlet.this.actor.removeUser(null, null, ssoUser);
                    }
                    if (this.isUpdate(command)) {
                        return JMSConsumerServlet.this.actor.updateUser(null, null, ssoUser);
                    }
                    if (this.isDisable(command)) {
                        return JMSConsumerServlet.this.actor.disableUser(null, null, ssoUser);
                    }
                    return JMSConsumerServlet.this.actor.enableUser(null, null, ssoUser);
                }

                private boolean isDisable(String command) {
                    return !StringHelper.isEmpty((String)command) && command.contains("disable");
                }

                private boolean isUpdate(String command) {
                    return !StringHelper.isEmpty((String)command) && command.contains("update");
                }

                private boolean isDelete(String command) {
                    return !StringHelper.isEmpty((String)command) && command.contains("delete");
                }

                private boolean isInsert(String command) {
                    return !StringHelper.isEmpty((String)command) && command.contains("insert");
                }

                private void sendResult(boolean result) throws JMSException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    MessageProducer producer = JMSConsumerServlet.this.replySession.createProducer(JMSConsumerServlet.this.replyDes);
                    producer.setDeliveryMode(2);
                    map.put("SynchronizeID", "abc");
                    map.put("TargetCoApp", "3333");
                    map.put("Result", String.valueOf(result));
                    map.put("ErrorMsg", "No such user and group");
                    String returnMsg = JSONUtil.toJSON(map);
                    producer.send((Message)JMSConsumerServlet.this.replySession.createTextMessage());
                    producer.close();
                    logger.debug((Object)("succeed to send message back to IDS. msg :[" + returnMsg + "]"));
                }
            });
        }
        catch (JMSException e) {
            logger.error((Object)("failed to set message listener for consumer [" + consumer + "]"), (Throwable)e);
            return;
        }
    }

    public void destroy() {
        this.connection = null;
        this.replyDes = null;
        logger.debug((Object)"release all the connection to JMS successfully.");
    }
}

