/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.model.usersource;

import com.trs.idm.data.bo.User;
import com.trs.idm.model.usersource.UserSourceConst;
import com.trs.idm.util.StringHelper;

public class UserCreator {
    public static String createUserNameBaseSource(String userName, String sourceName) {
        if (UserCreator.isInternalSource(sourceName)) {
            return userName;
        }
        if (!StringHelper.isEmpty(userName)) {
            String originalSourceNameToken = String.valueOf(sourceName) + UserSourceConst.SOURCE_USER_DELIM;
            String sourceNameToLowerCaseToken = String.valueOf(sourceName.toLowerCase()) + UserSourceConst.SOURCE_USER_DELIM;
            String sourceNameToUpperCaseToken = String.valueOf(sourceName.toUpperCase()) + UserSourceConst.SOURCE_USER_DELIM;
            if (userName.indexOf(originalSourceNameToken) < 0 && userName.indexOf(sourceNameToLowerCaseToken) < 0 && userName.indexOf(sourceNameToUpperCaseToken) < 0) {
                return String.valueOf(sourceName) + UserSourceConst.SOURCE_USER_DELIM + userName;
            }
        }
        return userName;
    }

    public static User createNewAdminUser() {
        User user = new User();
        user.setUserName("admin");
        user.setNickName("admin");
        user.setActived(true);
        return user;
    }

    public static boolean isEmptySourceName(String sourceName) {
        return StringHelper.isEmpty(sourceName) || "null".equalsIgnoreCase(sourceName);
    }

    public static boolean isInternalSource(String sourceName) {
        return StringHelper.isEmpty(sourceName) || "ids_internal".equals(sourceName) || "null".equals(sourceName);
    }

    public static boolean hasUserSourceName(String userName) {
        if (StringHelper.isEmpty(userName)) {
            return false;
        }
        int position = userName.indexOf(UserSourceConst.SOURCE_USER_DELIM);
        return position > 0;
    }

    public static String getSourceName(String userName) {
        if (StringHelper.isEmpty(userName)) {
            return "";
        }
        int position = userName.indexOf(UserSourceConst.SOURCE_USER_DELIM);
        if (position <= 0) {
            return "ids_internal";
        }
        return userName.substring(0, position);
    }

    public static String getSourceName(User user) {
        String sourceName = user.getSourceName();
        if (StringHelper.isEmpty(sourceName)) {
            sourceName = "ids_internal";
        }
        return sourceName;
    }

    public static String getActualUserName(String userName) {
        if (StringHelper.isEmpty(userName)) {
            return null;
        }
        int position = userName.indexOf(UserSourceConst.SOURCE_USER_DELIM);
        if (position <= 0) {
            return userName;
        }
        if (position + UserSourceConst.SOURCE_USER_DELIM.length() == userName.length()) {
            return userName;
        }
        return userName.substring(position + UserSourceConst.SOURCE_USER_DELIM.length(), userName.length());
    }

    public static String getUserPrincipalName(String userName, String baseDN) {
        String userPrincipalNameSuffix = UserCreator.getUserPrincipalNameSuffix(baseDN);
        if ((userName = UserCreator.getActualUserName(userName)) != null && -1 == userName.indexOf(UserSourceConst.USER_PRINCIPAL_NAME_SUFFIX_BEGIN_TOKEN)) {
            userName = String.valueOf(userName) + userPrincipalNameSuffix;
        }
        return userName;
    }

    public static String getADUserNameWithOutPrincipalNameSuffix(String userName) {
        if (-1 == userName.indexOf(UserSourceConst.USER_PRINCIPAL_NAME_SUFFIX_BEGIN_TOKEN)) {
            return userName;
        }
        return userName.substring(0, userName.indexOf(UserSourceConst.USER_PRINCIPAL_NAME_SUFFIX_BEGIN_TOKEN));
    }

    private static String getUserPrincipalNameSuffix(String baseDN) {
        String[] principalNameSuffixArray = StringHelper.split(baseDN, ",");
        StringBuffer principalNameSuffixBuf = new StringBuffer(1024);
        int i = 0;
        while (i < principalNameSuffixArray.length) {
            int index = principalNameSuffixArray[i].trim().indexOf("=") + 1;
            if (i == principalNameSuffixArray.length - 1) {
                principalNameSuffixBuf.append(principalNameSuffixArray[i].trim().substring(index));
            } else {
                principalNameSuffixBuf.append(String.valueOf(principalNameSuffixArray[i].trim().substring(index)) + ".");
            }
            ++i;
        }
        return String.valueOf(UserSourceConst.USER_PRINCIPAL_NAME_SUFFIX_BEGIN_TOKEN) + principalNameSuffixBuf.toString();
    }
}

