/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent.socket;

import com.trs.idm.interact.agent.ClientTransferProxy;
import com.trs.idm.interact.agent.socket.BaseSocketManager;
import com.trs.idm.interact.agent.socket.SocketHostManager;
import org.apache.log4j.Logger;

public class ErrorSocketManager
extends BaseSocketManager {
    private int maxTriedCount = -1;

    public ErrorSocketManager(SocketHostManager manager) {
        super(manager);
        super.setName("ErrorSocket/1.0");
        this.monitorThread = new Thread(new ErrorSocketBackgroundProcessor(this));
        this.monitorThread.setName("TRSIDSAgent.ErrorSocketBackground." + manager.getAgent().getAgentName());
    }

    public void enter(ClientTransferProxy client) {
        if (!this.clientTransferProxies.contains(client)) {
            super.push(client);
            client.onError();
            this.manager.getHost(client).OnEnterError();
        }
    }

    private boolean isValidClient(ClientTransferProxy client) {
        if (this.maxTriedCount == -1) {
            return true;
        }
        return client.getTriedCount() <= this.maxTriedCount;
    }

    void refresh(ClientTransferProxy client) {
        if (this.isValidClient(client)) {
            client.onTry();
            client.reinit();
        } else {
            this.closeProxy(client);
        }
    }

    private void closeProxy(ClientTransferProxy client) {
        this.manager.getHost(client).onLeaveError();
        this.manager.closeProxy(client);
    }

    public void leave(ClientTransferProxy client) {
        super.remove(client);
        this.manager.getHost(client).onLeaveError();
    }

    public int getMaxTriedCount() {
        return this.maxTriedCount;
    }

    public void setMaxTriedCount(int maxErrorCount) {
        this.maxTriedCount = maxErrorCount;
    }

    class ErrorSocketBackgroundProcessor
    implements Runnable {
        private final Logger LOG = Logger.getLogger(ErrorSocketBackgroundProcessor.class);
        static final int RETRY_INTERVAL = 30000;
        private ErrorSocketManager errorSocketManager;

        public ErrorSocketBackgroundProcessor(ErrorSocketManager errorSocketManager2) {
            this.errorSocketManager = errorSocketManager2;
        }

        @Override
        public void run() {
            this.LOG.info((Object)"ErrorQueueBackgroundProcessor started..");
            while (!this.errorSocketManager.getClientTransferManager().isThreadDone()) {
                try {
                    ClientTransferProxy[] proxies = this.errorSocketManager.listAllProxies();
                    int errorAmount = proxies.length;
                    if (errorAmount > 0) {
                        this.LOG.info((Object)("find " + errorAmount + " error socket, now re-init."));
                        int i = 0;
                        while (i < errorAmount) {
                            this.errorSocketManager.refresh(proxies[i]);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    this.LOG.error((Object)"---------- ErrorQueueBackgroundProcessor Thread Error------------");
                    this.LOG.error((Object)e);
                    this.LOG.error((Object)"------------------------------------------");
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    this.LOG.info((Object)"ErrorQueueBackgroundProcessor interrupted..");
                }
            }
            this.LOG.info((Object)("ErrorQueueBackgroundProcessor finished. manager.isThreadDone: " + this.errorSocketManager.getClientTransferManager().isThreadDone()));
        }
    }
}

