/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model;

import com.trs.dev4.jdk16.model.ValidationError;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class ValidationErrors {
    private static final Logger logger = Logger.getLogger(ValidationErrors.class);
    public static final ValidationErrors NO_ERRORS = new ValidationErrors();
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    public void error(String field, String errorCode, String defaultMessage) {
        ValidationError error = new ValidationError(field, errorCode, defaultMessage);
        logger.error((Object)("Found validation error:" + defaultMessage + "," + errorCode + "," + field));
        this.errors.add(error);
    }

    public void errorIfEmpty(String field, String value, String errorCode, String defaultMessage) {
        if (StringHelper.isEmpty(value)) {
            ValidationError error = new ValidationError(field, errorCode, defaultMessage);
            logger.error((Object)("Found validation error:" + defaultMessage + "," + errorCode + "," + field));
            this.errors.add(error);
        }
    }

    public void addErrors(ValidationErrors deltaErrors) {
        if (deltaErrors == null || !deltaErrors.hasErrors()) {
            return;
        }
        for (ValidationError error : this.errors) {
            logger.error((Object)("Found validation error:" + error.getDefaultMessage() + "," + error.getErrorCode() + "," + error.getField()));
        }
        this.errors.addAll(deltaErrors.errors);
    }

    public List<ValidationError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public int size() {
        return this.errors.size();
    }

    public ValidationError getError(int index) {
        return this.errors.get(index);
    }

    public boolean hasErrors() {
        return this.size() > 0;
    }

    public String toString() {
        if (this.size() == 0) {
            return "ValidationErrors [No error].";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ValidationErrors [").append(this.size()).append("] errors: ");
        for (ValidationError error : this.errors) {
            builder.append(error.getDefaultMessage()).append("{").append(error.getField()).append("}").append(";");
        }
        builder.append(".");
        return builder.toString();
    }
}

