/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao.hb3;

import com.trs.dev4.jdk16.dao.DBSummary;
import com.trs.dev4.jdk16.dao.DBSummaryUtil;
import com.trs.dev4.jdk16.dao.HQLBuilder;
import com.trs.dev4.jdk16.dao.IAccessor;
import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.dao.hb3.Hb3Util;
import com.trs.dev4.jdk16.dao.hb3.HqlGenerator;
import com.trs.dev4.jdk16.dao.hb3.QueryTimer;
import com.trs.dev4.jdk16.exception.DAOException;
import com.trs.dev4.jdk16.exception.ExceptionUtil;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class GenericBaseDAO<T>
extends HibernateDaoSupport
implements IAccessor<T> {
    private Class<T> classType;
    private static final Logger LOG = Logger.getLogger(GenericBaseDAO.class);

    public GenericBaseDAO(Class<T> classType) {
        this.classType = classType;
    }

    @Override
    public Serializable insert(T object) throws DAOException {
        AssertUtil.notNull(object, "cannot insert null object!");
        Session session = null;
        Transaction tx = null;
        Serializable serialedId = null;
        QueryTimer timer = new QueryTimer(this.classType);
        try {
            session = this.getHibernateSession();
            tx = session.beginTransaction();
            serialedId = session.save(object);
            tx.commit();
            Serializable serializable = serialedId;
            return serializable;
        }
        catch (Exception ex) {
            Hb3Util.rollback(tx);
            LOG.error((Object)("fail when save object: [" + object + "] " + ex.getMessage() + "!"), (Throwable)ex);
            throw new DAOException("fail when save object: [" + object + "]!", ex);
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(object, "insert");
        }
    }

    @Override
    public void delete(T object) throws DAOException {
        if (object == null) {
            throw new DAOException("cannot delete null object!");
        }
        QueryTimer timer = new QueryTimer(this.classType);
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = this.getHibernateSession();
                tx = session.beginTransaction();
                session.delete(object);
                tx.commit();
            }
            catch (Exception e) {
                LOG.warn((Object)("fail! obj=" + object), (Throwable)e);
                Hb3Util.rollback(tx);
                throw new DAOException(e);
            }
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(object, "delete");
        }
    }

    @Override
    public void update(T object) throws DAOException {
        if (object == null) {
            throw new DAOException("cannot update null object!");
        }
        QueryTimer timer = new QueryTimer(this.classType);
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = this.getHibernateSession();
                tx = session.beginTransaction();
                session.saveOrUpdate(object);
                tx.commit();
            }
            catch (Exception ex) {
                Hb3Util.rollback(tx);
                LOG.error((Object)("fail when save object: [" + object + "]!" + ex.getMessage()), (Throwable)ex);
                throw new DAOException("fail when save object: [" + object + "]!", ex);
            }
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(object, "update");
        }
    }

    @Override
    public T getObject(int objectId) throws DAOException {
        QueryTimer timer = new QueryTimer(this.classType);
        try {
            Object object = this.getHibernateTemplate().get(this.classType, (Serializable)new Integer(objectId));
            return (T)object;
        }
        catch (Exception ex) {
            LOG.error((Object)("fail to get object, id: " + objectId), (Throwable)ex);
            throw new DAOException(ex);
        }
        finally {
            timer.stopWatch(objectId);
        }
    }

    @Override
    public List<T> listObjects() throws DAOException {
        QueryTimer timer = new QueryTimer(this.classType);
        try {
            List list = this.getHibernateTemplate().loadAll(this.classType);
            return list;
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new DAOException(ex);
        }
        finally {
            timer.stopWatch();
        }
    }

    @Override
    public List<T> listObjects(String fieldName, Object value) throws DAOException {
        SearchFilter sf = SearchFilter.getNoPagedFilter();
        sf.addEqCondition(fieldName, value);
        return this.listObjects(sf);
    }

    @Override
    public List<T> listObjects(SearchFilter sf) throws DAOException {
        StringBuilder sb = this.buildFromAndWhere(sf);
        sb = this.appendOrderbyClause(sf, sb);
        Session session = null;
        Query query = null;
        QueryTimer timer = new QueryTimer(this.classType);
        try {
            session = this.getHibernateSession();
            query = session.createQuery(sb.toString());
            HqlGenerator.bindParameters(query, sf);
            if (sf.getMaxResults() > 0) {
                query.setMaxResults(sf.getMaxResults());
            }
            List list = query.list();
            return list;
        }
        catch (Exception ex) {
            LOG.error((Object)("query failed: [" + sb + "]"), (Throwable)ex);
            throw new DAOException(ex);
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(sf);
        }
    }

    @Override
    public PagedList<T> pagedAll() throws DAOException {
        return this.pagedObjects(SearchFilter.getDefault());
    }

    @Override
    public PagedList<T> pagedObjects(SearchFilter sf) throws DAOException {
        QueryTimer timer = new QueryTimer(this.classType);
        StringBuilder sb = this.buildFromAndWhere(sf);
        try {
            int total = this.total(sf);
            sb = this.appendOrderbyClause(sf, sb);
            List<T> objects = this.getPageItems(sb.toString(), sf);
            PagedList<T> pagedList = new PagedList<T>(objects, sf.getStartPos() / sf.getMaxResults(), sf.getMaxResults(), total);
            return pagedList;
        }
        catch (DAOException ex) {
            LOG.error((Object)("query failed: [" + sb + "]"), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)("query failed: [" + sb + "]"), (Throwable)ex);
            throw new DAOException(ex);
        }
        finally {
            timer.stopWatch(sf);
        }
    }

    private List<T> getPageItems(String whereExpression, SearchFilter sf) {
        return this._getPageItems(whereExpression, sf);
    }

    private List<?> _getPageItems(String whereExpression, SearchFilter sf) {
        QueryTimer timer = new QueryTimer(this.classType);
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(whereExpression);
            HqlGenerator.bindParameters(query, sf);
            query.setFirstResult(sf.getStartPos());
            if (sf.getMaxResults() > 0) {
                query.setMaxResults(sf.getMaxResults());
            }
            List list = query.list();
            return list;
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(sf);
        }
    }

    private StringBuilder appendOrderbyClause(SearchFilter sf, StringBuilder sb) {
        if (sf.getOrderBy() != null) {
            sb.append(" order by ").append(sf.getOrderBy());
        }
        return sb;
    }

    private StringBuilder buildFromAndWhere(SearchFilter sf) {
        return this.buildFromAndWhere(sf, null);
    }

    private StringBuilder buildFromAndWhere(SearchFilter sf, String selectFields) {
        StringBuilder sb = new StringBuilder(160);
        if (!StringHelper.isEmpty(selectFields)) {
            sb.append("select ").append(selectFields).append(" ");
        }
        sb.append("from ").append(this.classType.getName());
        sb.append(sf.buildWhere());
        return sb;
    }

    static void bindParameters(Query query, List<HQLBuilder.Condition> parameters) {
        int i = 0;
        while (i < parameters.size()) {
            HQLBuilder.Condition condition = parameters.get(i);
            try {
                Object value = condition.getValue();
                if (value.getClass().isArray()) {
                    query.setParameterList(condition.getField(), (Object[])value);
                } else if (Collection.class.isAssignableFrom(value.getClass())) {
                    query.setParameterList(condition.getField(), (Collection)value);
                } else {
                    query.setParameter(condition.getParameterName(), value);
                }
            }
            catch (HibernateException e) {
                LOG.error((Object)("query: " + query + "; condition: " + condition), (Throwable)e);
                throw e;
            }
            ++i;
        }
    }

    private String buildCountSQL(SearchFilter sf) {
        StringBuilder sCountExp = new StringBuilder(256);
        sCountExp.append("select count(*) ");
        sCountExp.append("from ").append(this.classType.getName());
        sCountExp.append(sf.buildWhere());
        return sCountExp.toString();
    }

    @Override
    public int batchInsert(T[] objects) throws DAOException {
        int i = 0;
        while (i < objects.length) {
            try {
                this.getHibernateTemplate().save(objects[i]);
            }
            catch (Exception e) {
                throw new DAOException("fail to save " + objects[i], e);
            }
            ++i;
        }
        return i;
    }

    @Override
    public int batchUpdate(HQLBuilder builder) throws DAOException {
        return this.batchWithBuilder(builder);
    }

    @Override
    public int batchDelete(HQLBuilder builder) throws DAOException {
        return this.batchWithBuilder(builder);
    }

    @Override
    public int delete(SearchFilter searchFilter) {
        int count;
        QueryTimer timer = new QueryTimer(this.classType);
        StringBuilder sb = new StringBuilder("delete ");
        sb.append((CharSequence)this.buildFromAndWhere(searchFilter));
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = this.getHibernateSession();
                Query query = session.createQuery(sb.toString());
                HqlGenerator.bindParameters(query, searchFilter);
                tx = session.beginTransaction();
                count = query.executeUpdate();
                tx.commit();
            }
            catch (Exception ex) {
                Hb3Util.rollback(tx);
                throw new DAOException(ex);
            }
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(searchFilter);
        }
        return count;
    }

    @Override
    public int executeNativeUpdateSQL(String sql) {
        QueryTimer timer = new QueryTimer(this.classType);
        Session session = null;
        Transaction tx = null;
        int result = 0;
        try {
            session = this.getHibernateSession();
            tx = session.beginTransaction();
            result = session.createSQLQuery(sql).executeUpdate();
            tx.commit();
            int n = result;
            return n;
        }
        catch (HibernateException e) {
            tx.rollback();
            throw new DAOException(e);
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(sql);
        }
    }

    private int batchWithBuilder(HQLBuilder builder) {
        int count;
        QueryTimer timer = new QueryTimer(this.classType);
        Session session = null;
        Transaction tx = null;
        String preparedHQL = "";
        try {
            try {
                session = this.getHibernateSession();
                preparedHQL = builder.getPreparedHQL();
                Query query = session.createQuery(preparedHQL);
                GenericBaseDAO.bindParameters(query, builder.getParameterValues());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + query.getQueryString() + "; params: " + Arrays.toString(query.getNamedParameters()) + ", called by " + ExceptionUtil.getMainCaller()));
                }
                tx = session.beginTransaction();
                count = query.executeUpdate();
                tx.commit();
            }
            catch (Exception ex) {
                Hb3Util.rollback(tx);
                throw new DAOException(ex);
            }
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(preparedHQL);
        }
        return count;
    }

    @Override
    public boolean exists(String field, Object value) throws DAOException {
        return this.exists(field, value, -1);
    }

    @Override
    public T findFirst(String field, Object value) throws DAOException {
        List<T> objects = this.listObjects(field, value);
        if (objects.size() == 0) {
            return null;
        }
        return objects.get(0);
    }

    @Override
    public boolean exists(String field, Object value, int excludedId) throws DAOException {
        SearchFilter sf = SearchFilter.getDefault();
        sf.addEqCondition(field, value);
        sf.addNotEqCondition("id", new Integer(excludedId));
        return this.total(sf) != 0;
    }

    @Override
    public int total() throws DAOException {
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query countQry = session.createQuery("select count(*) from " + this.classType.getName());
            int n = Hb3Util.uniqueResultAsInt(countQry);
            return n;
        }
        finally {
            this.releaseHibernateSession(session);
        }
    }

    @Override
    public int total(SearchFilter sf) {
        Session session = this.getHibernateSession();
        try {
            String countHQL = this.buildCountSQL(sf);
            Query countQry = session.createQuery(countHQL);
            HqlGenerator.bindParameters(countQry, sf);
            int n = Hb3Util.uniqueResultAsInt(countQry);
            return n;
        }
        finally {
            this.releaseHibernateSession(session);
        }
    }

    @Override
    public int deltaUpdate(String field, long delta, int whichId) {
        if (delta == 0L) {
            return 0;
        }
        String deltaExpression = delta > 0L ? String.valueOf(field) + "+" + delta : String.valueOf(field) + delta;
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(this.getTableName()).append(" set ").append(field).append("=").append(deltaExpression);
        sb.append(" where ").append(this.getIdFieldName()).append("=").append(whichId);
        return this.executeNativeUpdateSQL(sb.toString());
    }

    @Override
    public List<? extends Object> executeQuery(String hql) throws DAOException {
        QueryTimer timer = new QueryTimer(this.classType);
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(hql);
            List list = query.list();
            return list;
        }
        catch (Exception ex) {
            throw new DAOException(ex);
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(hql);
        }
    }

    @Override
    public Class<T> getClassType() {
        return this.classType;
    }

    @Override
    public String getTableName() {
        ClassMetadata metadata = this.getHibernateClassMetadata();
        if (metadata instanceof SingleTableEntityPersister) {
            return ((SingleTableEntityPersister)metadata).getTableName();
        }
        throw new DAOException("ClassMetadata of " + this.classType + " is not a SingleTableEntityPersister, it's " + metadata);
    }

    @Override
    public String getIdFieldName() {
        ClassMetadata metadata = this.getHibernateClassMetadata();
        return metadata.getIdentifierPropertyName();
    }

    @Override
    public DBSummary retriveDBSummary() {
        Session session = null;
        try {
            session = this.getHibernateSession();
            Connection conn = session.connection();
            DBSummary dBSummary = DBSummaryUtil.retriveSummary(conn);
            return dBSummary;
        }
        catch (Exception ex) {
            throw new DAOException(ex);
        }
        finally {
            this.releaseHibernateSession(session);
        }
    }

    protected void releaseHibernateSession(Session session) throws HibernateException {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new HibernateException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected Session getHibernateSession() throws HibernateException {
        return this.getSessionFactory().openSession();
    }

    public Map<String, ClassMetadata> getAllEntityClassMetadata() {
        SessionFactory sessionFactory = this.getSessionFactory();
        return Hb3Util.getAllEntityClassMetadata(sessionFactory);
    }

    public IdentifierGenerator getHibernateIdGenerator() {
        SessionFactory sessionFactory = this.getSessionFactory();
        return Hb3Util.getIdGenerator(sessionFactory, this.classType.getName());
    }

    ClassMetadata getHibernateClassMetadata() {
        Map<String, ClassMetadata> maps = this.getAllEntityClassMetadata();
        ClassMetadata metadata = maps.get(this.classType.getName());
        AssertUtil.notNull(metadata, "ClassMetadata of " + this.classType + " not exist.");
        return metadata;
    }

    EntityMetamodel getHibernateEntityMetamodel() {
        ClassMetadata metadata = this.getHibernateClassMetadata();
        if (!(metadata instanceof AbstractEntityPersister)) {
            throw new DAOException("not a AbstractEntityPersister!");
        }
        AbstractEntityPersister persister = (AbstractEntityPersister)metadata;
        return persister.getEntityMetamodel();
    }

    @Override
    public int executeNativeUpdateSQL(String[] statements) {
        Session session = null;
        Transaction tx = null;
        int result = 0;
        try {
            session = this.getHibernateSession();
            tx = session.beginTransaction();
            int i = 0;
            while (i < statements.length) {
                result += session.createSQLQuery(statements[i]).executeUpdate();
                ++i;
            }
            tx.commit();
            int n = result;
            return n;
        }
        catch (HibernateException e) {
            tx.rollback();
            throw new DAOException(e);
        }
        finally {
            this.releaseHibernateSession(session);
        }
    }

    public boolean exists(T obj) {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString()).append(" (T=");
        builder.append(this.classType.getName());
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void batchDelete(T[] objects) throws DAOException {
        if (objects == null) {
            throw new DAOException("cannot delete null object!");
        }
        QueryTimer timer = new QueryTimer(this.classType);
        try {
            try {
                this.getHibernateTemplate().deleteAll(Arrays.asList(objects));
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                throw new DAOException(ex);
            }
        }
        finally {
            timer.stopWatch(objects, "delete");
        }
    }

    @Override
    public void batchUpdate(T[] objects) throws DAOException {
        this.batchUpdate(Arrays.asList(objects));
    }

    @Override
    public void batchUpdate(List<T> objects) throws DAOException {
        if (objects == null) {
            throw new DAOException("cannot update null object!");
        }
        QueryTimer timer = new QueryTimer(this.classType);
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = this.getHibernateSession();
                tx = session.beginTransaction();
                for (T entity : objects) {
                    session.save(entity);
                }
                session.flush();
                session.clear();
                tx.commit();
            }
            catch (Exception ex) {
                Hb3Util.rollback(tx);
                LOG.error((Object)("fail to update:" + objects), (Throwable)ex);
                throw new DAOException(ex);
            }
        }
        finally {
            this.releaseHibernateSession(session);
            timer.stopWatch(objects, "batchUpdate");
        }
    }

    @Override
    public void truncate() throws DAOException {
        this.executeNativeUpdateSQL("TRUNCATE TABLE " + this.getTableName());
    }

    @Override
    public T findUnique(SearchFilter sf) {
        PagedList<T> entities;
        if (sf == null) {
            sf = SearchFilter.getDefault();
        }
        if ((entities = this.pagedObjects(sf)).getPageItems().size() > 1) {
            throw new DAOException("not unique " + this.getClassType().getName() + ",sf: " + sf);
        }
        return entities.getPageItems().size() > 0 ? (T)entities.get(0) : null;
    }

    @Override
    public T findFirst(SearchFilter sf) {
        PagedList<T> entities;
        if (sf == null) {
            sf = SearchFilter.getDefault();
        }
        return (entities = this.pagedObjects(sf)).getPageItems().size() > 0 ? (T)entities.get(0) : null;
    }

    @Override
    public PagedList<Integer> pagedObjectIds(SearchFilter sf) throws DAOException {
        QueryTimer timer = new QueryTimer(this.classType);
        StringBuilder sb = this.buildFromAndWhere(sf, "id");
        try {
            int total = this.total(sf);
            sb = this.appendOrderbyClause(sf, sb);
            List<?> objects = this._getPageItems(sb.toString(), sf);
            PagedList<Integer> pagedList = new PagedList<Integer>(objects, sf.getStartPos() / sf.getMaxResults(), sf.getMaxResults(), total);
            return pagedList;
        }
        catch (DAOException ex) {
            LOG.error((Object)("query failed: [" + sb + "]"), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)("query failed: [" + sb + "]"), (Throwable)ex);
            throw new DAOException(ex);
        }
        finally {
            timer.stopWatch(sf);
        }
    }
}

