/*
 * Decompiled with CFR 0.152.
 */
package com.trs.deployer.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.deployer.domain.IDeployerHandler;
import com.trs.deployer.domain.impl.DeployCompletedInfoMgr;
import com.trs.deployer.domain.impl.VersionNumberMgr;
import com.trs.deployer.factory.DeployerHandlerFactory;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeployerController
extends Thread {
    private static Logger logger = Logger.getLogger(DeployerController.class);
    private static Map paramMap = new HashMap();
    private static boolean m_bRunning = false;
    private User m_oLoginUser = null;
    private int m_nType = 0;

    public static DeployerController newInstance(User user) {
        DeployerController deployerController = new DeployerController();
        deployerController.m_oLoginUser = user;
        deployerController.m_nType = 0;
        return deployerController;
    }

    public static DeployerController newInstance(User user, int n) {
        DeployerController deployerController = new DeployerController();
        deployerController.m_oLoginUser = user;
        deployerController.m_nType = n;
        return deployerController;
    }

    public void resetParams() {
        paramMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (m_bRunning) {
            return;
        }
        m_bRunning = true;
        try {
            ContextHelper.initContext((User)this.m_oLoginUser);
            this.setParameter("PROCESSORFINISHEDFLAG", "false");
            int n = 0;
            VersionNumberMgr versionNumberMgr = new VersionNumberMgr();
            try {
                n = versionNumberMgr.getVersionNumBeforeUpgrade();
            }
            catch (CMyException cMyException) {
                logger.error((Object)"\u83b7\u53d6\u7248\u672c\u7f16\u53f7\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)cMyException);
                this.setParameter("PROCESSORINFO", "\u90e8\u7f72\u5931\u8d25\uff0c\u672a\u627e\u5230\u5347\u7ea7\u524d\u7cfb\u7edf\u7684\u7248\u672c\u7f16\u53f7\uff01");
                ContextHelper.clear();
                m_bRunning = false;
                return;
            }
            String[] stringArray = (String[])this.getParameter("EXCUTEORDER");
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            List list = DeployerHandlerFactory.getDeployerHandler(stringArray, n, this.m_nType);
            this.setAllMessage(n, list);
            boolean bl = this.excuteHandlers(n, list);
            if (!bl) {
                return;
            }
            this.setParameter("PROCESSORFINISHEDFLAG", "true");
            this.setParameter("CURRCLASSNAME", "");
            DeployCompletedInfoMgr deployCompletedInfoMgr = new DeployCompletedInfoMgr();
            deployCompletedInfoMgr.recordeCompletedInfo("WCM");
        }
        catch (Exception exception) {
            logger.error((Object)"\u90e8\u7f72\u4ecb\u8d28\u7684\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)exception);
            exception.printStackTrace();
        }
        finally {
            ContextHelper.clear();
            m_bRunning = false;
        }
    }

    public void setParameter(String string, Object object) {
        paramMap.put(string.toUpperCase(), object);
    }

    public Object getParameter(String string) {
        return paramMap.get(string.toUpperCase());
    }

    private void excuteHandler(IDeployerHandler iDeployerHandler) {
        String string = iDeployerHandler.getClass().getName();
        this.setParameter("CURRCLASSNAME", string);
        try {
            iDeployerHandler.execute(paramMap);
        }
        catch (CMyException cMyException) {
            logger.error((Object)(iDeployerHandler.getDesc() + "\u5931\u8d25\uff01"), (Throwable)cMyException);
            String string2 = (String)this.getParameter("PROCESSORINFO");
            String string3 = "";
            string3 = CMyString.isEmpty((String)string2) ? iDeployerHandler.getDesc() + "\u5931\u8d25,\u8bf7\u6839\u636e\u65e5\u5fd7\u6587\u4ef6\u67e5\u770b\u5177\u4f53\u4fe1\u606f\uff01" : string2 + "<br/>" + iDeployerHandler.getDesc() + "\u5931\u8d25,\u8bf7\u6839\u636e\u65e5\u5fd7\u6587\u4ef6\u67e5\u770b\u5177\u4f53\u4fe1\u606f\uff01";
            this.setParameter("PROCESSORINFO", string3);
            return;
        }
    }

    private void setAllMessage(int n, List list) {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            IDeployerHandler iDeployerHandler = (IDeployerHandler)list.get(i);
            String string2 = iDeployerHandler.getClass().getName();
            string = string + "<div class=\"notExecute\" currclassname=\"" + string2 + "\">" + iDeployerHandler.getDesc() + "</div>";
        }
        this.setParameter("ALLMESSAGEINFO", string);
    }

    private boolean excuteHandlers(int n, List list) {
        for (int i = 0; i < list.size(); ++i) {
            IDeployerHandler iDeployerHandler = (IDeployerHandler)list.get(i);
            if (!m_bRunning) {
                return false;
            }
            this.excuteHandler(iDeployerHandler);
        }
        return true;
    }

    public boolean isRunning() {
        return m_bRunning;
    }

    public void stopRunning() {
        this.resetParams();
        m_bRunning = false;
    }
}

