/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.http.rfc1867.impl;

import com.trs.net.http.rfc1867.ProgressMonitor;
import com.trs.net.http.rfc1867.RFC1867Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class RFC1867InputStream
extends InputStream {
    protected static final int MAX_HEADER_LENGTH = 1024;
    protected static final byte FORM_PART_TERMINATOR = 45;
    protected static final byte CR = 13;
    protected static final byte LF = 10;
    protected static final byte[] CRLF = new byte[]{13, 10};
    private ProgressMonitor m_oProgress;
    private String m_sCharSet;
    private InputStream m_isOriginal;
    private boolean m_zNextPart;
    private boolean m_zEndStream;
    private int m_bNextByte;
    private int m_readLength;
    private int m_iBoundaryLength;
    private byte[] m_baLineBuff;
    private byte[] m_baBoundary;
    private byte[] m_parentBoundary;

    public RFC1867InputStream(InputStream input, byte[] boundary, String charSet, ProgressMonitor progress) {
        this.m_sCharSet = charSet != null ? charSet : "GBK";
        this.m_oProgress = progress;
        this.m_bNextByte = -1;
        this.m_zNextPart = false;
        this.m_zEndStream = false;
        this.m_readLength = 0;
        this.m_isOriginal = input;
        this.m_baBoundary = null;
        this.m_baLineBuff = new byte[1024];
        this.m_parentBoundary = null;
        this.pushBoundary(boundary);
    }

    public boolean hasMorePart() {
        if (this.m_zNextPart) {
            return true;
        }
        if (this.m_baBoundary != null) {
            while (true) {
                byte[] buff;
                int iLen;
                if ((iLen = this.readLine(buff = this.m_baLineBuff, 0, 1024)) < 0) {
                    throw new RFC1867Exception("Unexpected EOF");
                }
                if (!this.testNextLine()) continue;
                this.skipCRLF();
                if (iLen >= this.m_iBoundaryLength && this.testBoundary(iLen)) break;
            }
            return this.m_baBoundary != null;
        }
        return false;
    }

    public boolean inMixedPart() {
        return this.m_parentBoundary != null;
    }

    private void popBoundary() {
        this.m_baBoundary = this.m_parentBoundary;
        this.m_parentBoundary = null;
        if (this.m_baBoundary != null) {
            this.m_iBoundaryLength = this.m_baBoundary.length;
        } else {
            this.m_zNextPart = false;
            this.m_iBoundaryLength = 0;
        }
    }

    public void pushBoundary(byte[] boundary) {
        this.m_parentBoundary = this.m_baBoundary;
        this.m_baBoundary = boundary;
        this.m_iBoundaryLength = boundary.length;
    }

    public int read() throws IOException {
        if (this.m_bNextByte != -1) {
            int aNext = this.m_bNextByte;
            this.m_bNextByte = -1;
            return aNext;
        }
        int aByte = this.m_isOriginal.read();
        if (aByte != -1) {
            ++this.m_readLength;
        } else {
            this.m_zEndStream = true;
        }
        return aByte;
    }

    public void readBody(OutputStream os) throws IOException {
        if (this.m_zNextPart) {
            return;
        }
        int thisCRLF = 0;
        int lastCRLF = 0;
        byte[] buff = this.m_baLineBuff;
        while (true) {
            int iLength;
            if ((iLength = this.readLine(buff, 0, 1024)) < 0) {
                throw new RFC1867Exception("Unexpected EOF");
            }
            if (this.m_oProgress != null) {
                this.m_oProgress.progress(this.m_readLength);
            }
            if (this.testNextLine()) {
                thisCRLF = this.readCRLF();
                if (iLength >= this.m_iBoundaryLength && this.testBoundary(iLength)) {
                    break;
                }
            } else {
                thisCRLF = 0;
            }
            if (lastCRLF > 0) {
                os.write(13);
                if (lastCRLF == 2) {
                    os.write(10);
                }
            }
            if (iLength > 0) {
                os.write(buff, 0, iLength);
            }
            lastCRLF = thisCRLF;
        }
    }

    private int readCRLF() throws IOException {
        int aByte = this.read();
        if (aByte == 13) {
            aByte = this.read();
            if (aByte == 10) {
                return 2;
            }
            this.m_bNextByte = aByte;
            return 1;
        }
        this.m_bNextByte = aByte;
        return 0;
    }

    public String readHeader() {
        byte[] buff = this.m_baLineBuff;
        int iLength = this.readLine(buff, 0, 1024);
        if (iLength < 0) {
            throw new RFC1867Exception("Unexpected EOF");
        }
        if (this.testNextLine()) {
            this.skipCRLF();
            if (iLength > 0) {
                try {
                    return new String(buff, 0, iLength, this.m_sCharSet);
                }
                catch (UnsupportedEncodingException uee) {
                    return new String(buff, 0, iLength);
                }
            }
            return null;
        }
        throw new RFC1867Exception("header too long");
    }

    public Hashtable readHeaders() {
        String strLine = null;
        Hashtable<String, String> headers = new Hashtable<String, String>();
        while ((strLine = this.readHeader()) != null) {
            int iIndex = strLine.indexOf(58);
            if (iIndex <= 0) continue;
            String strKey = strLine.substring(0, iIndex).trim();
            String strVal = strLine.substring(iIndex + 1).trim();
            if (strKey.length() <= 0 || strVal.length() <= 0) continue;
            headers.put(strKey, strVal);
        }
        return headers;
    }

    private int readLine(byte[] buff, int iOff, int iLen) {
        if (iLen <= 0) {
            return 0;
        }
        int iCnt = 0;
        int bTmp = 0;
        try {
            while ((bTmp = this.read()) != -1) {
                if (bTmp == 13) {
                    this.m_bNextByte = bTmp;
                } else {
                    buff[iOff++] = (byte)bTmp;
                    if (++iCnt != iLen) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new RFC1867Exception(ioe);
        }
        if (iCnt > 0) {
            this.m_zNextPart = false;
        }
        return iCnt == 0 && bTmp == -1 ? -1 : iCnt;
    }

    private void skipCRLF() {
        try {
            int aByte = this.read();
            if (aByte == 13) {
                aByte = this.read();
                if (aByte != 10) {
                    this.m_bNextByte = aByte;
                }
            } else {
                this.m_bNextByte = aByte;
            }
        }
        catch (IOException ioe) {
            throw new RFC1867Exception(ioe);
        }
    }

    private boolean testBoundary(int iLength1) {
        boolean zEqual = true;
        if (iLength1 >= this.m_iBoundaryLength) {
            byte[] buff1 = this.m_baLineBuff;
            byte[] buff2 = this.m_baBoundary;
            int iLength2 = this.m_iBoundaryLength;
            int i = 0;
            while (zEqual && i < iLength2) {
                if (buff1[i] != buff2[i]) {
                    zEqual = false;
                }
                ++i;
            }
            if (zEqual) {
                this.m_zNextPart = true;
                if (iLength1 == iLength2 + 2 && buff1[iLength1 - 1] == 45 && buff1[iLength1 - 2] == 45) {
                    this.popBoundary();
                }
            }
        }
        return zEqual;
    }

    private boolean testNextLine() {
        return this.m_bNextByte == 13 || this.m_zEndStream;
    }
}

