/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.shell;

import com.trs.net.ftp.protocol.FtpClientPI;
import com.trs.net.ftp.shell.Command;
import com.trs.net.ftp.shell.CommandActive;
import com.trs.net.ftp.shell.CommandAppend;
import com.trs.net.ftp.shell.CommandAscii;
import com.trs.net.ftp.shell.CommandBell;
import com.trs.net.ftp.shell.CommandBinary;
import com.trs.net.ftp.shell.CommandCD;
import com.trs.net.ftp.shell.CommandClose;
import com.trs.net.ftp.shell.CommandDebug;
import com.trs.net.ftp.shell.CommandDelete;
import com.trs.net.ftp.shell.CommandDir;
import com.trs.net.ftp.shell.CommandGet;
import com.trs.net.ftp.shell.CommandGlob;
import com.trs.net.ftp.shell.CommandHash;
import com.trs.net.ftp.shell.CommandHelp;
import com.trs.net.ftp.shell.CommandLCD;
import com.trs.net.ftp.shell.CommandLS;
import com.trs.net.ftp.shell.CommandLiteral;
import com.trs.net.ftp.shell.CommandMKD;
import com.trs.net.ftp.shell.CommandMLS;
import com.trs.net.ftp.shell.CommandMdelete;
import com.trs.net.ftp.shell.CommandMdir;
import com.trs.net.ftp.shell.CommandMget;
import com.trs.net.ftp.shell.CommandMput;
import com.trs.net.ftp.shell.CommandOpen;
import com.trs.net.ftp.shell.CommandPWD;
import com.trs.net.ftp.shell.CommandPassive;
import com.trs.net.ftp.shell.CommandPrompt;
import com.trs.net.ftp.shell.CommandPut;
import com.trs.net.ftp.shell.CommandQuit;
import com.trs.net.ftp.shell.CommandRMD;
import com.trs.net.ftp.shell.CommandRemotehelp;
import com.trs.net.ftp.shell.CommandRename;
import com.trs.net.ftp.shell.CommandRunLocal;
import com.trs.net.ftp.shell.CommandStatus;
import com.trs.net.ftp.shell.CommandTrace;
import com.trs.net.ftp.shell.CommandType;
import com.trs.net.ftp.shell.CommandUser;
import com.trs.net.ftp.shell.CommandVerbose;
import com.trs.net.ftp.shell.PrintListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Cftp {
    static BufferedReader s_oCmdReader;
    static FtpClientPI s_oFtpClient;
    static HashMap s_oValidCmds;
    static File s_oLocaleDir;
    static boolean s_zOutReplys;
    static boolean s_zDebugMode;
    static boolean s_zPromptFlg;

    public static void main(String[] args) {
        Cftp.init();
        Cftp.prepare(args);
        Cftp.execute();
    }

    public static String[] splitArg(String arg) {
        if (arg == null || arg.length() <= 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(arg);
        String[] args = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            args[i] = st.nextToken();
            ++i;
        }
        return args;
    }

    public static String getFileName(String pathname) {
        int index = 0;
        index = pathname.lastIndexOf(47);
        if (index >= 0) {
            pathname = pathname.substring(index + 1);
        }
        if ((index = pathname.lastIndexOf(92)) >= 0) {
            pathname = pathname.substring(index + 1);
        }
        return pathname;
    }

    private static void init() {
        s_zOutReplys = true;
        s_zPromptFlg = true;
        s_zDebugMode = false;
        s_oLocaleDir = new File(System.getProperty("user.dir"));
        s_oFtpClient = new FtpClientPI();
        s_oFtpClient.setActiveMode(true);
        s_oFtpClient.setPassiveMode(true);
        s_oFtpClient.addProtocolListener(new PrintListener());
        s_oCmdReader = new BufferedReader(new InputStreamReader(System.in));
        s_oValidCmds = new HashMap();
        Cftp.registerCommand(new CommandActive());
        Cftp.registerCommand(new CommandAppend());
        Cftp.registerCommand(new CommandAscii());
        Cftp.registerCommand(new CommandBell());
        Cftp.registerCommand(new CommandBinary());
        Cftp.registerCommand(new CommandCD());
        Cftp.registerCommand(new CommandClose());
        Cftp.registerCommand(new CommandDebug());
        Cftp.registerCommand(new CommandDelete());
        Cftp.registerCommand(new CommandDir());
        Cftp.registerCommand(new CommandGet());
        Cftp.registerCommand(new CommandGlob());
        Cftp.registerCommand(new CommandHash());
        Cftp.registerCommand(new CommandHelp());
        Cftp.registerCommand(new CommandLCD());
        Cftp.registerCommand(new CommandLiteral());
        Cftp.registerCommand(new CommandLS());
        Cftp.registerCommand(new CommandMdelete());
        Cftp.registerCommand(new CommandMdir());
        Cftp.registerCommand(new CommandMget());
        Cftp.registerCommand(new CommandMKD());
        Cftp.registerCommand(new CommandMLS());
        Cftp.registerCommand(new CommandMput());
        Cftp.registerCommand(new CommandOpen());
        Cftp.registerCommand(new CommandPassive());
        Cftp.registerCommand(new CommandPrompt());
        Cftp.registerCommand(new CommandPut());
        Cftp.registerCommand(new CommandPWD());
        Cftp.registerCommand(new CommandQuit());
        Cftp.registerCommand(new CommandRemotehelp());
        Cftp.registerCommand(new CommandRename());
        Cftp.registerCommand(new CommandRMD());
        Cftp.registerCommand(new CommandRunLocal());
        Cftp.registerCommand(new CommandStatus());
        Cftp.registerCommand(new CommandTrace());
        Cftp.registerCommand(new CommandType());
        Cftp.registerCommand(new CommandUser());
        Cftp.registerCommand(new CommandVerbose());
    }

    private static void registerCommand(Command cmd) {
        if (cmd != null && s_oValidCmds != null) {
            String[] s = cmd.getAlias();
            int i = 0;
            while (i < s.length) {
                s_oValidCmds.put(s[i], cmd);
                ++i;
            }
        }
    }

    private static void prepare(String[] args) {
        try {
            Command cmd;
            if (args != null && args.length >= 1 && (cmd = (Command)s_oValidCmds.get("open")) != null) {
                cmd.execute(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String readPrompt(String sPrompt) {
        String sLine = null;
        try {
            System.out.print(sPrompt);
            sLine = s_oCmdReader.readLine();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (sLine == null) {
            System.err.println("Unexpected console read failed.");
            System.exit(2);
        }
        return sLine;
    }

    private static String readCommand() {
        return Cftp.readPrompt("ftp>");
    }

    private static void execute() {
        while (true) {
            String sLine;
            if ((sLine = Cftp.readCommand()).length() <= 0) {
                continue;
            }
            if (sLine.startsWith("!")) {
                sLine = "! " + sLine.substring(1);
            }
            Cftp.execCommand(sLine);
        }
    }

    private static void execCommand(String cmd) {
        Command oCommand;
        StringTokenizer st = new StringTokenizer(cmd);
        int iTokenCount = st.countTokens();
        String[] args = null;
        String sKey = st.nextToken().toLowerCase();
        if (iTokenCount > 1) {
            args = new String[iTokenCount - 1];
            int i = 0;
            while (st.hasMoreTokens()) {
                args[i] = st.nextToken();
                ++i;
            }
        }
        if ((oCommand = (Command)s_oValidCmds.get(sKey)) != null) {
            oCommand.exec(args);
        } else {
            System.out.println("Invalid command.");
        }
    }

    private Cftp() {
    }
}

