/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.shell;

import com.trs.infra.cluster.Extension;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.shell.ClusterConsole;
import com.trs.infra.cluster.util.AtomicInteger;
import java.util.Arrays;

class TestExtension
implements Extension {
    private String id;
    static boolean debug = true;
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private long start = 0L;

    public TestExtension(String id) {
        this.id = id;
    }

    public String getExtensionId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callByCluster(Object args, Member caller) {
        if (ClusterConsole.holdExtensionMessage > 0) {
            try {
                Thread.sleep(ClusterConsole.holdExtensionMessage * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("Ext:" + this.getExtensionId() + " call by:" + caller + " with:" + args);
            if (args instanceof Object[]) {
                System.out.println(Arrays.asList((Object[])args));
            }
        } else {
            int count = COUNTER.incrementAndGet();
            if (count == 1) {
                AtomicInteger atomicInteger = COUNTER;
                synchronized (atomicInteger) {
                    this.start = System.currentTimeMillis();
                }
            } else if (count == 100) {
                System.out.println("timeused: " + (System.currentTimeMillis() - this.start));
                COUNTER.set(0);
            }
        }
        return null;
    }
}

