/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    byte[] buffer;
    int length;
    int offset;

    public ByteArrayOutputStream() {
        this(4096);
    }

    public ByteArrayOutputStream(byte[] buf) {
        this.setBuffer(buf);
    }

    public ByteArrayOutputStream(int size) {
        this(new byte[size]);
    }

    public final void close() throws IOException {
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(byte[] buf) {
        if (buf == null) {
            throw new NullPointerException("init buffer is null");
        }
        this.buffer = buf;
        this.offset = 0;
        this.length = buf.length;
    }

    public final void reset() {
        this.offset = 0;
    }

    public final int size() {
        return this.offset;
    }

    public final byte[] toByteArray() {
        byte[] newbuf = new byte[this.offset];
        System.arraycopy(this.buffer, 0, newbuf, 0, this.offset);
        return newbuf;
    }

    public final String toString() {
        return new String(this.buffer, 0, this.offset);
    }

    public final String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.offset, enc);
    }

    public final void write(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException("data buffer is null");
        }
        int off2 = off + len;
        int len2 = buf.length;
        if (off < 0 || off > len2 || len < 0 || off2 > len2 || off2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newlen = this.offset + len;
        if (newlen > this.buffer.length) {
            this.length <<= 1;
            this.length = newlen > this.length ? newlen : this.length;
            byte[] temp = new byte[this.length];
            System.arraycopy(this.buffer, 0, temp, 0, this.offset);
            this.buffer = temp;
        }
        System.arraycopy(buf, off, this.buffer, this.offset, len);
        this.offset = newlen;
    }

    public final void write(int b) {
        if (this.offset >= this.length) {
            this.length <<= 2;
            byte[] temp = new byte[this.length];
            System.arraycopy(this.buffer, 0, temp, 0, this.offset);
            this.buffer = temp;
        }
        this.buffer[this.offset++] = (byte)b;
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.offset);
    }
}

