/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.session.impl;

import com.trs.infra.session.Session;
import com.trs.infra.session.SessionContext;
import com.trs.infra.session.impl.EmptyIterator;
import com.trs.infra.session.impl.HttpSessionFacade;
import com.trs.infra.session.impl.StandardContextBase;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;

public abstract class StandardSessionBase
implements Session {
    private static final Logger s_logger;
    protected static final String[] EMPTY_ARRAY;
    private StandardContextBase sessionContext;
    private HttpSession sessionFacade;
    protected String sessionID;
    protected boolean sessionNew;
    protected int sessionState;
    protected int userLevel;
    protected String userName;
    protected int maxInactiveInterval;
    protected final Map attributes;
    protected long createTime;
    protected String createURI;
    protected String clientAddress;
    protected String clientBrowser;
    protected String routedProxies;
    protected long thisAccessTime;
    private int accessingCount;
    private final Object accessingLock = new Object();
    private String thisAccessURI;
    private long lastAccessTime;
    private String lastAccessURI;
    private int totalAccessCount;
    private long totalAccessCycle;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.session.impl.StandardSessionBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
        EMPTY_ARRAY = new String[0];
    }

    protected StandardSessionBase(StandardContextBase sessionContext) {
        this.sessionContext = sessionContext;
        this.attributes = new Hashtable();
    }

    public final SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public final void setSessionContext(StandardContextBase sessionContext) {
        this.sessionContext = sessionContext;
    }

    public final String getSessionID() {
        return this.sessionID;
    }

    public final void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public HttpSession getHttpSession() {
        if (this.sessionFacade == null) {
            this.sessionFacade = new HttpSessionFacade(this);
        }
        return this.sessionFacade;
    }

    public boolean isNew() {
        return this.sessionNew;
    }

    public void setNew(boolean isNew) {
        this.setNewInternal(isNew);
    }

    protected void setNewInternal(boolean isNew) {
        this.sessionNew = isNew;
    }

    public boolean isValid() {
        return this.sessionState == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExpired() {
        Object object = this.accessingLock;
        synchronized (object) {
            if (this.accessingCount > 0) {
                return false;
            }
        }
        if ((this.sessionState & 2) != 0) {
            return true;
        }
        if (this.maxInactiveInterval < 0) {
            return false;
        }
        long cuttentTime = System.currentTimeMillis();
        long tExpireTime = cuttentTime - (long)this.maxInactiveInterval;
        return this.getThisAccessTime() <= tExpireTime;
    }

    public void setExpired(boolean expired) {
        this.sessionState = expired ? (this.sessionState |= 2) : (this.sessionState &= 0xFFFFFFFD);
    }

    public int getState() {
        return this.sessionState;
    }

    public int getLevel() {
        return this.userLevel;
    }

    public void setLevel(int newLevel) {
        this.setLevelInternal(newLevel);
    }

    protected void setLevelInternal(int newLevel) {
        this.userLevel = newLevel;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.setUserNameInternal(userName);
    }

    protected void setUserNameInternal(String newUserName) {
        String oldUserName = this.userName;
        if (oldUserName == newUserName) {
            return;
        }
        this.userName = newUserName;
        this.sessionContext.changeUserName(this, oldUserName, newUserName);
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval / 1000;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.setMaxInactiveIntervalInternal(maxInactiveInterval);
    }

    protected void setMaxInactiveIntervalInternal(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval * 1000;
    }

    public boolean hasAttribute() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    public String[] getAttributeNamesArray() {
        if (this.attributes == null) {
            return EMPTY_ARRAY;
        }
        return this.attributes.keySet().toArray(EMPTY_ARRAY);
    }

    public Iterator getAttributeNames() {
        if (this.attributes == null) {
            return EmptyIterator.INSTANCE;
        }
        return this.attributes.keySet().iterator();
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.setAttributeInternal(name, value);
    }

    protected void setAttributeInternal(String name, Object value) {
        Object[] commonListeners;
        Class<?> clazz;
        if (name == null) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        if (value == null) {
            this.removeAttributeInternal(name);
            return;
        }
        HttpSessionBindingEvent eventBound = null;
        HttpSessionBindingEvent eventUnbound = null;
        Object oldValue = this.attributes.put(name, value);
        if (value != oldValue) {
            HttpSessionBindingListener listener;
            if (value instanceof HttpSessionBindingListener) {
                eventBound = new HttpSessionBindingEvent(this.getHttpSession(), name, value);
                listener = (HttpSessionBindingListener)value;
                try {
                    listener.valueBound(eventBound);
                }
                catch (Exception e) {
                    s_logger.error((Object)"Error on valueBound", (Throwable)e);
                }
            }
            if (oldValue != null && oldValue instanceof HttpSessionBindingListener) {
                eventUnbound = new HttpSessionBindingEvent(this.getHttpSession(), name, oldValue);
                listener = (HttpSessionBindingListener)oldValue;
                try {
                    listener.valueUnbound(eventUnbound);
                }
                catch (Exception e) {
                    s_logger.error((Object)"Error on valueUnbound", (Throwable)e);
                }
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("javax.servlet.http.HttpSessionAttributeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((commonListeners = this.sessionContext.getListeners(clazz)) == null || commonListeners.length <= 0) {
            return;
        }
        HttpSessionAttributeListener[] attributelisteners = (HttpSessionAttributeListener[])commonListeners;
        if (eventBound == null) {
            eventBound = new HttpSessionBindingEvent(this.getHttpSession(), name, value);
        }
        if (eventUnbound == null) {
            eventUnbound = new HttpSessionBindingEvent(this.getHttpSession(), name, oldValue);
        }
        int length = attributelisteners.length;
        int i = 0;
        while (i < length) {
            HttpSessionAttributeListener listener = attributelisteners[i];
            if (listener != null) {
                if (oldValue == null) {
                    try {
                        listener.attributeAdded(eventBound);
                    }
                    catch (Exception e) {
                        s_logger.error((Object)"Error on attributeAdded", (Throwable)e);
                    }
                } else {
                    try {
                        listener.attributeReplaced(eventUnbound);
                    }
                    catch (Exception e) {
                        s_logger.error((Object)"Error on attributeReplaced", (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    protected void removeAttributeInternal(String name) {
        Object[] commonListeners;
        Class<?> clazz;
        if (name == null) {
            return;
        }
        Object oldValue = this.attributes.remove(name);
        if (oldValue == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (oldValue instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getHttpSession(), name, oldValue);
            HttpSessionBindingListener listener = (HttpSessionBindingListener)oldValue;
            try {
                listener.valueUnbound(event);
            }
            catch (Exception e) {
                s_logger.error((Object)"Error on valueUnbound", (Throwable)e);
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("javax.servlet.http.HttpSessionAttributeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((commonListeners = this.sessionContext.getListeners(clazz)) == null || commonListeners.length <= 0) {
            return;
        }
        HttpSessionAttributeListener[] attributelisteners = (HttpSessionAttributeListener[])commonListeners;
        if (event == null) {
            event = new HttpSessionBindingEvent(this.getHttpSession(), name, oldValue);
        }
        int length = attributelisteners.length;
        int i = 0;
        while (i < length) {
            HttpSessionAttributeListener listener = attributelisteners[i];
            if (listener != null) {
                try {
                    listener.attributeRemoved(event);
                }
                catch (Exception e) {
                    s_logger.error((Object)"Error on attributeRemoved", (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void clearAttributeInternal() {
        if (this.attributes != null && this.attributes.size() > 0) {
            String[] names = this.getAttributeNamesArray();
            int length = names != null ? names.length : 0;
            int i = 0;
            while (i < length) {
                this.removeAttributeInternal(names[i]);
                ++i;
            }
        }
    }

    public final long getCreateTime() {
        return this.createTime;
    }

    public final void setCreateTime(long createTime) {
        this.thisAccessTime = this.createTime = createTime;
    }

    public final String getCreateURI() {
        return this.createURI;
    }

    public final void setCreateURI(String accessURI, String queryString) {
        if (queryString != null) {
            accessURI = String.valueOf(accessURI) + '?' + queryString;
        }
        this.createURI = accessURI;
    }

    public final String getClientAddress() {
        return this.clientAddress;
    }

    public final void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public final String getClientBrowser() {
        return this.clientBrowser;
    }

    public final void setClientBrowser(String clientBrowser) {
        this.clientBrowser = clientBrowser;
    }

    public final String getRoutedProxies() {
        return this.routedProxies;
    }

    public final void setRoutedProxies(String routedProxies) {
        this.routedProxies = routedProxies;
    }

    public final long getThisAccessTime() {
        return this.thisAccessTime;
    }

    public final void setThisAccessTime(long thisAccessTime) {
        this.thisAccessTime = thisAccessTime;
    }

    public final String getThisAccessURI() {
        return this.thisAccessURI;
    }

    public final void setThisAccessURI(String thisAccessURI) {
        this.thisAccessURI = thisAccessURI;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final String getLastAccessURI() {
        return this.lastAccessURI;
    }

    public final int getTotalAccessCount() {
        return this.totalAccessCount;
    }

    public final long getTotalAccessCycle() {
        return this.totalAccessCycle;
    }

    public final long getTotalAccessSpend() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessStart() {
        Object object = this.accessingLock;
        synchronized (object) {
            ++this.accessingCount;
        }
        long tCurrentTime = System.currentTimeMillis();
        ++this.totalAccessCount;
        this.totalAccessCycle += tCurrentTime - this.thisAccessTime;
        this.lastAccessTime = this.thisAccessTime;
        this.thisAccessTime = tCurrentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessEnd() {
        Object object = this.accessingLock;
        synchronized (object) {
            --this.accessingCount;
        }
        this.sessionNew = false;
    }

    public boolean isDestroyed() {
        return (this.sessionState & 8) != 0;
    }

    public void setDestroyed(boolean destroyed) {
        this.sessionState = destroyed ? (this.sessionState |= 8) : (this.sessionState &= 0xFFFFFFF7);
    }

    public void destroy() {
        int flag = 7;
        if ((this.sessionState & flag) == 0) {
            this.invalidateInternal0(4);
        }
        this.sessionState |= 8;
    }

    public void expire() {
        this.expireInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireInternal() {
        Object object = this.accessingLock;
        synchronized (object) {
            if (this.accessingCount > 0) {
                return;
            }
        }
        this.invalidateInternal0(2);
    }

    public boolean isInvalidated() {
        return (this.sessionState & 4) != 0;
    }

    public void invalidate() {
        this.invalidateInternal();
    }

    protected synchronized void invalidateInternal() {
        this.invalidateInternal0(4);
    }

    private synchronized void invalidateInternal0(int plusFlag) {
        int flag = 7;
        if ((this.sessionState & flag) != 0) {
            return;
        }
        this.sessionState |= 1;
        this.sessionContext.fireSessionDestroyed(this);
        this.clearAttributeInternal();
        this.sessionState ^= 1;
        this.sessionState |= plusFlag;
    }
}

