/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl;

import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.cluster.impl.ClusterContextImpl;

public abstract class ClusterTaskBase
implements Runnable {
    private String name;
    private Thread thread;
    private ClusterContextImpl context;
    private volatile boolean zContinue = true;

    public ClusterTaskBase(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final ClusterContextImpl getContext() {
        return this.context;
    }

    public final void setContext(ClusterContextImpl context) {
        this.context = context;
    }

    public final ClusterConfig getConfig() {
        return this.getContext().getConfig();
    }

    public final boolean isContinue() {
        return this.zContinue;
    }

    protected void startThread() {
        this.zContinue = true;
        if (this.thread != null) {
            throw new IllegalStateException("ClusterTaskBase is running" + this);
        }
        this.thread = new Thread((Runnable)this, this.name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void stopThread() {
        this.zContinue = false;
        if (this.thread == null) {
            throw new IllegalStateException("ClusterTaskBase not running" + this);
        }
        this.thread.interrupt();
    }

    protected void suicide() {
        this.zContinue = false;
    }

    protected abstract void startup();

    protected abstract void cleanup();
}

