/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster;

import com.trs.infra.cluster.InnerState;
import com.trs.infra.cluster.Streamable;
import java.net.InetAddress;

public interface Member
extends Streamable {
    public String getName();

    public String getHost();

    public InetAddress getTCPAddress();

    public int getTCPPort();

    public InetAddress getUDPAddress();

    public int getUDPPort();

    public State getState();

    public boolean isValid();

    public boolean isLocal();

    public boolean isMaster();

    public long getStartTime();

    public long getPulseTime();

    public long getMaxMemory();

    public long getFreeMemory();

    public long getTotalMemory();

    public long getTimeDifference();

    public long currentTimeMillis();

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public static final class State
    extends InnerState {
        private static final int INT_NORMAL = 1;
        private static final int INT_LEFT = 2;
        private static final int INT_FAILED = 3;
        private static final int INT_SUSPECT = 4;
        private static final int INT_SYN_REQ = 5;
        private static final int INT_SYN_SEND = 6;
        private static final int INT_SYN_RECV = 7;
        public static final State NORMAL = new State(1, "NORMAL");
        public static final State LEFT = new State(2, "LEFT");
        public static final State FAILED = new State(3, "FAILED");
        public static final State SUSPECT = new State(4, "SUSPECT");
        public static final State SYN_REQ = new State(5, "SYN_REQ");
        public static final State SYN_SEND = new State(6, "SYN_SEND");
        public static final State SYN_RECV = new State(7, "SYN_RECV");

        public static final State valueOf(int id) {
            switch (id) {
                case 1: {
                    return NORMAL;
                }
                case 2: {
                    return LEFT;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return SUSPECT;
                }
                case 5: {
                    return SYN_REQ;
                }
                case 6: {
                    return SYN_SEND;
                }
                case 7: {
                    return SYN_RECV;
                }
            }
            throw new IllegalArgumentException();
        }

        private State(int id, String name) {
            super(id, name);
        }
    }
}

