/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArraySerializer
implements Serializer,
Deserializer {
    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        nsStack.pushScope();
        String lengthStr = src != null ? Array.getLength(src) + "" : "";
        Class<?> componentType = javaType.getComponentType();
        QName elementType = xjmr.queryElementType(componentType, "http://schemas.xmlsoap.org/soap/encoding/");
        if (src == null) {
            SoapEncUtils.generateNullArray(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx, elementType, lengthStr);
        } else {
            SoapEncUtils.generateArrayHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx, elementType, lengthStr);
            sink.write("\n");
            int length = Array.getLength(src);
            for (int i = 0; i < length; ++i) {
                nsStack.pushScope();
                Object value = Array.get(src, i);
                if (value == null) {
                    SoapEncUtils.generateNullStructure(inScopeEncStyle, componentType, "item", sink, nsStack, xjmr, ctx);
                } else {
                    Class<?> actualComponentType = value.getClass();
                    xjmr.marshall("http://schemas.xmlsoap.org/soap/encoding/", actualComponentType, value, "item", sink, nsStack, ctx);
                }
                sink.write("\n");
                nsStack.popScope();
            }
            sink.write("</" + context + '>');
        }
        nsStack.popScope();
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        String name = root.getTagName();
        QName arrayItemType = new QName("", "");
        Object array = ArraySerializer.getNewArray(inScopeEncStyle, root, arrayItemType, xjmr);
        if (SoapEncUtils.isNull(root)) {
            return new Bean(array.getClass(), null);
        }
        Element tempEl = DOMUtils.getFirstChildElement(root);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            QName declItemType;
            QName actualItemType;
            String declEncStyle = DOMUtils.getAttributeNS(tempEl, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
            String actualEncStyle = declEncStyle != null ? declEncStyle : inScopeEncStyle;
            String href = tempEl.getAttribute("href");
            Element actualEl = tempEl;
            if (href != null && !href.equals("") && href.charAt(0) == '#') {
                href = href.substring(1);
                actualEl = DOMUtils.getElementByID(src.getOwnerDocument().getDocumentElement(), href);
                if (actualEl == null) {
                    throw new IllegalArgumentException("No such ID '" + href + "'");
                }
            }
            QName qName = actualItemType = (declItemType = SoapEncUtils.getTypeQName(actualEl)) != null ? declItemType : arrayItemType;
            if (!SoapEncUtils.isNull(actualEl)) {
                Bean itemBean = xjmr.unmarshall(actualEncStyle, actualItemType, actualEl, ctx);
                Array.set(array, i, itemBean.value);
            } else {
                Class javaType = xjmr.queryJavaType(actualItemType, actualEncStyle);
                if (javaType.isPrimitive()) {
                    throw new IllegalArgumentException("Cannot set null value for array element of primitive type: " + javaType.getName());
                }
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return new Bean(array.getClass(), array);
    }

    public static Object getNewArray(String inScopeEncStyle, Element arrayEl, QName arrayItemType, XMLJavaMappingRegistry xjmr) throws IllegalArgumentException {
        QName arrayTypeValue = SoapEncUtils.getAttributeValue(arrayEl, "http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "array", true);
        String arrayTypeValueNamespaceURI = arrayTypeValue.getNamespaceURI();
        String arrayTypeValueLocalPart = arrayTypeValue.getLocalPart();
        int leftBracketIndex = arrayTypeValueLocalPart.lastIndexOf(91);
        int rightBracketIndex = arrayTypeValueLocalPart.lastIndexOf(93);
        if (leftBracketIndex == -1 || rightBracketIndex == -1 || rightBracketIndex < leftBracketIndex) {
            throw new IllegalArgumentException("Malformed arrayTypeValue '" + arrayTypeValue + "'.");
        }
        String componentTypeName = arrayTypeValueLocalPart.substring(0, leftBracketIndex);
        if (componentTypeName.endsWith("]")) {
            throw new IllegalArgumentException("Arrays of arrays are not supported '" + arrayTypeValue + "'.");
        }
        arrayItemType.setNamespaceURI(arrayTypeValueNamespaceURI);
        arrayItemType.setLocalPart(componentTypeName);
        int length = DOMUtils.countKids(arrayEl, (short)1);
        String lengthStr = arrayTypeValueLocalPart.substring(leftBracketIndex + 1, rightBracketIndex);
        if (lengthStr.length() > 0) {
            if (lengthStr.indexOf(44) != -1) {
                throw new IllegalArgumentException("Multi-dimensional arrays are not supported '" + lengthStr + "'.");
            }
            try {
                int explicitLength = Integer.parseInt(lengthStr);
                if (length != explicitLength) {
                    throw new IllegalArgumentException("Explicit array length is not equal to the number of items '" + explicitLength + " != " + length + "'.");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Explicit array length is not a valid integer '" + lengthStr + "'.");
            }
        }
        Class componentType = xjmr.queryJavaType(arrayItemType, inScopeEncStyle);
        return Array.newInstance(componentType, length);
    }
}

