/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybConnectionProxy;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SybPooledConnection
extends SybConnection
implements PooledConnection {
    private Vector _listeners = new Vector(5);
    private SybConnectionProxy _currentProxy = null;

    protected SybPooledConnection(SybUrlProvider sybUrlProvider, int n) throws SQLException {
        super(sybUrlProvider, null, n);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._listeners.add(connectionEventListener);
    }

    public void close() throws SQLException {
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            this._currentProxy.close();
        }
        this._listeners.clear();
        super.close();
    }

    public Connection getConnection() throws SQLException {
        this.reAssignProxy(this);
        return this._currentProxy;
    }

    protected void notifyListeners(SQLException sQLException) {
        ConnectionEvent connectionEvent = sQLException == null ? new ConnectionEvent(this) : new ConnectionEvent(this, sQLException);
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            if (sQLException != null) {
                connectionEventListener.connectionErrorOccurred(connectionEvent);
                continue;
            }
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    private final void reAssignProxy(SybPooledConnection sybPooledConnection) {
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            try {
                this._currentProxy.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._currentProxy = new SybConnectionProxy(sybPooledConnection);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._listeners.remove(connectionEventListener);
    }
}

