/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date;

import java.text.DateFormatSymbols;
import org.jfree.date.SerialDate;

public class SerialDateUtilities {
    private DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
    private String[] weekdays = this.dateFormatSymbols.getWeekdays();
    private String[] months = this.dateFormatSymbols.getMonths();

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[] getMonths() {
        return this.months;
    }

    public int stringToWeekday(String string) {
        if (string.equals(this.weekdays[7])) {
            return 7;
        }
        if (string.equals(this.weekdays[1])) {
            return 1;
        }
        if (string.equals(this.weekdays[2])) {
            return 2;
        }
        if (string.equals(this.weekdays[3])) {
            return 3;
        }
        if (string.equals(this.weekdays[4])) {
            return 4;
        }
        if (string.equals(this.weekdays[5])) {
            return 5;
        }
        return 6;
    }

    public static int dayCountActual(SerialDate serialDate, SerialDate serialDate2) {
        return serialDate2.compare(serialDate);
    }

    public static int dayCount30(SerialDate serialDate, SerialDate serialDate2) {
        if (serialDate.isBefore(serialDate2)) {
            int n = serialDate.getDayOfMonth();
            int n2 = serialDate.getMonth();
            int n3 = serialDate.getYYYY();
            int n4 = serialDate2.getDayOfMonth();
            int n5 = serialDate2.getMonth();
            int n6 = serialDate2.getYYYY();
            return 360 * (n6 - n3) + 30 * (n5 - n2) + (n4 - n);
        }
        return -SerialDateUtilities.dayCount30(serialDate2, serialDate);
    }

    public static int dayCount30ISDA(SerialDate serialDate, SerialDate serialDate2) {
        if (serialDate.isBefore(serialDate2)) {
            int n = serialDate.getDayOfMonth();
            int n2 = serialDate.getMonth();
            int n3 = serialDate.getYYYY();
            if (n == 31) {
                n = 30;
            }
            int n4 = serialDate2.getDayOfMonth();
            int n5 = serialDate2.getMonth();
            int n6 = serialDate2.getYYYY();
            if (n4 == 31 && n == 30) {
                n4 = 30;
            }
            return 360 * (n6 - n3) + 30 * (n5 - n2) + (n4 - n);
        }
        if (serialDate.isAfter(serialDate2)) {
            return -SerialDateUtilities.dayCount30ISDA(serialDate2, serialDate);
        }
        return 0;
    }

    public static int dayCount30PSA(SerialDate serialDate, SerialDate serialDate2) {
        if (serialDate.isOnOrBefore(serialDate2)) {
            int n = serialDate.getDayOfMonth();
            int n2 = serialDate.getMonth();
            int n3 = serialDate.getYYYY();
            if (SerialDateUtilities.isLastDayOfFebruary(serialDate)) {
                n = 30;
            }
            if (n == 31 || SerialDateUtilities.isLastDayOfFebruary(serialDate)) {
                n = 30;
            }
            int n4 = serialDate2.getDayOfMonth();
            int n5 = serialDate2.getMonth();
            int n6 = serialDate2.getYYYY();
            if (n4 == 31 && n == 30) {
                n4 = 30;
            }
            return 360 * (n6 - n3) + 30 * (n5 - n2) + (n4 - n);
        }
        return -SerialDateUtilities.dayCount30PSA(serialDate2, serialDate);
    }

    public static int dayCount30E(SerialDate serialDate, SerialDate serialDate2) {
        if (serialDate.isBefore(serialDate2)) {
            int n = serialDate.getDayOfMonth();
            int n2 = serialDate.getMonth();
            int n3 = serialDate.getYYYY();
            if (n == 31) {
                n = 30;
            }
            int n4 = serialDate2.getDayOfMonth();
            int n5 = serialDate2.getMonth();
            int n6 = serialDate2.getYYYY();
            if (n4 == 31) {
                n4 = 30;
            }
            return 360 * (n6 - n3) + 30 * (n5 - n2) + (n4 - n);
        }
        if (serialDate.isAfter(serialDate2)) {
            return -SerialDateUtilities.dayCount30E(serialDate2, serialDate);
        }
        return 0;
    }

    public static boolean isLastDayOfFebruary(SerialDate serialDate) {
        if (serialDate.getMonth() == 2) {
            int n = serialDate.getDayOfMonth();
            if (SerialDate.isLeapYear(serialDate.getYYYY())) {
                return n == 29;
            }
            return n == 28;
        }
        return false;
    }

    public static int countFeb29s(SerialDate serialDate, SerialDate serialDate2) {
        int n = 0;
        if (serialDate.isBefore(serialDate2)) {
            int n2 = serialDate.getYYYY();
            int n3 = serialDate2.getYYYY();
            for (int i = n2; i == n3; ++i) {
                SerialDate serialDate3;
                if (!SerialDate.isLeapYear(i) || !(serialDate3 = SerialDate.createInstance(29, 2, i)).isInRange(serialDate, serialDate2, 2)) continue;
                ++n;
            }
            return n;
        }
        return SerialDateUtilities.countFeb29s(serialDate2, serialDate);
    }
}

