/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv.handlers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.Handler;
import org.dbunit.dataset.csv.handlers.NoHandler;
import org.dbunit.dataset.csv.handlers.PipelineComponent;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.csv.handlers.TransparentHandler;

public class Pipeline
implements Handler {
    private LinkedList components;
    private List products;
    private StringBuffer currentProduct;
    private PipelineComponent noHandler;

    public Pipeline() {
        this.setComponents(new LinkedList());
        this.setProducts(new ArrayList());
        this.setNoHandler(NoHandler.IGNORE());
        this.getNoHandler().setSuccessor(null);
        this.getComponents().addFirst(this.getNoHandler());
        this.setCurrentProduct(new StringBuffer());
        this.putFront(TransparentHandler.IGNORE());
    }

    public StringBuffer getCurrentProduct() {
        return this.currentProduct;
    }

    public void setCurrentProduct(StringBuffer currentProduct) {
        this.currentProduct = currentProduct;
    }

    private void prepareNewPiece() {
        this.setCurrentProduct(new StringBuffer());
        try {
            while (!(this.getComponents().getFirst() instanceof TransparentHandler)) {
                this.removeFront();
            }
        }
        catch (PipelineException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void thePieceIsDone() {
        this.getProducts().add(this.getCurrentProduct().toString());
        this.prepareNewPiece();
    }

    public List getProducts() {
        return this.products;
    }

    protected void setProducts(List products) {
        this.products = products;
    }

    private LinkedList getComponents() {
        return this.components;
    }

    private void setComponents(LinkedList components) {
        this.components = components;
    }

    public void putFront(PipelineComponent component) {
        component.setSuccessor((PipelineComponent)this.getComponents().getFirst());
        component.setPipeline(this);
        this.getComponents().addFirst(component);
    }

    public PipelineComponent removeFront() throws PipelineException {
        PipelineComponent first = (PipelineComponent)this.getComponents().getFirst();
        this.remove(first);
        return first;
    }

    public void remove(PipelineComponent component) throws PipelineException {
        if (component == this.getNoHandler()) {
            throw new PipelineException("Cannot remove the last handler");
        }
        if (!this.getComponents().remove(component)) {
            throw new PipelineException("Cannot remove a non existent component from a pipeline");
        }
    }

    public boolean canHandle(char c) throws IllegalInputCharacterException {
        return true;
    }

    public void handle(char c) throws IllegalInputCharacterException, PipelineException {
        ((Handler)this.getComponents().getFirst()).handle(c);
    }

    public boolean allowForNoMoreInput() {
        throw new IllegalStateException("you cannot call Pipeline.allowForNoMoreInput");
    }

    private PipelineComponent getNoHandler() {
        return this.noHandler;
    }

    private void setNoHandler(PipelineComponent noHandler) {
        this.noHandler = noHandler;
    }

    public void resetProducts() {
        this.setProducts(new ArrayList());
    }

    public void noMoreInput() {
        ((Handler)this.getComponents().getFirst()).noMoreInput();
    }
}

