/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.sqlj;

import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.sqlj.DB2SQLJCustomization;
import COM.ibm.db2.sqlj.DB2SQLJErrors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.DefaultLoader;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.TypeInfo;
import sqlj.runtime.profile.util.DataCustomizer;

public class DB2SQLJInstaller
extends DataCustomizer {
    private static final boolean DEBUG = false;
    private static final String DLLName = "db2sqlj";
    private static final String MSDLLName = "db2sjms";
    private static final String RTFuncCall = "call db2jrt(";
    private static final int SQL_PID_LENGTH = 162;
    private Connection m_conn;
    private byte[] pgmID = new byte[162];
    private String program_id;
    private int[] stmt_call_type;
    private int[] section_number;
    private int[] num_sub_stmts;
    private int[] index_subStmtType;
    private int[] subStmtType;
    private int[] index_numHostVars;
    private int[] numHostVars;
    private int[] index_hvarModes;
    private int[] hvarModes;
    private int[] hvarTypes;
    private int[] hvarPrecision;
    private int[] hvarScale;
    private String qualifier;
    private String[] packageSetNames;

    protected native int jsqlGetTotalStmts(ProfileData var1, int var2);

    protected native int jsqlPrep(Connection var1, ProfileData var2, int var3, int var4, int var5, String var6, String var7, byte[] var8, int[] var9, int[] var10, int[] var11, int[] var12, int[] var13, int[] var14, int[] var15, int[] var16, int[] var17);

    protected native String jsqlGetProcName(ProfileData var1, int var2, Integer var3);

    public DB2SQLJInstaller(Connection connection) {
        this.m_conn = connection;
    }

    public Customization customizeProfile(Connection connection, Profile profile, String string, String string2) {
        int n;
        ProfileData profileData;
        int n2 = 0;
        Enumeration enumeration = profile.getCustomizations();
        while (enumeration.hasMoreElements()) {
            profileData = (Customization)enumeration.nextElement();
            if (!(profileData instanceof DB2SQLJCustomization)) continue;
            profile.deregisterCustomization((Customization)profileData);
        }
        profileData = profile.getProfileData();
        int n3 = profileData.size();
        if (n3 > 0) {
            this.stmt_call_type = new int[n3];
            this.section_number = new int[n3];
            this.num_sub_stmts = new int[n3];
            this.index_numHostVars = new int[n3];
            this.index_subStmtType = this.index_numHostVars;
            this.index_hvarModes = new int[n3];
            this.packageSetNames = new String[n3];
        }
        int n4 = 0;
        try {
            n4 = this.jsqlGetTotalStmts(profileData, n3);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            System.exit(-1);
        }
        if (n4 < 0) {
            n2 = n4;
            System.exit(n2);
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            EntryInfo entryInfo = profileData.getEntryInfo(n6);
            n5 += entryInfo.getParamCount();
            ++n6;
        }
        if (n4 > 0) {
            this.numHostVars = new int[n4];
            this.subStmtType = new int[n4];
        }
        if (n5 > 0) {
            this.hvarModes = new int[n5];
            this.hvarTypes = new int[n5];
            this.hvarPrecision = new int[n5];
            this.hvarScale = new int[n5];
        }
        try {
            n2 = this.jsqlPrep(connection, profileData, n3, n4, n5, string, string2, this.pgmID, this.stmt_call_type, this.section_number, this.num_sub_stmts, this.subStmtType, this.numHostVars, this.hvarModes, this.hvarTypes, this.hvarPrecision, this.hvarScale);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            System.exit(-1);
        }
        if (n2 != 0) {
            System.exit(n2);
        }
        this.program_id = "";
        int n7 = 0;
        while (n7 < 162) {
            this.program_id = String.valueOf(this.program_id) + this.pgmID[n7] + ",";
            ++n7;
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            this.index_numHostVars[n9] = n8;
            if (this.num_sub_stmts[n9] > 0) {
                n8 += this.num_sub_stmts[n9];
            }
            ++n9;
        }
        if (this.numHostVars == null) {
            this.numHostVars = new int[n3];
            n = 0;
            while (n < n3) {
                this.numHostVars[n] = 0;
                ++n;
            }
        }
        n8 = 0;
        n = 0;
        while (n < n3) {
            this.index_hvarModes[n] = n8;
            n8 += this.numHostVars[this.index_numHostVars[n]];
            int n10 = 1;
            while (n10 < this.num_sub_stmts[n]) {
                n8 += this.numHostVars[this.index_numHostVars[n] + n10];
                ++n10;
            }
            ++n;
        }
        ProfileData profileData2 = this.customizeData(profile.getProfileData());
        if (profileData2 != profile.getProfileData()) {
            DB2SQLJCustomization dB2SQLJCustomization = new DB2SQLJCustomization(profileData2);
            profile.registerCustomization((Customization)dB2SQLJCustomization);
            return dB2SQLJCustomization;
        }
        return null;
    }

    public String customizeSQLString(ProfileData profileData, EntryInfo entryInfo, int n) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        int n2;
        int n3;
        String string7;
        int n4 = 0;
        String string8 = "#";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = null;
        String string15 = "";
        String string16 = this.packageSetNames[n];
        int n5 = 0;
        int n6 = 0;
        int n7 = entryInfo.getRole();
        int n8 = entryInfo.getParamCount();
        int n9 = this.num_sub_stmts[n];
        if (n7 == 6) {
            string7 = "";
            try {
                string15 = this.m_conn.nativeSQL(entryInfo.getSQLString());
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
                sQLException.printStackTrace();
                System.exit(-1);
            }
            n3 = (Integer)entryInfo.getDescriptor();
            n2 = entryInfo.getParamInfo(n3).getMarkerIndex();
            string6 = string15.substring(0, n2);
            string5 = string15.substring(n2 + 1);
        } else {
            string7 = this.program_id;
            string6 = "";
            string5 = "";
        }
        if (entryInfo.getResultSetType() != 32) {
            string4 = "0,";
        } else {
            n3 = 0;
            String string17 = "";
            string3 = "";
            string2 = "";
            DB2ResultSetMetaData dB2ResultSetMetaData = null;
            try {
                if (this.qualifier != null) {
                    Statement statement = this.m_conn.createStatement();
                    statement.execute("SET CURRENT SQLID='" + this.qualifier + "'");
                    statement.close();
                }
                DB2PreparedStatement dB2PreparedStatement = (DB2PreparedStatement)this.m_conn.prepareStatement(entryInfo.getSQLString());
                dB2ResultSetMetaData = dB2PreparedStatement.getResultSetMetaData();
                n3 = dB2ResultSetMetaData.getColumnCount();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
                sQLException.printStackTrace();
                System.exit(-1);
            }
            string4 = String.valueOf(Integer.toString(n3)) + ",";
            int n10 = 1;
            while (n10 <= n3) {
                try {
                    string17 = dB2ResultSetMetaData.getColumnLabel(n10);
                }
                catch (SQLException sQLException) {
                    System.err.println(sQLException);
                    sQLException.printStackTrace();
                    return entryInfo.getSQLString();
                }
                string3 = String.valueOf(string3) + string17;
                string2 = String.valueOf(string2) + Integer.toString(string17.length()) + ",";
                ++n10;
            }
            string4 = String.valueOf(string4) + string2 + string3 + ",";
        }
        if (n7 == 7) {
            n3 = RTFuncCall.length() + n8 * 2 + 2;
            n2 = n3 + this.program_id.length();
            string3 = "SQLCURJ" + n;
            string = String.valueOf(Integer.toString(string3.length())) + "," + Integer.toString(n3) + "," + Integer.toString(n2) + "," + string3;
        } else {
            string = String.valueOf(0) + ",";
        }
        if (n8 > 0) {
            n6 = this.index_numHostVars[n];
            n3 = 0;
            while (n3 < n9) {
                string12 = String.valueOf(string12) + this.numHostVars[n6 + n3] + ",";
                n5 += this.numHostVars[n6 + n3];
                ++n3;
            }
        }
        if (n8 > 0) {
            String string18 = "";
            if (n7 != 6) {
                n6 = this.index_hvarModes[n];
            }
            n2 = 0;
            while (n2 < n8 - 1) {
                string9 = String.valueOf(string9) + "?,";
                if (n7 != 6) {
                    string10 = String.valueOf(string10) + this.hvarModes[n6 + n2];
                    string11 = String.valueOf(string11) + "," + this.hvarTypes[n6 + n2];
                    if (this.hvarTypes[n6 + n2] == 1 || this.hvarTypes[n6 + n2] == 12 || this.hvarTypes[n6 + n2] == -95 || this.hvarTypes[n6 + n2] == -96 || this.hvarTypes[n6 + n2] == 3 || this.hvarTypes[n6 + n2] == 2) {
                        string3 = "(" + this.hvarPrecision[n6 + n2];
                        if (this.hvarTypes[n6 + n2] == 3 || this.hvarTypes[n6 + n2] == 2) {
                            string3 = String.valueOf(string3) + " " + this.hvarScale[n6 + n2];
                        }
                        string11 = String.valueOf(string11) + string3 + ")";
                    }
                    string18 = this.hvarTypes[n6 + n2] == -95 || this.hvarTypes[n6 + n2] == -96 || this.hvarTypes[n6 + n2] == -97 || this.hvarTypes[n6 + n2] == -350 ? String.valueOf(string18) + "1" : String.valueOf(string18) + "0";
                }
                ++n2;
            }
            if (n7 != 6) {
                string9 = String.valueOf(string9) + "?,";
                int n11 = n8 - 1;
                if (n11 < n5) {
                    string10 = String.valueOf(string10) + this.hvarModes[n6 + n11];
                    string11 = String.valueOf(string11) + "," + this.hvarTypes[n6 + n11];
                    if (this.hvarTypes[n6 + n11] == 1 || this.hvarTypes[n6 + n11] == 12 || this.hvarTypes[n6 + n11] == -95 || this.hvarTypes[n6 + n11] == -96 || this.hvarTypes[n6 + n11] == 3 || this.hvarTypes[n6 + n11] == 2) {
                        string2 = "(" + this.hvarPrecision[n6 + n11];
                        if (this.hvarTypes[n6 + n11] == 3 || this.hvarTypes[n6 + n11] == 2) {
                            string2 = String.valueOf(string2) + " " + this.hvarScale[n6 + n11];
                        }
                        string11 = String.valueOf(string11) + string2 + ")";
                    }
                    string18 = this.hvarTypes[n6 + n11] == -95 || this.hvarTypes[n6 + n11] == -96 || this.hvarTypes[n6 + n11] == -97 || this.hvarTypes[n6 + n11] == -350 ? String.valueOf(string18) + "1" : String.valueOf(string18) + "0";
                }
            } else {
                string9 = String.valueOf(string9) + "'?',";
            }
            string11 = String.valueOf(string18) + string11;
        }
        String string19 = n5 != n8 && n7 != 6 ? "1" : "0";
        n6 = this.index_subStmtType[n];
        int n12 = 0;
        while (n12 < n9) {
            string13 = String.valueOf(string13) + this.subStmtType[n6 + n12];
            ++n12;
        }
        if (n9 == 1 && n7 != 9) {
            n9 = 0;
        }
        if (n7 == 4) {
            Integer n13 = new Integer(0);
            try {
                string16 = string14 = this.jsqlGetProcName(profileData, n, n13);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
                System.exit(-1);
            }
            if (string14 == "") {
                n4 = n13;
                System.exit(n4);
            }
        } else {
            string14 = "";
        }
        if (string16 == null) {
            string16 = "";
        }
        string8 = String.valueOf(string8) + string4 + string + "{" + RTFuncCall + string9 + "'" + string7 + "'," + Integer.toString(this.stmt_call_type[n]) + "," + Integer.toString(this.section_number[n]) + ",'" + string10 + "','" + string11 + "'," + Integer.toString(n9) + "," + string19 + ",'" + string12 + "','" + string13 + "','" + string16 + "','" + string6 + "','" + string5 + "')}";
        return string8;
    }

    public int customizeMarkerIndex(ProfileData profileData, EntryInfo entryInfo, int n, TypeInfo typeInfo, int n2, int n3) {
        int n4;
        int n5 = entryInfo.getRole();
        if (n5 == 6 && n2 == (n4 = ((Integer)entryInfo.getDescriptor()).intValue())) {
            int n6 = entryInfo.getParamCount();
            int n7 = RTFuncCall.length() + (n6 - 1) * 2 + 7;
            return n7;
        }
        return typeInfo.getMarkerIndex();
    }

    public int getWITHBooleanOpts(EntryInfo entryInfo) {
        int n = 2;
        int n2 = 4;
        int n3 = 8;
        int n4 = 16;
        boolean bl = false;
        boolean bl2 = false;
        Field field = null;
        Field field2 = null;
        Class<?> clazz = null;
        String string = entryInfo.getResultSetName();
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            classNotFoundException.printStackTrace();
            System.exit(-1);
        }
        try {
            field = clazz.getField("holdability");
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (field != null) {
            try {
                bl = field.getBoolean(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
                illegalAccessException.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            field2 = clazz.getField("returnability");
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (field2 != null) {
            try {
                bl2 = field2.getBoolean(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
                illegalAccessException.printStackTrace();
                System.exit(-1);
            }
        }
        if (bl) {
            if (bl2) {
                return n4;
            }
            return n2;
        }
        if (bl2) {
            return n3;
        }
        return n;
    }

    public String getUpdateColumns(EntryInfo entryInfo) {
        String string = null;
        Field field = null;
        Class<?> clazz = null;
        String string2 = entryInfo.getResultSetName();
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            classNotFoundException.printStackTrace();
            System.exit(-1);
        }
        try {
            field = clazz.getDeclaredField("updateColumns");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return string;
        }
        try {
            if (field != null) {
                string = (String)field.get(null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            illegalAccessException.printStackTrace();
            System.exit(-1);
        }
        return string;
    }

    public boolean isImplForUpdate(EntryInfo entryInfo) {
        boolean bl = false;
        Class<?> clazz = null;
        String string = entryInfo.getResultSetName();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            classNotFoundException.printStackTrace();
            System.exit(-1);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null && classArray.length > 0) {
            int n = 0;
            while (n < classArray.length) {
                System.out.println(classArray[n].getName());
                if (classArray[n].getName().equals("sqlj.runtime.ForUpdate")) {
                    bl = true;
                    return bl;
                }
                ++n;
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        Object object2;
        Object object3;
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        String string6 = "";
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (stringArray.length < 1) {
            DB2SQLJInstaller.usage();
        }
        n = 0;
        while (n < stringArray.length) {
            stringArray[n].toLowerCase();
            if (!stringArray[n].startsWith("-")) break;
            if (stringArray[n].startsWith("-user=")) {
                string2 = stringArray[n].substring(6);
                if (string2.length() == 0) {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("userName");
                    System.out.println(string9);
                    DB2SQLJInstaller.usage();
                }
            } else if (stringArray[n].startsWith("-user")) {
                string9 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            } else if (stringArray[n].startsWith("-password=")) {
                string3 = stringArray[n].substring(10);
                if (string3.length() == 0) {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("password");
                    System.out.println(string9);
                    DB2SQLJInstaller.usage();
                }
            } else if (stringArray[n].startsWith("-password")) {
                string9 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            } else if (stringArray[n].startsWith("-prepoptions=")) {
                string4 = stringArray[n].substring(13);
                if (string4.length() == 0) {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("prepoptions");
                    System.out.println(string9);
                    DB2SQLJInstaller.usage();
                }
            } else if (stringArray[n].startsWith("-prepoptions")) {
                string9 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            } else if (stringArray[n].startsWith("-url=")) {
                string5 = stringArray[n].substring(5);
                if (string5.length() == 0) {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("url");
                    System.out.println(string9);
                    DB2SQLJInstaller.usage();
                }
            } else if (stringArray[n].startsWith("-url")) {
                string9 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            } else if (stringArray[n].startsWith("-d=")) {
                string6 = stringArray[n].substring(3);
                if (string6.length() == 0) {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("d");
                    System.out.println(string9);
                    DB2SQLJInstaller.usage();
                }
            } else if (stringArray[n].startsWith("-d")) {
                string9 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            } else {
                string9 = DB2SQLJErrors.UNKNOWN_OPTION_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            }
            ++n;
        }
        if (n + 1 < stringArray.length) {
            if (stringArray[n].startsWith("user") || stringArray[n].startsWith("password") || stringArray[n].startsWith("url") || stringArray[n].startsWith("d")) {
                string9 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            } else {
                string9 = DB2SQLJErrors.INVALID_OPTION_text(stringArray[n]);
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            }
        } else {
            if (string5 == null || string5.length() == 0) {
                if (stringArray[n].startsWith("url")) {
                    string9 = DB2SQLJErrors.INVALID_SYNTAX_text(stringArray[n]);
                    System.out.println(string9);
                    DB2SQLJInstaller.usage();
                } else {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("url");
                    System.out.println(string9);
                    DB2SQLJInstaller.usage();
                }
            }
            if (string2 == "" ^ string3 == "") {
                if (string2 == "") {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("userName");
                    System.out.println(string9);
                } else {
                    string9 = DB2SQLJErrors.MISS_OPTION_text("password");
                    System.out.println(string9);
                }
                DB2SQLJInstaller.usage();
            }
            if (n >= stringArray.length) {
                string9 = DB2SQLJErrors.MISS_PROFILE_text();
                System.out.println(string9);
                DB2SQLJInstaller.usage();
            } else if (stringArray[n].endsWith(".ser")) {
                string8 = stringArray[n];
                string7 = stringArray[n].substring(0, stringArray[n].length() - 4);
            } else {
                string7 = stringArray[n];
                string8 = String.valueOf(stringArray[n]) + ".ser";
            }
        }
        try {
            object3 = System.getProperties();
            object2 = ((Properties)object3).propertyNames();
            string = new String();
            while (object2.hasMoreElements() && !string.equalsIgnoreCase("java.vendor")) {
                string = (String)object2.nextElement();
            }
            object = ((Properties)object3).getProperty(string).toLowerCase();
            if (object == null) {
                System.loadLibrary(DLLName);
            } else if (((String)object).indexOf("microsoft") != -1) {
                System.loadLibrary(MSDLLName);
            } else {
                System.loadLibrary(DLLName);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError);
            System.exit(-1);
        }
        Class.forName("COM.ibm.db2.jdbc.app.DB2Driver").newInstance();
        object3 = null;
        try {
            object3 = string2 == "" ? DriverManager.getConnection(string5) : DriverManager.getConnection(string5, string2, string3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
            System.exit(-1);
        }
        object3.setAutoCommit(false);
        object2 = new DB2SQLJInstaller((Connection)object3);
        string9 = DB2SQLJErrors.CUSTOMIZING_text(string7);
        System.out.println("");
        System.out.println(string9);
        System.out.println("");
        try {
            string = Profile.instantiate((Loader)new DefaultLoader(null), (String)string7);
            ((DB2SQLJInstaller)((Object)object2)).customizeProfile((Connection)object3, (Profile)string, string4, string7);
            object = new File(string8);
            String string10 = "";
            if (string6.length() > 0) {
                string10 = String.valueOf(string6) + File.separator;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string10) + string8);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(string);
            objectOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            string9 = DB2SQLJErrors.UNABLE_CUST_PROFILE_text(string7);
            System.out.println(string9);
            System.exit(-1);
            return;
        }
    }

    private static String getOptValue(int n, String string, String[] stringArray) {
        String string2 = null;
        try {
            if (++n >= stringArray.length | stringArray[n].startsWith("-")) {
                string2 = DB2SQLJErrors.MISS_OPTION_text(string);
                System.out.println(string2);
                DB2SQLJInstaller.usage();
                return null;
            }
            return stringArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string2 = DB2SQLJErrors.MISS_OPTION_text(string);
            System.out.println(string2);
            DB2SQLJInstaller.usage();
            return null;
        }
    }

    private static void usage() {
        System.out.println("");
        System.out.println("(c) Copyright IBM Corporation 1998,1999");
        System.out.println("Usage: db2profc [options] -url=JDBC-url profileName[.ser]");
        System.out.println("       options=[-user=userName -password=password][-prepoptions=\"precompilerOptions\"]");
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        String string = new String();
        while (enumeration.hasMoreElements() && !string.equalsIgnoreCase("java.vendor")) {
            string = (String)enumeration.nextElement();
        }
        String string2 = properties.getProperty(string).toLowerCase();
        if (string2 == null) {
            System.out.println("       db2profc = java COM.ibm.db2.sqlj.DB2SQLJInstaller");
        } else if (string2.indexOf("microsoft") != -1) {
            System.out.println("       db2profc = jview COM.ibm.db2.sqlj.DB2SQLJInstaller");
        } else {
            System.out.println("       db2profc = java COM.ibm.db2.sqlj.DB2SQLJInstaller");
        }
        System.out.println("");
        System.exit(1);
    }
}

