/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobWithIO;
import java.io.IOException;
import java.io.InputStream;

class BlobInputStream
extends InputStream {
    private BlobWithIO blob;
    private int pointer;
    private int mark;

    BlobInputStream(BlobWithIO blobWithIO) {
        this.blob = blobWithIO;
        this.pointer = 0;
        this.mark = -1;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n != 1) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        if (n < 0 || n >= byArray.length || n2 <= 0 || n + n2 > byArray.length) {
            throw new IOException("invalid offset/length");
        }
        try {
            int n3 = (int)this.blob.size();
            if (n3 <= this.pointer) {
                return -1;
            }
            int n4 = Math.min(n2, n3 - this.pointer);
            int n5 = this.blob.substr(this.pointer, byArray, n, n4);
            if (n5 < 0) {
                return -1;
            }
            this.pointer += n5;
            return n5;
        }
        catch (Exception exception) {
            throw new IOException("I/O error during Blob read(): " + exception);
        }
    }

    public long skip(long l) throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        try {
            int n = (int)this.blob.size();
            int n2 = (long)this.pointer + l >= (long)n ? n : ((long)this.pointer + l <= 0L ? 0 : this.pointer + (int)l);
            int n3 = n2 - this.pointer;
            this.pointer = n2;
            return n3;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Blob skip(): " + exception);
        }
    }

    public int available() throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        try {
            return (int)this.blob.size() - this.pointer;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Blob available(): " + exception);
        }
    }

    public synchronized void mark(int n) {
        this.mark = this.pointer;
    }

    public synchronized void reset() throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        if (this.mark < 0) {
            this.pointer = 0;
            return;
        }
        this.pointer = this.mark;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() {
        this.blob = null;
    }
}

