/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import org.apache.batik.css.ElementWithID;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.dom.util.HashTableStack;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDocumentFactory
extends DefaultHandler
implements LexicalHandler,
DocumentFactory {
    protected DOMImplementation implementation;
    protected String parserClassName;
    protected Document document;
    protected DocumentDescriptor documentDescriptor;
    protected boolean createDocumentDescriptor;
    protected Node currentNode;
    protected Locator locator;
    protected boolean inCDATA;
    protected boolean inDTD;
    protected boolean isValidating;
    protected boolean documentElementParsed;
    protected HashTableStack namespaces;

    public SAXDocumentFactory(DOMImplementation dOMImplementation, String string) {
        this.implementation = dOMImplementation;
        this.parserClassName = string;
    }

    public SAXDocumentFactory(DOMImplementation dOMImplementation, String string, boolean bl) {
        this.implementation = dOMImplementation;
        this.parserClassName = string;
        this.createDocumentDescriptor = bl;
    }

    public Document createDocument(String string, String string2, String string3) throws IOException {
        return this.createDocument(string, string2, string3, new InputSource(string3));
    }

    public Document createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string3);
        return this.createDocument(string, string2, string3, inputSource);
    }

    public Document createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string3);
        return this.createDocument(string, string2, string3, inputSource);
    }

    protected Document createDocument(String string, String string2, String string3, InputSource inputSource) throws IOException {
        this.document = this.implementation.createDocument(string, string2, null);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(this.parserClassName);
            xMLReader.setContentHandler(this);
            xMLReader.setDTDHandler(this);
            xMLReader.setEntityResolver(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", this.isValidating);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null && exception instanceof InterruptedIOException) {
                throw (InterruptedIOException)exception;
            }
            throw new IOException(sAXException.getMessage());
        }
        return this.document;
    }

    public DocumentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setValidating(boolean bl) {
        this.isValidating = bl;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void startDocument() throws SAXException {
        this.namespaces = new HashTableStack();
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaces.put("", null);
        this.documentElementParsed = false;
        this.inCDATA = false;
        this.inDTD = false;
        this.currentNode = this.document;
        this.documentDescriptor = this.createDocumentDescriptor ? new DocumentDescriptor() : null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        String string4;
        int n;
        Object object2;
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXException(new InterruptedIOException());
        }
        int n2 = attributes.getLength();
        this.namespaces.push();
        int n3 = 0;
        while (n3 < n2) {
            object2 = attributes.getQName(n3);
            if (((String)object2).equals("xmlns")) {
                this.namespaces.put("", attributes.getValue(n3));
            } else if (((String)object2).startsWith("xmlns:")) {
                n = ((String)object2).indexOf(58);
                this.namespaces.put(((String)object2).substring(n + 1), attributes.getValue(n3));
            }
            ++n3;
        }
        n = string3.indexOf(58);
        String string5 = n == -1 || n == string3.length() - 1 ? "" : string3.substring(0, n);
        String string6 = this.namespaces.get(string5);
        if (this.currentNode == this.document) {
            Object object3;
            object2 = this.document.getDocumentElement();
            String string7 = string3;
            if (n != -1 && n != string3.length() - 1) {
                string7 = string3.substring(n + 1);
            }
            if (object2.getNamespaceURI() != null && string5.length() != 0) {
                if (!object2.getLocalName().equals(string7)) {
                    throw new SAXException("Bad root element");
                }
                object2.setPrefix(string5);
            }
            if (string5.equals("")) {
                string4 = "xmlns";
                object3 = object2.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            } else {
                string4 = "xmlns:" + string5;
                object3 = object = object2.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string4);
            }
            if (object != null) {
                this.namespaces.put(string5, object.getValue());
            }
            this.documentElementParsed = true;
        } else {
            object2 = this.document.createElementNS(string6, string3);
            this.currentNode.appendChild((Node)object2);
        }
        this.currentNode = object2;
        if (this.createDocumentDescriptor && this.locator != null) {
            this.documentDescriptor.setLocationLine((Element)object2, this.locator.getLineNumber());
        }
        int n4 = 0;
        while (n4 < n2) {
            string4 = attributes.getQName(n4);
            if (string4.equals("xmlns")) {
                object2.setAttributeNS("http://www.w3.org/2000/xmlns/", string4, attributes.getValue(n4));
            } else {
                n = string4.indexOf(58);
                string6 = n == -1 ? null : this.namespaces.get(string4.substring(0, n));
                object2.setAttributeNS(string6, string4, attributes.getValue(n4));
                if (attributes.getType(n4).equals("ID") && object2 instanceof ElementWithID) {
                    object = n == -1 || n == string4.length() - 1 ? string4 : string4.substring(n + 1);
                    ((ElementWithID)object2).setIDName(string6, (String)object);
                }
            }
            ++n4;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentNode = this.currentNode.getParentNode();
        this.namespaces.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        Text text = this.inCDATA ? this.document.createCDATASection(string) : this.document.createTextNode(string);
        this.currentNode.appendChild(text);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.inDTD) {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
            if (this.currentNode == this.document && !this.documentElementParsed) {
                this.currentNode.insertBefore(processingInstruction, this.document.getDocumentElement());
            } else {
                this.currentNode.appendChild(processingInstruction);
            }
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.inDTD) {
            Comment comment = this.document.createComment(new String(cArray, n, n2));
            if (this.currentNode == this.document && !this.documentElementParsed) {
                this.currentNode.insertBefore(comment, this.document.getDocumentElement());
            } else {
                this.currentNode.appendChild(comment);
            }
        }
    }
}

