/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLJspTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLJspScanner
extends HTMLTagScanner {
    private String language;
    private String type;

    public HTMLJspScanner() {
    }

    public HTMLJspScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        boolean retVal = false;
        if ((s = HTMLTagScanner.absorbLeadingBlanks(s)).indexOf("%") == 0 && s.charAt(s.length() - 1) == '%') {
            retVal = true;
        }
        return retVal;
    }

    public void extractLanguage(HTMLTag tag) {
        this.language = tag.getParameter("LANGUAGE");
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        try {
            HTMLJspTag jspTag;
            String tagContents = tag.getText();
            tagContents = tagContents.substring(1, tagContents.length() - 1);
            HTMLJspTag hTMLJspTag = jspTag = new HTMLJspTag(tag.elementBegin(), tag.elementEnd(), tagContents, currentLine, tag.getLine());
            return hTMLJspTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLJspScanner.scan() : Error while scanning jsp tag, current line = ".concat(String.valueOf(String.valueOf(currentLine))), e);
        }
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String[] getID() {
        String[] ids = new String[]{"%", "%=", "%@"};
        return ids;
    }
}

