/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications;

import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLParser;
import org.htmlparser.HTMLRemarkNode;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLFormTag;
import org.htmlparser.tags.HTMLLinkTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLEnumeration;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.Translate;

public class StringExtractor {
    private static final String newline = System.getProperty("line.separator");
    private static final int newline_size = newline.length();
    private String resource;

    public StringExtractor(String resource) {
        this.resource = resource;
    }

    protected void collapse(StringBuffer buffer, String string) {
        int chars = string.length();
        if (chars != 0) {
            int length = buffer.length();
            int state = length == 0 || buffer.charAt(length - 1) == ' ' || newline_size <= length && buffer.substring(length - newline_size, length).equals(newline) ? 0 : 1;
            block3: for (int i = 0; i < chars; ++i) {
                char character = string.charAt(i);
                switch (character) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u200b': {
                        if (state == 0) continue block3;
                        state = 1;
                        continue block3;
                    }
                    default: {
                        if (1 == state) {
                            buffer.append(' ');
                        }
                        state = 2;
                        buffer.append(character);
                    }
                }
            }
        }
    }

    protected void carriage_return(StringBuffer buffer) {
        int length = buffer.length();
        if (length != 0 && newline_size <= length && !buffer.substring(length - newline_size, length).equals(newline)) {
            buffer.append(newline);
        }
    }

    public String extractStrings(boolean links) throws HTMLParserException {
        HTMLParser parser = new HTMLParser(this.resource);
        parser.registerScanners();
        StringBuffer results = new StringBuffer(4096);
        boolean preformatted = false;
        HTMLEnumeration e = parser.elements();
        while (e.hasMoreNodes()) {
            HTMLNode node = e.nextHTMLNode();
            if (node instanceof HTMLStringNode) {
                HTMLStringNode string = (HTMLStringNode)node;
                if (preformatted) {
                    results.append(string.getText());
                    continue;
                }
                this.collapse(results, Translate.decode(string.getText()));
                continue;
            }
            if (node instanceof HTMLLinkTag) {
                HTMLLinkTag link = (HTMLLinkTag)node;
                if (preformatted) {
                    results.append(link.getLinkText());
                } else {
                    this.collapse(results, Translate.decode(link.getLinkText()));
                }
                if (!links) continue;
                results.append("<");
                results.append(link.getLink());
                results.append(">");
                continue;
            }
            if (node instanceof HTMLFormTag) {
                HTMLFormTag form = (HTMLFormTag)node;
                if (form.breaksFlow()) {
                    this.carriage_return(results);
                }
                if (preformatted) {
                    results.append(form.toPlainTextString());
                    continue;
                }
                this.collapse(results, Translate.decode(form.toPlainTextString()));
                continue;
            }
            if (node instanceof HTMLRemarkNode || !(node instanceof HTMLTag)) continue;
            HTMLTag tag = (HTMLTag)node;
            if (tag.breaksFlow()) {
                this.carriage_return(results);
            }
            if (!tag.getText().toUpperCase().equals("PRE")) continue;
            preformatted = !(tag instanceof HTMLEndTag);
        }
        return results.toString();
    }

    public static void main(String[] args) {
        boolean links = false;
        String url = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-links")) {
                links = true;
                continue;
            }
            url = args[i];
        }
        if (url != null) {
            StringExtractor se = new StringExtractor(url);
            try {
                System.out.println(se.extractStrings(links));
            }
            catch (HTMLParserException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: java -classpath htmlparser.jar org.htmlparser.parserapplications.StringExtractor [-links] url");
        }
    }
}

