/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications;

import java.util.Enumeration;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLParser;
import org.htmlparser.tags.HTMLLinkTag;
import org.htmlparser.util.DefaultHTMLParserFeedback;
import org.htmlparser.util.HTMLEnumeration;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.HTMLParserFeedback;

public class MailRipper {
    private HTMLParser parser;

    public MailRipper(String resourceLocation) {
        try {
            this.parser = new HTMLParser(resourceLocation, (HTMLParserFeedback)new DefaultHTMLParserFeedback());
            this.parser.registerScanners();
        }
        catch (HTMLParserException e) {
            System.err.println("Could not create parser object");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("Mail Ripper v1.2 (Production Release)");
        if (args.length < 1 || args[0].equals("-help")) {
            System.out.println();
            System.out.println("Syntax : java -classpath htmlparser.jar org.htmlparser.parserapplications.MailRipper <resourceLocn/website>");
            System.out.println();
            System.out.println("   <resourceLocn> the name of the file to be parsed (with complete path ");
            System.out.println("                  if not in current directory)");
            System.out.println("   -help This screen");
            System.out.println();
            System.out.println("HTML Parser home page : http://htmlparser.sourceforge.net");
            System.out.println();
            System.out.println("Example : java -classpath htmlparser.jar com.kizna.parserapplications.MailRipper http://htmlparser.sourceforge.net");
            System.out.println();
            System.out.println("If you have any doubts, please join the HTMLParser mailing list (user/developer) from the HTML Parser home page instead of mailing any of the contributors directly. You will be surprised with the quality of open source support. ");
            System.exit(-1);
        }
        String resourceLocation = "http://htmlparser.sourceforge.net";
        if (args.length != 0) {
            resourceLocation = args[0];
        }
        MailRipper ripper = new MailRipper(resourceLocation);
        System.out.println("Ripping Site ".concat(String.valueOf(String.valueOf(resourceLocation))));
        try {
            Enumeration e = ripper.rip();
            while (e.hasMoreElements()) {
                HTMLLinkTag tag = (HTMLLinkTag)e.nextElement();
                System.out.println("Ripped mail address : ".concat(String.valueOf(String.valueOf(tag.getLink()))));
            }
        }
        catch (HTMLParserException e) {
            e.printStackTrace();
        }
    }

    public Enumeration rip() throws HTMLParserException {
        Vector<HTMLLinkTag> mailAddresses = new Vector<HTMLLinkTag>();
        HTMLEnumeration e = this.parser.elements();
        while (e.hasMoreNodes()) {
            HTMLLinkTag linkTag;
            HTMLNode node = e.nextHTMLNode();
            if (!(node instanceof HTMLLinkTag) || !(linkTag = (HTMLLinkTag)node).isMailLink()) continue;
            mailAddresses.addElement(linkTag);
        }
        return mailAddresses.elements();
    }
}

