/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyFileX;
import com.trs.wcm.photo.IMagicImage;
import com.trs.wcm.photo.impl.JImageMarkUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import magick.ImageInfo;
import magick.MagickImage;
import magick.MontageInfo;
import magick.PixelPacket;

public class MagicImageImpl
implements IMagicImage {
    private byte[] m_btTempImageContent = null;
    private String m_sSrcFileName = null;
    private MagickImage m_oSrcMagickImage = null;
    private ImageInfo m_oSrcImageInfo = null;
    private Dimension m_oSrcImageDimension = null;
    private String m_sImageFileExt = null;

    @Override
    public byte[] addWaterMark(String _sWaterImageFile, int[] _pWarterMarkPos) throws Exception {
        String sWaterImageFile = CMyFileX.autoToAbsoluteFilePath(_sWaterImageFile);
        this.m_btTempImageContent = JImageMarkUtil.addImageMark(this.m_sSrcFileName, sWaterImageFile, _pWarterMarkPos);
        return this.m_btTempImageContent;
    }

    @Override
    public byte[] borderImage(String _sBoderColor, int _nWidth, int _nHeight) throws Exception {
        this.m_oSrcMagickImage.setBorderColor(PixelPacket.queryColorDatabase((String)_sBoderColor));
        MagickImage oTempMagickImage = this.m_oSrcMagickImage.borderImage(new Rectangle(0, 0, _nWidth, _nHeight));
        this.m_btTempImageContent = oTempMagickImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    @Override
    public double getHeight() throws Exception {
        return this.m_oSrcImageDimension.getHeight();
    }

    @Override
    public double getWidth() throws Exception {
        return this.m_oSrcImageDimension.getWidth();
    }

    @Override
    public void montageImages(String[] _pImageFileName, String _sImageTitle, String _sDstImageFile, String _sBgColor, String _sBorderColor, int _nBorderWidth) throws Exception {
        if (_pImageFileName == null || _pImageFileName.length == 0) {
            return;
        }
        MagickImage[] images = new MagickImage[_pImageFileName.length];
        for (int i = 0; i < images.length; ++i) {
            images[i] = this.createMagickImage(_pImageFileName[i]);
        }
        MagickImage seqImage = new MagickImage(images);
        MontageInfo montageInfo = new MontageInfo(new ImageInfo());
        if (_sImageTitle != null) {
            montageInfo.setTitle(_sImageTitle);
        }
        montageInfo.setBackgroundColor(PixelPacket.queryColorDatabase((String)_sBgColor));
        montageInfo.setBorderColor(PixelPacket.queryColorDatabase((String)_sBorderColor));
        montageInfo.setBorderWidth(_nBorderWidth);
        MagickImage montage = seqImage.montageImages(montageInfo);
        montage.setFileName(_sDstImageFile);
        montage.writeImage(new ImageInfo());
    }

    @Override
    public byte[] raiseImage(int _nWidth, int _nHeight, boolean _bRaised) throws Exception {
        MagickImage raisedImage = new MagickImage(this.m_oSrcImageInfo);
        raisedImage.raiseImage(new Rectangle(0, 0, _nWidth, _nHeight), _bRaised);
        this.m_btTempImageContent = raisedImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    @Override
    public byte[] rotateImage(double _dDegrees) throws Exception {
        MagickImage rotated = this.m_oSrcMagickImage.rotateImage(_dDegrees);
        this.m_btTempImageContent = rotated.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    @Override
    public byte[] scaleImage(int _nWidth, int _nHeight) throws Exception {
        int nHeight;
        if (_nHeight <= 0 && _nWidth <= 0) {
            throw new WCMException(I18NMessage.get(MagicImageImpl.class, "MagicImageImpl.label1", "\u53c2\u6570\u4f20\u5165\u6709\u8bef\uff01"));
        }
        int nWidth = _nWidth;
        if (nWidth <= 0) {
            nWidth = this.m_oSrcImageDimension.width * _nHeight / this.m_oSrcImageDimension.height;
        }
        if (nWidth == 0) {
            nWidth = 1;
        }
        if ((nHeight = _nHeight) <= 0) {
            nHeight = this.m_oSrcImageDimension.height * _nWidth / this.m_oSrcImageDimension.width;
        }
        if (nHeight == 0) {
            nHeight = 1;
        }
        MagickImage smallImage = this.m_oSrcMagickImage.scaleImage(nWidth, nHeight);
        this.m_oSrcImageInfo.setQuality(70);
        this.m_btTempImageContent = smallImage.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    @Override
    public void setBackgroundColor(String _sBgColor) throws Exception {
        this.m_oSrcMagickImage.setBackgroundColor(PixelPacket.queryColorDatabase((String)_sBgColor));
    }

    @Override
    public byte[] convertImageFormat(String _sNewImageFormat) throws Exception {
        this.m_oSrcMagickImage.setMagick(_sNewImageFormat);
        this.m_sImageFileExt = _sNewImageFormat;
        this.m_btTempImageContent = this.m_oSrcMagickImage.imageToBlob(new ImageInfo());
        return this.m_btTempImageContent;
    }

    @Override
    public void initMagicImage(String _sSrcFileName) throws Exception {
        this.m_btTempImageContent = null;
        this.m_sImageFileExt = null;
        this.m_sSrcFileName = CMyFileX.autoToAbsoluteFilePath(_sSrcFileName);
        this.m_oSrcImageInfo = new ImageInfo(this.m_sSrcFileName);
        this.m_oSrcMagickImage = new MagickImage(this.m_oSrcImageInfo);
        this.m_oSrcImageDimension = this.m_oSrcMagickImage.getDimension();
    }

    @Override
    public void setImageAttribute(String _sAttrName, String _sValue) throws Exception {
        this.m_oSrcMagickImage.setImageAttribute(_sAttrName, _sValue);
    }

    @Override
    public byte[] sharpenImage(double raduis, double sigma) throws Exception {
        MagickImage sharpened = this.m_oSrcMagickImage.sharpenImage(raduis, sigma);
        this.m_btTempImageContent = sharpened.imageToBlob(this.m_oSrcImageInfo);
        return this.m_btTempImageContent;
    }

    @Override
    public void writeImage() throws Exception {
        this.writeImage(this.m_sSrcFileName);
    }

    @Override
    public void writeImage(String _sNewDstFileName) throws Exception {
        if (this.m_btTempImageContent != null) {
            CMyFileX.writeFile(_sNewDstFileName, this.m_btTempImageContent);
            return;
        }
        if (this.m_oSrcMagickImage != null) {
            this.m_oSrcMagickImage.setFileName(_sNewDstFileName);
            this.m_oSrcMagickImage.writeImage(this.m_oSrcImageInfo);
        }
    }

    @Override
    public String writeImageToSystemTemp() throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFileName = filesMan.getNextFileName("ST", this.getOutputImageFileExt());
        String sFilePath = filesMan.mapFilePath(sFileName, 0) + sFileName;
        this.writeImage(sFilePath);
        return sFilePath;
    }

    private String getOutputImageFileExt() {
        if (this.m_sImageFileExt != null) {
            return this.m_sImageFileExt;
        }
        if (this.m_sSrcFileName == null) {
            return "jpg";
        }
        return CMyFile.extractFileExt(this.m_sSrcFileName);
    }

    @Override
    public int getSize() throws Exception {
        return this.m_oSrcMagickImage.sizeBlob();
    }

    private MagickImage createMagickImage(String _sImageFile) throws Exception {
        ImageInfo oSrcImageInfo = new ImageInfo(_sImageFile);
        return new MagickImage(oSrcImageInfo);
    }

    @Override
    public void setOutputImageFileExt(String _sImageFileExt) {
        this.m_sImageFileExt = _sImageFileExt;
    }

    @Override
    public String writeImageToWCMData(String _sPathFlag) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFileName = filesMan.getNextFileName(_sPathFlag, this.getOutputImageFileExt());
        String sAbsolutFile = filesMan.mapFilePath(sFileName, 0) + sFileName;
        this.writeImage(sAbsolutFile);
        return sFileName;
    }

    @Override
    public String getSrcImageFileName() {
        return this.m_sSrcFileName;
    }

    @Override
    public void scaleImage(int width, int height, String dstFile) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cropImage(int x, int y, int width, int height, String _sDstFile) throws Exception {
        MagickImage cropped = null;
        try {
            MagickImage imageMagick = new MagickImage(this.m_oSrcImageInfo);
            cropped = imageMagick.cropImage(new Rectangle(x, y, width, height));
            cropped.setFileName(_sDstFile);
            cropped.writeImage(this.m_oSrcImageInfo);
        }
        finally {
            if (cropped != null) {
                cropped.destroyImages();
            }
        }
    }
}

