/*
 * Decompiled with CFR 0.152.
 */
package com.trs.update.wcm;

import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.update.wcm.WCMUpdaterConstants;
import com.trs.util.MD5Digest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConflictFilesOfWCMMaker {
    private String m_sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
    private String m_sModifyFilePath;
    private Properties m_oAllFileMD5Properties;
    private Properties m_oExcludeFileProperties;
    private ArrayList m_arConflictFiles;
    private ArrayList m_arExcludePaths;
    private ArrayList m_arExcludeFiles;
    private static Logger logger = Logger.getLogger(ConflictFilesOfWCMMaker.class);
    private boolean m_bNotPrintCompareInfo = false;

    public ConflictFilesOfWCMMaker(String _sModifyFilePath) {
        this.m_sWCMPath = WCMUpdaterConstants.setStrEndWithPathFlag(this.m_sWCMPath);
        this.m_sModifyFilePath = _sModifyFilePath;
    }

    public ConflictFilesOfWCMMaker() {
        this.m_sModifyFilePath = this.m_sWCMPath = WCMUpdaterConstants.setStrEndWithPathFlag(this.m_sWCMPath);
    }

    public void updateMD5Properties(String _sTimestamp, String _updateFixPath) throws Exception {
        int nPos;
        String sSrcPropertiesFile = this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM;
        String sBackupPropertiesFile = sSrcPropertiesFile.substring(0, (nPos = sSrcPropertiesFile.lastIndexOf(File.separatorChar)) + 1) + _sTimestamp + File.separatorChar + sSrcPropertiesFile.substring(nPos + 1);
        if (!CMyFile.fileExists(sBackupPropertiesFile)) {
            CMyFile.copyFile(sSrcPropertiesFile, sBackupPropertiesFile);
        }
        Properties oProperties = new Properties();
        oProperties.load(new FileService(sSrcPropertiesFile).getInputStream());
        this.setNewMD5Properties(_updateFixPath, "", oProperties);
        oProperties.store(new FileService(sSrcPropertiesFile).getOutputStream(), "wcmapp file md5 digest.");
    }

    private void setNewMD5Properties(String _sFilePath, String _sLevelName, Properties _oProperties) {
        FileService oPath = new FileService(_sFilePath);
        if (!oPath.exists() || !oPath.isDirectory()) {
            return;
        }
        FileStore[] pFiles = oPath.listFiles();
        for (int i = 0; i < pFiles.length; ++i) {
            FileStore oCurrFileOrPath = pFiles[i];
            if (oCurrFileOrPath.getName().startsWith(".")) continue;
            if (oCurrFileOrPath.isDirectory()) {
                this.setNewMD5Properties(oCurrFileOrPath.getAbsolutePath(), _sLevelName + oCurrFileOrPath.getName() + '/', _oProperties);
                continue;
            }
            String sFileKey = _sLevelName + oCurrFileOrPath.getName();
            MD5Digest md5Digest = new MD5Digest(null, null);
            String sCurrMD5 = md5Digest.digest(oCurrFileOrPath);
            _oProperties.setProperty(sFileKey, sCurrMD5);
        }
    }

    public void updateMD5Properties(String _sTimestamp) throws Exception {
        if (this.m_arConflictFiles == null) {
            this.m_bNotPrintCompareInfo = true;
            this.compare();
        }
        String sSrcPropertiesFile = this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM;
        int nPos = sSrcPropertiesFile.lastIndexOf(File.separatorChar);
        String sBackupPropertiesFile = sSrcPropertiesFile.substring(0, nPos + 1) + _sTimestamp + File.separatorChar + sSrcPropertiesFile.substring(nPos + 1);
        CMyFile.copyFile(sSrcPropertiesFile, sBackupPropertiesFile);
        Properties oProperties = new Properties();
        oProperties.load(new FileService(sSrcPropertiesFile).getInputStream());
        int nSize = this.m_arConflictFiles.size();
        for (int i = 0; i < nSize; ++i) {
            String sConflictFileName = (String)this.m_arConflictFiles.get(i);
            String sAbsoluteCnflictFileName = this.m_sWCMPath + sConflictFileName;
            MD5Digest md5Digest = new MD5Digest(null, null);
            String sNewMD5 = md5Digest.digest(sAbsoluteCnflictFileName);
            oProperties.setProperty(sConflictFileName, sNewMD5);
        }
        oProperties.store(new FileService(sSrcPropertiesFile).getOutputStream(), "wcmapp file md5 digest.");
    }

    public ArrayList compare() throws Exception {
        this.init();
        this.compare(this.m_sModifyFilePath, "");
        return this.m_arConflictFiles;
    }

    private void init() throws IOException, FileNotFoundException, CMyException {
        this.m_arConflictFiles = new ArrayList();
        this.m_oAllFileMD5Properties = new Properties();
        if (!CMyFile.fileExists(this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM)) {
            CMyFile.copyFile(this.m_sWCMPath + WCMUpdaterConstants.DEFAULT_FILE_MD5_WCM, this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM);
        }
        this.m_oAllFileMD5Properties.load(new FileService(this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM).getInputStream());
        this.m_oExcludeFileProperties = new Properties();
        if (!CMyFile.fileExists(this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM_EXCLUDE)) {
            CMyFile.copyFile(this.m_sWCMPath + WCMUpdaterConstants.DEFAULT_FILE_MD5_WCM_EXCLUDE, this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM_EXCLUDE);
        }
        this.m_oExcludeFileProperties.load(new FileService(this.m_sWCMPath + WCMUpdaterConstants.FILE_MD5_WCM_EXCLUDE).getInputStream());
        String[] pExcludePath = this.m_oExcludeFileProperties.getProperty("NEED_IGNORE_PATHS").split("\\,");
        this.m_arExcludePaths = new ArrayList(pExcludePath.length);
        for (int i = 0; i < pExcludePath.length; ++i) {
            this.m_arExcludePaths.add(pExcludePath[i].trim());
        }
        String[] pExcludeFile = this.m_oExcludeFileProperties.getProperty("NEED_IGNORE_FILES").split("\\,");
        this.m_arExcludeFiles = new ArrayList(pExcludeFile.length);
        for (int i = 0; i < pExcludeFile.length; ++i) {
            this.m_arExcludeFiles.add(pExcludeFile[i].trim());
        }
    }

    private boolean isIgnorePath(String _sParentPath, String _sCurrPathName) {
        if ("app/application/".equals(_sParentPath)) {
            try {
                Integer.parseInt(_sCurrPathName);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_arExcludePaths.contains(_sParentPath + _sCurrPathName);
    }

    private boolean isIgnoreFile(String _sFileName) {
        return this.m_arExcludeFiles.contains(_sFileName);
    }

    private void compare(String _sCurrFilePath, String _sLevelName) {
        FileService oPath = new FileService(_sCurrFilePath);
        if (!oPath.exists() || !oPath.isDirectory()) {
            return;
        }
        FileStore[] pFiles = oPath.listFiles();
        for (int i = 0; i < pFiles.length; ++i) {
            String sSrcMD5;
            MD5Digest md5Digest;
            String sCurrMD5;
            FileStore oCurrFileOrPath = pFiles[i];
            if (oCurrFileOrPath.getName().startsWith(".")) continue;
            if (oCurrFileOrPath.isDirectory()) {
                boolean bIgnore = this.isIgnorePath(_sLevelName, oCurrFileOrPath.getName());
                if (bIgnore) continue;
                this.compare(oCurrFileOrPath.getAbsolutePath(), _sLevelName + oCurrFileOrPath.getName() + '/');
                continue;
            }
            String sFileKey = _sLevelName + oCurrFileOrPath.getName();
            if (this.isIgnoreFile(sFileKey) || (sCurrMD5 = (md5Digest = new MD5Digest(null, null)).digest(oCurrFileOrPath)).equals(sSrcMD5 = this.m_oAllFileMD5Properties.getProperty(sFileKey))) continue;
            this.m_arConflictFiles.add(sFileKey);
            if (this.m_bNotPrintCompareInfo) continue;
            if (sSrcMD5 == null) {
                logger.info((Object)("\u3010" + sFileKey + "\u3011\u4e3a\u9879\u76ee\u65b0\u589e\uff01"));
                continue;
            }
            logger.info((Object)("\u3010" + sFileKey + "\u3011\u4e3a\u9879\u76ee\u5b9a\u5236\uff01"));
        }
    }
}

