/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.scm.domain.ISCMAccountMgr;
import com.trs.scm.domain.ISCMGroupMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroups;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class SCMAccountServiceProvider
implements IGlueServiceProvider {
    private ISCMAccountMgr m_oSCMAccountMgr = (ISCMAccountMgr)DreamFactory.createObjectById("ISCMAccountMgr");
    private ISCMGroupMgr m_oSCMGroupMgr = (ISCMGroupMgr)DreamFactory.createObjectById("ISCMGroupMgr");

    @Override
    public void delete(MethodContext _oContext) throws Throwable {
        String sAccountIds;
        User oLoginUser = this.getLoginUser();
        Accounts oAccounts = Accounts.findByIds(oLoginUser, sAccountIds = _oContext.getValue("ObjectIds"));
        if (oAccounts.size() <= 0) {
            throw new WCMException("\u627e\u4e0d\u5230\u60a8\u8981\u5220\u9664\u7684\u8d26\u53f7\uff01[IDS=" + sAccountIds + "]");
        }
        for (int i = 0; i < oAccounts.size(); ++i) {
            Account oAccount = (Account)oAccounts.getAt(i);
            if (oAccount == null) continue;
            SCMGroups oSCMGroups = this.m_oSCMGroupMgr.getGroups(oAccount);
            if (!this.hasRightInGroups(oLoginUser, oSCMGroups, 3)) {
                throw new WCMException("\u60a8\u5bf9\u5e10\u53f7\u6240\u5c5e\u7684\u6240\u6709\u5206\u7ec4\u6ca1\u6709\u5168\u90e8\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u8d26\u53f7\uff01");
            }
            this.m_oSCMAccountMgr.delete(oAccount);
        }
    }

    private boolean hasRightInGroups(User _oUser, SCMGroups _oSCMGroups, int _nRightIndex) throws Exception {
        int nSize = _oSCMGroups.size();
        for (int i = 0; i < nSize; ++i) {
            SCMGroup oSCMGroup = (SCMGroup)_oSCMGroups.getAt(i);
            if (oSCMGroup == null || SCMAuthServer.hasRight(_oUser, oSCMGroup, _nRightIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object query(MethodContext _oContext) throws Throwable {
        WCMFilter oFilter = _oContext.getExtraWCMFilter();
        return this.m_oSCMAccountMgr.query(oFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int save(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("ObjectId", 0);
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 1);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        Account oAccount = Account.createNewInstance();
        if (nAccountId != 0) {
            oAccount = this.m_oSCMAccountMgr.findById(nAccountId);
            if (oAccount == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u5e10\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
            }
            if (!SCMAuthServer.hasRight(oLoginUser, oAccount, 42)) {
                throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u65e0\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
            }
            oAccount.validCanEditAndLock(oLoginUser);
        }
        try {
            String[] pLogicFields = new String[]{"ObjectId"};
            oAccount = (Account)WCMAJAXServiceHelper.setWCMObjectProperties(oLoginUser, _oContext, oAccount, pLogicFields);
            oAccount.setPropertyWithString("Appkey", _oContext.getValue("Appkey"));
            oAccount = this.m_oSCMAccountMgr.save(oAccount);
            this.m_oSCMGroupMgr.addAccountToGroup(oAccount, oSCMGroup);
            int n = oAccount.getId();
            return n;
        }
        finally {
            if (oAccount.isLocked()) {
                try {
                    oAccount.unlock();
                }
                catch (Exception e) {
                    throw new WCMException("\u89e3\u9501\u5bf9\u8c61\u65f6\u51fa\u73b0\u5f02\u5e38" + nAccountId);
                }
            }
        }
    }

    public Accounts findAccountsOfUser(MethodContext _oContext) throws Throwable {
        int nUserId = _oContext.getValue("UserId", 0);
        User oUser = User.findById(nUserId);
        if (oUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01[ID=" + nUserId + "]");
        }
        Accounts oAccounts = this.m_oSCMAccountMgr.findAccountsForUser(oUser);
        return oAccounts;
    }

    public Accounts findAccountsOfGroup(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u8d26\u53f7\u7ec4\u4e0d\u5b58\u5728\uff01[ID=" + nSCMGroupId + "]");
        }
        if (!SCMAuthServer.hasRight(oLoginUser, oSCMGroup, 5)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u5206\u7ec4\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nSCMGroupId + "]");
        }
        return this.m_oSCMAccountMgr.findAccountsByGroup(oSCMGroup);
    }

    @Override
    public Object findById(MethodContext _oContext) throws Throwable {
        int nAccountId;
        Account oAccount;
        User oLoginUser = this.getLoginUser();
        if (!SCMAuthServer.hasRight(oLoginUser, oAccount = Account.findById(nAccountId = _oContext.getValue("ObjectId", 0)), 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        return oAccount;
    }

    public Accounts findByUId(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        String nAccountId = _oContext.getValue("UId");
        Accounts oAccounts = new Accounts(oLoginUser);
        WCMFilter filter = new WCMFilter("", "MICROUID=?", "");
        filter.addSearchValues(0, nAccountId);
        oAccounts.open(filter);
        return oAccounts;
    }

    @Override
    public Object findByIds(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        String sAccountIds = _oContext.getValue("ObjectIds");
        Accounts oAccounts = Accounts.findByIds(oLoginUser, sAccountIds);
        int nSize = oAccounts.size();
        for (int i = 0; i < nSize; ++i) {
            Account oAccount = (Account)oAccounts.getAt(i);
            if (oAccount == null || SCMAuthServer.hasRight(oLoginUser, oAccount, 44)) continue;
            throw new Exception("\u60a8\u6ca1\u6709\u64cd\u4f5c\u8be5\u8d26\u53f7\u96c6\u5408\u7684\u6743\u9650\u3002[Account=" + oAccount.getAccountName() + "]");
        }
        return oAccounts;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

