/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DefaultWhereSQLMaker {
    private static Logger logger = Logger.getLogger(DefaultWhereSQLMaker.class);
    private String m_sSearchTable;
    private String m_sSearchKey;
    private String m_sSearchValue;
    private String m_sWhereSQL = null;
    private List m_listSearchValues = null;

    public DefaultWhereSQLMaker(String _sSearchTable, String _sSearchKey, String _sSearchValue) {
        this.m_sSearchTable = _sSearchTable;
        this.m_sSearchKey = _sSearchKey;
        this.m_sSearchValue = _sSearchValue;
    }

    public List getSearchValues() {
        return this.m_listSearchValues;
    }

    public void setSearchValues(List searchValues) {
        this.m_listSearchValues = searchValues;
    }

    public String getWhereSQL() {
        return this.m_sWhereSQL;
    }

    public void setWhereSQL(String whereSQL) {
        this.m_sWhereSQL = whereSQL;
    }

    public void makeWhereSQL() throws WCMException {
        if (this.m_sSearchTable == null || this.m_sSearchTable.length() == 0) {
            return;
        }
        if (this.m_sSearchKey == null || this.m_sSearchKey.length() == 0) {
            return;
        }
        if (this.m_sSearchValue == null || this.m_sSearchValue.length() == 0) {
            return;
        }
        this.m_listSearchValues = new ArrayList();
        StringTokenizer stKeys = new StringTokenizer(this.m_sSearchKey, ",");
        String sWhere = "";
        boolean bFirst = true;
        String[] searchTables = CMyString.split(this.m_sSearchTable, ",");
        while (stKeys.hasMoreTokens()) {
            String sKey = stKeys.nextToken();
            for (int i = 0; i < searchTables.length; ++i) {
                if (bFirst) {
                    sWhere = this.makeSingleWhereSQL(searchTables[i], sKey, this.m_sSearchValue);
                    bFirst = sWhere == null || sWhere.length() == 0;
                    continue;
                }
                String temp = this.makeSingleWhereSQL(searchTables[i], sKey, this.m_sSearchValue);
                if (temp == null || temp.length() <= 0) continue;
                sWhere = sWhere + " or " + temp;
            }
        }
        this.setWhereSQL(sWhere);
    }

    private String makeSingleWhereSQL(String _sDBTableName, String _sFieldName, String _sSearchValue) throws WCMException {
        DBManager dbManager = DBManager.getDBManager();
        DBType dbType = dbManager.getDBType();
        FieldInfo currFieldInfo = dbManager.getFieldInfo(_sDBTableName, _sFieldName);
        if (currFieldInfo == null) {
            return null;
        }
        String[] pValues = CMyString.split(CMyString.filterForSQL(_sSearchValue), " ");
        String sWhereSQL = "(";
        boolean bFirst = true;
        for (int i = 0; i < pValues.length; ++i) {
            if (pValues[i].length() <= 0) continue;
            String sSearchValue = pValues[i];
            if (!bFirst) {
                sWhereSQL = sWhereSQL + " and ";
            } else {
                bFirst = false;
            }
            Object oValue = null;
            try {
                switch (currFieldInfo.getDataType().getType()) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        oValue = Integer.valueOf(sSearchValue);
                        sWhereSQL = sWhereSQL + _sFieldName + "=?";
                        break;
                    }
                    case 6: {
                        oValue = Float.valueOf(sSearchValue);
                        sWhereSQL = sWhereSQL + _sFieldName + "=?";
                        break;
                    }
                    case 8: {
                        oValue = Double.valueOf(sSearchValue);
                        sWhereSQL = sWhereSQL + _sFieldName + "=?";
                        break;
                    }
                    case 91: {
                        break;
                    }
                    case 2005: {
                        oValue = dbType.getType() == 2 || dbType.getType() == 6 ? '%' + sSearchValue + '%' : sSearchValue;
                        sWhereSQL = sWhereSQL + dbType.sqlFilterForClob(_sFieldName, "?");
                        break;
                    }
                    default: {
                        oValue = '%' + sSearchValue + '%';
                        sWhereSQL = sWhereSQL + _sFieldName + " like ? ";
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(DefaultWhereSQLMaker.class, "DefaultWhereSQLMaker.label1", "\u6784\u9020[") + _sFieldName + I18NMessage.get(DefaultWhereSQLMaker.class, "DefaultWhereSQLMaker.label2", "]\u7684\u68c0\u7d22\u6761\u4ef6\u6709\u8bef\uff01")), (Throwable)e);
                return null;
            }
            if (sWhereSQL == null || sWhereSQL.length() <= 0) continue;
            this.m_listSearchValues.add(oValue);
        }
        sWhereSQL = sWhereSQL + ')';
        return sWhereSQL;
    }
}

