/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import java.util.ArrayList;

public class TreeNodeCalctor {
    private Channels m_srcChannels = null;
    private User m_oLoginUser = null;
    private String m_sChannelIds = null;
    private WebSites m_oSites = null;
    private WebSite m_oRoot = null;
    private int m_nChannelId = 0;
    private TreeNodeCalctor[] m_pNeedExpandTreeNodes = null;
    private int[] m_pNeedExpandTreeNodeIds = null;
    private int m_nNeedExpandTreeNodeCount = 0;
    private int m_nMaxChildCount = 0;

    public TreeNodeCalctor(String _sChannelIds, User _loginUser) {
        this.m_oLoginUser = _loginUser;
        this.m_sChannelIds = _sChannelIds;
        try {
            this.initRoot();
        }
        catch (Exception e) {
            throw new RuntimeException(I18NMessage.get(TreeNodeCalctor.class, "TreeNodeCalctor.label1", "\u521d\u59cb\u5316\u5bf9\u8c61\u5931\u8d25\uff01"), e);
        }
    }

    public TreeNodeCalctor(WebSite _site, Channels _srcChannels) {
        this.m_oRoot = _site;
        this.m_srcChannels = _srcChannels;
        this.m_nMaxChildCount = _srcChannels.size();
        this.m_pNeedExpandTreeNodeIds = new int[this.m_nMaxChildCount];
        this.m_pNeedExpandTreeNodes = new TreeNodeCalctor[this.m_nMaxChildCount];
        try {
            this.initSiteChildren();
        }
        catch (Exception e) {
            throw new RuntimeException(I18NMessage.get(TreeNodeCalctor.class, "TreeNodeCalctor.label2", "\u521d\u59cb\u5316\u7ad9\u70b9\u5b50\u5bf9\u8c61\u5931\u8d25\uff01"), e);
        }
    }

    public TreeNodeCalctor(int _nChannelId, int _nChildMaxCount) {
        this.m_nChannelId = _nChannelId;
        this.m_nMaxChildCount = _nChildMaxCount;
        this.m_pNeedExpandTreeNodeIds = new int[_nChildMaxCount];
        this.m_pNeedExpandTreeNodes = new TreeNodeCalctor[_nChildMaxCount];
    }

    private TreeNodeCalctor addNeedExpandNode(int _nChannelId) {
        for (int i = 0; i < this.m_nNeedExpandTreeNodeCount; ++i) {
            if (this.m_pNeedExpandTreeNodeIds[i] != _nChannelId) continue;
            return this.m_pNeedExpandTreeNodes[i];
        }
        this.m_pNeedExpandTreeNodeIds[this.m_nNeedExpandTreeNodeCount] = _nChannelId;
        this.m_pNeedExpandTreeNodes[this.m_nNeedExpandTreeNodeCount] = new TreeNodeCalctor(_nChannelId, this.m_nMaxChildCount);
        ++this.m_nNeedExpandTreeNodeCount;
        return this.m_pNeedExpandTreeNodes[this.m_nNeedExpandTreeNodeCount - 1];
    }

    private int[] extractPathIds(Channel _channel) throws Exception {
        int[] pPathIds = new int[100];
        int nPathCount = 0;
        for (Channel parent = _channel.getParent(); parent != null; parent = parent.getParent()) {
            pPathIds[nPathCount] = parent.getId();
            ++nPathCount;
        }
        int[] pResult = new int[nPathCount];
        for (int i = nPathCount - 1; i >= 0; --i) {
            pResult[nPathCount - i - 1] = pPathIds[i];
        }
        return pResult;
    }

    private void initSiteChildren() throws Exception {
        for (int i = this.m_srcChannels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)this.m_srcChannels.getAt(i);
            if (channel == null || channel.getSiteId() != this.m_oRoot.getId()) continue;
            int[] pPathIds = this.extractPathIds(channel);
            TreeNodeCalctor currNode = this;
            for (int j = 0; j < pPathIds.length; ++j) {
                currNode = currNode.addNeedExpandNode(pPathIds[j]);
            }
            this.m_srcChannels.removeAt(i, false);
        }
    }

    private void initRoot() throws Exception {
        int i;
        this.m_srcChannels = Channels.findByIds(this.m_oLoginUser, this.m_sChannelIds);
        ArrayList<Object> lTempChannelId = new ArrayList<Object>(this.m_srcChannels.size());
        this.m_oSites = new WebSites(this.m_oLoginUser, this.m_srcChannels.size(), 1);
        for (i = this.m_srcChannels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)this.m_srcChannels.getAt(i);
            if (channel == null) continue;
            if (this.m_oSites.indexOf(channel.getSiteId()) < 0) {
                this.m_oSites.addElement(channel.getSiteId());
            }
            if (channel.getParentId() == 0) {
                this.m_srcChannels.removeAt(i, false);
                continue;
            }
            Object parent = channel.getProperty("PARENTID");
            if (lTempChannelId.contains(parent)) {
                this.m_srcChannels.removeAt(i, false);
                continue;
            }
            lTempChannelId.add(parent);
        }
        lTempChannelId.clear();
        this.m_nNeedExpandTreeNodeCount = this.m_oSites.size();
        this.m_pNeedExpandTreeNodes = new TreeNodeCalctor[this.m_nNeedExpandTreeNodeCount];
        this.m_pNeedExpandTreeNodeIds = new int[this.m_nNeedExpandTreeNodeCount];
        for (i = 0; i < this.m_nNeedExpandTreeNodeCount; ++i) {
            WebSite site = (WebSite)this.m_oSites.getAt(i);
            if (site == null) continue;
            this.m_pNeedExpandTreeNodeIds[i] = site.getId();
            this.m_pNeedExpandTreeNodes[i] = new TreeNodeCalctor(site, this.m_srcChannels);
        }
    }

    public int getChannelId() {
        return this.m_nChannelId;
    }

    public WebSites getSites() {
        return this.m_oSites;
    }

    public TreeNodeCalctor[] getNeedExpandTreeNodes() {
        return this.m_pNeedExpandTreeNodes;
    }

    public WebSite getRoot() {
        return this.m_oRoot;
    }

    public TreeNodeCalctor getExpandNodeById(int _nChannelId) {
        if (this.m_nNeedExpandTreeNodeCount <= 0) {
            return null;
        }
        for (int i = 0; i < this.m_nNeedExpandTreeNodeCount; ++i) {
            if (this.m_pNeedExpandTreeNodeIds[i] != _nChannelId) continue;
            return this.m_pNeedExpandTreeNodes[i];
        }
        return null;
    }
}

