/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class WcmIdFieldInit {
    private static final String TAB_CONF = "/table_idfield.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Connection conn) throws Exception {
        Class<?> clazz = this.getClass();
        InputStream ins = clazz.getResourceAsStream(TAB_CONF);
        if (ins == null) {
            ins = clazz.getResourceAsStream(TAB_CONF.substring(1));
        }
        Properties props = new Properties();
        if (ins != null) {
            try {
                props.load(ins);
                ins.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String sql = "select tablename,idfieldname from wcmid";
        Statement stmt = null;
        ResultSet rs = null;
        int size = props.isEmpty() ? 100 : props.size();
        HashSet<String> tabs = new HashSet<String>(size, 0.5f);
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String id = rs.getString(2);
                if (id != null && id.trim().length() != 0) continue;
                tabs.add(rs.getString(1).toUpperCase());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception id) {}
            }
        }
        sql = "update wcmid set idfieldname=? where tablename=?";
        PreparedStatement pstmt = null;
        DatabaseMetaData meta = null;
        try {
            pstmt = conn.prepareStatement(sql);
            meta = conn.getMetaData();
            for (String string : tabs) {
                String id = props.getProperty(string.toUpperCase());
                if (id == null) {
                    rs = meta.getPrimaryKeys(null, null, string);
                    if (rs.next()) {
                        id = rs.getString("COLUMN_NAME");
                    }
                    if (rs.next()) {
                        System.out.println(string + " has a pk with mul-columns");
                        rs.close();
                        continue;
                    }
                    rs.close();
                }
                if (id == null) {
                    System.out.println(string + " without pk.");
                    continue;
                }
                pstmt.setString(1, id);
                pstmt.setString(2, string);
                pstmt.executeUpdate();
                props.remove(string.toUpperCase());
            }
            pstmt.close();
            sql = "insert into WCMID(TABLENAME,NEXTID,CACHESIZE,IDFIELDNAME) values(?,0,1,?)";
            pstmt = conn.prepareStatement(sql);
            sql = "delete from WCMID where TABLENAME='#t'";
            props.put("WCMLOG", "LOGID");
            for (Map.Entry entry : props.entrySet()) {
                stmt.executeUpdate(sql.replaceAll("#t", (String)entry.getKey()));
                pstmt.setString(1, (String)entry.getKey());
                pstmt.setString(2, (String)entry.getValue());
                pstmt.executeUpdate();
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String url = args[0];
        String user = args[1];
        String passwd = args[2];
        String driver = args[3];
        WcmIdFieldInit initer = new WcmIdFieldInit();
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, user, passwd);
            initer.doAction(conn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

