/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade;

import com.trs.infra.util.store.FileService;
import com.trs.infra.util.upgrade.DbConfig;
import com.trs.infra.util.upgrade.dbcompare.MetaDataLoader;
import com.trs.infra.util.upgrade.dbcompare.SchemaCompare;
import com.trs.infra.util.upgrade.dbcompare.TableDiff;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMaker;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMakerFactory;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Main {
    private static final String CONF = "/database.conf";

    public static void main(String[] args) {
        Connection source = null;
        Connection dest = null;
        try {
            System.setOut(new PrintStream(new FileService("/e:/testdiff.txt").getOutputStream()));
            DbConfig conf = new DbConfig();
            conf.load(CONF);
            Class.forName(conf.getJdbcDriver());
            source = DriverManager.getConnection(conf.getOldUrl(), conf.getOldUser(), conf.getOldPasswd());
            dest = DriverManager.getConnection(conf.getNewUrl(), conf.getNewUser(), conf.getNewPasswd());
            MetaDataLoader olddb = new MetaDataLoader(source, conf.getOldSchema());
            MetaDataLoader newdb = new MetaDataLoader(dest, conf.getNewSchema());
            SchemaCompare compare = new SchemaCompare(olddb, newdb);
            Comparator tableDiffComparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    TableDiff diff0 = (TableDiff)arg0;
                    TableDiff diff1 = (TableDiff)arg1;
                    return diff0.getTableName().compareTo(diff1.getTableName());
                }
            };
            List list = compare.getDiff4Source();
            Collections.sort(list, tableDiffComparator);
            SchemaUpdSqlMaker sqlMaker = SchemaUpdSqlMakerFactory.makeSqlMaker(conf.getDbtype());
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Main.printMsg(sqlMaker.getSql((TableDiff)list.get(i)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printMsg(String[] msgs) {
        int len = msgs.length;
        for (int i = 0; i < len; ++i) {
            Main.printMsg(msgs[i]);
        }
    }

    private static void printMsg(String msg) {
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        System.out.println(msg);
    }
}

